/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.block;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.network.NetworkHooks;
import ovh.corail.recycler.gui.RecyclerMenu;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class BlockRecycler
extends HorizontalBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");

    public BlockRecycler() {
        this(BlockRecycler.getBuilder());
    }

    protected BlockRecycler(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149739_a() {
        return "corail_recycler.block.recycler";
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (Helper.isValidPlayer(player) && !player.func_175149_v()) {
            TileEntityRecycler recycler;
            if (!level.func_201670_d() && (recycler = BlockRecycler.getTileEntity(level, pos)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, p) -> new RecyclerMenu(id, playerInventory, recycler), (ITextComponent)new TranslationTextComponent("corail_recycler.block.recycler")), buf -> buf.func_179255_a(pos));
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.FAIL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, ENABLED});
    }

    @Nullable
    public static TileEntityRecycler getTileEntity(World level, BlockPos pos) {
        TileEntity tile = level.func_175625_s(pos);
        return tile instanceof TileEntityRecycler ? (TileEntityRecycler)tile : null;
    }

    public TileEntityRecycler createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRecycler();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, level, pos, oldState, isMoving);
        if (level instanceof ServerWorld) {
            ChunkPos chunkPos = new ChunkPos(pos);
            ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)level), (String)"corail_recycler", (BlockPos)pos, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (boolean)true, (boolean)false);
        }
    }

    public void func_196243_a(BlockState oldState, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityRecycler recycler;
        if (oldState.func_177230_c() != newState.func_177230_c() && (recycler = BlockRecycler.getTileEntity(level, pos)) != null) {
            IntStream.range(0, recycler.getInventoryInput().getSlots()).forEach(slot -> InventoryHelper.func_180173_a((World)level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)recycler.getInventoryInput().getStackInSlot(slot)));
            IntStream.range(0, recycler.getInventoryWorking().getSlots()).forEach(slot -> InventoryHelper.func_180173_a((World)level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)recycler.getInventoryWorking().getStackInSlot(slot)));
            IntStream.range(0, recycler.getInventoryOutput().getSlots()).forEach(slot -> InventoryHelper.func_180173_a((World)level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)recycler.getInventoryOutput().getStackInSlot(slot)));
        }
        if (level instanceof ServerWorld && !oldState.func_203425_a(newState.func_177230_c())) {
            ChunkPos chunkPos = new ChunkPos(pos);
            ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)level), (String)"corail_recycler", (BlockPos)pos, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (boolean)false, (boolean)false);
        }
        super.func_196243_a(oldState, level, pos, newState, isMoving);
    }

    public static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(5.0f, 20.0f).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).harvestLevel(0).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)ENABLED) != false ? 15 : 0);
    }
}

