/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ItemInput;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.command.ModIdArgument;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.recipe.SimpleStack;

public class CommandRecycler {
    private static final SuggestionProvider<CommandSource> SUGGESTION_MODID = (ctx, build) -> ISuggestionProvider.func_197005_b((Iterable)ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList()), (SuggestionsBuilder)build);

    private static int processAddRecipe(CommandContext<CommandSource> context) throws IllegalArgumentException {
        SimpleStack ingredient = CommandRecycler.createStack(context, "ing");
        NonNullList results = NonNullList.func_191196_a();
        int id = 1;
        while (id < 10) {
            try {
                results.add((Object)CommandRecycler.createStack(context, "r" + id));
                ++id;
            }
            catch (IllegalArgumentException e) {
                id = 10;
            }
        }
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f() : null;
        RecyclingRecipe recipe = new RecyclingRecipe(ingredient, (NonNullList<SimpleStack>)results);
        if (recipe.isValid() && RecyclingManager.INSTANCE.addUserDefinedRecipe(recipe)) {
            LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return 0;
    }

    private static int processDiscoverRecipe(CommandContext<CommandSource> context, ItemStack stack) {
        ServerPlayerEntity player = CommandRecycler.getPlayerOrNull((CommandSource)context.getSource());
        if (stack.func_190926_b() && player != null) {
            stack = player.func_184614_ca();
        }
        if (!stack.func_190926_b() && RecyclingManager.INSTANCE.discoverRecipe(((CommandSource)context.getSource()).func_197023_e(), stack)) {
            LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return 0;
    }

    private static int processRemoveRecipe(CommandContext<CommandSource> context, ItemStack stack) {
        ServerPlayerEntity player = CommandRecycler.getPlayerOrNull((CommandSource)context.getSource());
        if (stack.func_190926_b() && player != null) {
            stack = player.func_184614_ca();
        }
        if (!stack.func_190926_b() && RecyclingManager.INSTANCE.removeRecipe(stack)) {
            LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_REMOVE_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
        return 0;
    }

    private static int processExportCraftingRecipes(CommandContext<CommandSource> context) {
        Optional<String> modid = CommandRecycler.getModidOrNull(context);
        Predicate<Map.Entry> predic = modid.isPresent() ? entry -> ((String)modid.get()).equals(((ResourceLocation)entry.getKey()).func_110624_b()) : entry -> true;
        RecyclingManager rm = RecyclingManager.INSTANCE;
        List list = ((CommandSource)context.getSource()).func_197023_e().func_199532_z().func_215366_a(IRecipeType.field_222149_a).entrySet().stream().filter(predic).map(Map.Entry::getValue).filter(recipe -> Helper.isValidRecipe(recipe) && rm.getRecipe(recipe.func_77571_b(), false) == null).map(JsonRecyclingRecipe::new).collect(Collectors.toList());
        ServerPlayerEntity player = CommandRecycler.getPlayerOrNull((CommandSource)context.getSource());
        LangKey.MESSAGE_FOUND_RECIPES.sendMessage((PlayerEntity)player, list.size());
        if (list.size() > 0) {
            File path = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_recycler");
            if (modid.isPresent()) {
                path = new File(path, modid.get());
            }
            path.mkdirs();
            File exportFile = new File(path, "export_crafting_recipes.json");
            boolean success = Helper.saveAsJson(exportFile, list);
            (success ? LangKey.MESSAGE_EXPORT_SUCCESS : LangKey.MESSAGE_EXPORT_FAILED).sendMessage((PlayerEntity)player, new Object[0]);
        }
        return 1;
    }

    private static int showUsage(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("recycler <command>"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("discover_recipe : add the recycling recipe of the crafting result of the item hold in main hand"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("remove_recipe : remove the recycling recipe of the item hold in main hand"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("export_crafting_recipes [modid] : save the list of all crafting recipes in \"recycling\" format in the config directory"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("add_recipe : add a custom recipe based on the ingredient and results provided in param <item> <count>"), false);
        return 1;
    }

    public static void registerCommand(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder createRecipeBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.ADD_RECIPE.func_176610_l()).executes(CommandRecycler::showUsage);
        createRecipeBuilder.then(CommandRecycler.createItemArgument("ing").then(CommandRecycler.createIntegerArgument("ingc", null).then(CommandRecycler.createItemArgument("r1").then(CommandRecycler.createIntegerArgument("r1c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r2").then(CommandRecycler.createIntegerArgument("r2c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r3").then(CommandRecycler.createIntegerArgument("r3c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r4").then(CommandRecycler.createIntegerArgument("r4c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r5").then(CommandRecycler.createIntegerArgument("r5c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r6").then(CommandRecycler.createIntegerArgument("r6c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r7").then(CommandRecycler.createIntegerArgument("r7c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r8").then(CommandRecycler.createIntegerArgument("r8c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r9").then(CommandRecycler.createIntegerArgument("r9c", (Command<CommandSource>)((Command)CommandRecycler::processAddRecipe))))))))))))))))))))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"recycler").requires(p -> p.func_197034_c(2))).executes(CommandRecycler::showUsage)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.DISCOVER_RECIPE.func_176610_l()).executes(c -> CommandRecycler.processDiscoverRecipe((CommandContext<CommandSource>)c, ItemStack.field_190927_a))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(c -> CommandRecycler.processDiscoverRecipe((CommandContext<CommandSource>)c, ItemArgument.func_197316_a((CommandContext)c, (String)"item").func_197320_a(1, false)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.REMOVE_RECIPE.func_176610_l()).executes(c -> CommandRecycler.processRemoveRecipe((CommandContext<CommandSource>)c, ItemStack.field_190927_a))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(c -> CommandRecycler.processRemoveRecipe((CommandContext<CommandSource>)c, ItemArgument.func_197316_a((CommandContext)c, (String)"item").func_197320_a(1, false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)CommandAction.EXPORT_CRAFTING_RECIPES.func_176610_l()).executes(CommandRecycler::processExportCraftingRecipes)).then((ArgumentBuilder)Commands.func_197056_a((String)"modid", (ArgumentType)ModIdArgument.modIdArgument()).suggests(SUGGESTION_MODID))).executes(CommandRecycler::processExportCraftingRecipes))).then((ArgumentBuilder)createRecipeBuilder));
    }

    private static RequiredArgumentBuilder<CommandSource, ItemInput> createItemArgument(String itemName) {
        return (RequiredArgumentBuilder)Commands.func_197056_a((String)itemName, (ArgumentType)ItemArgument.func_197317_a()).executes(CommandRecycler::showUsage);
    }

    private static RequiredArgumentBuilder<CommandSource, Integer> createIntegerArgument(String intName, @Nullable Command<CommandSource> action) {
        return (RequiredArgumentBuilder)Commands.func_197056_a((String)intName, (ArgumentType)IntegerArgumentType.integer()).executes(action == null ? CommandRecycler::showUsage : action);
    }

    private static SimpleStack createStack(CommandContext<CommandSource> context, String name) {
        return new SimpleStack(ItemArgument.func_197316_a(context, (String)name).func_197319_a(), IntegerArgumentType.getInteger(context, (String)(name + "c")));
    }

    private static Optional<String> getModidOrNull(CommandContext<CommandSource> source) {
        try {
            String modid = (String)source.getArgument("modid", String.class);
            if (modid != null) {
                return Optional.of(modid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Nullable
    private static ServerPlayerEntity getPlayerOrNull(CommandSource source) {
        return source.func_197022_f() instanceof ServerPlayerEntity ? (ServerPlayerEntity)source.func_197022_f() : null;
    }

    private static enum CommandAction implements IStringSerializable
    {
        DISCOVER_RECIPE,
        REMOVE_RECIPE,
        EXPORT_CRAFTING_RECIPES,
        ADD_RECIPE;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

