/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.gui.SlotWorking;
import ovh.corail.recycler.registry.ModMenuTypes;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class RecyclerMenu
extends Container {
    private final TileEntityRecycler recycler;
    private final IIntArray recyclerData;

    protected RecyclerMenu(ContainerType<? extends RecyclerMenu> containerType, int windowId, PlayerInventory playerInventory, TileEntityRecycler recycler) {
        super(containerType, windowId);
        this.recycler = recycler;
        recycler.giveRecyclingBook();
        this.recyclerData = new TileEntityRecycler.RecyclerData(recycler);
        this.func_216961_a(this.recyclerData);
        this.addSlots(playerInventory);
        this.recycler.updateRecyclingRecipe();
    }

    public RecyclerMenu(int windowId, PlayerInventory playerInventory, TileEntityRecycler recycler) {
        this(ModMenuTypes.RECYCLER, windowId, playerInventory, recycler);
    }

    public RecyclerMenu(int windowId, PlayerInventory playerInventory, BlockPos pos) {
        this(windowId, playerInventory, (TileEntityRecycler)Objects.requireNonNull(playerInventory.field_70458_d.field_70170_p.func_175625_s(pos)));
    }

    public RecyclerMenu(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, data.func_179259_c());
    }

    public boolean isWorking() {
        return this.recyclerData.func_221476_a(0) == 1;
    }

    public int getProgress() {
        return this.recyclerData.func_221476_a(1);
    }

    public int getInputMax() {
        return this.recyclerData.func_221476_a(2);
    }

    public int getEnergy() {
        return this.recyclerData.func_221476_a(3);
    }

    public BlockPos getPosition() {
        return this.recycler.func_174877_v();
    }

    public TileEntityRecycler getRecycler() {
        return this.recycler;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 39 ? !this.func_75135_a(itemstack1, 39, 74, true) : index < 75 && !this.func_75135_a(itemstack1, 3, 20, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    private void addSlots(PlayerInventory playerInventory) {
        int x;
        int y;
        this.func_75146_a((Slot)new SlotWorking(this, 0, 81, 69, TileEntityRecycler.EnumSlot.ITEM.predicate));
        this.func_75146_a((Slot)new SlotWorking(this, 1, 96, 91, TileEntityRecycler.EnumSlot.DISK.predicate));
        this.func_75146_a((Slot)new SlotWorking(this, 2, 66, 91, TileEntityRecycler.EnumSlot.BOOK.predicate));
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryInput(), x + y * 3, x * 18 + 7, y * 18 + 8));
            }
        }
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryOutput(), x + y * 3, x * 18 + 173, y * 18 + 8));
            }
        }
        InvWrapper inventPlayer = new InvWrapper((IInventory)playerInventory);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)inventPlayer, x + y * 9, x * 18 + 7, y == 0 ? 178 : y * 18 + 102));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryVisual(), x + y * 3, x * 18 + 110, y * 18 + 8, p -> false, false));
            }
        }
    }
}

