/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.registry.ModTriggers;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class ServerRecyclerMessage {
    private final RecyclerAction action;
    private final BlockPos pos;

    public ServerRecyclerMessage(RecyclerAction action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    static ServerRecyclerMessage fromBytes(PacketBuffer buf) {
        return new ServerRecyclerMessage(RecyclerAction.values()[buf.readShort()], buf.func_179259_c());
    }

    static void toBytes(ServerRecyclerMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        buf.func_179255_a(msg.pos);
    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    TileEntityRecycler recycler;
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null && (recycler = BlockRecycler.getTileEntity(player.field_70170_p, message.pos)) != null) {
                        switch (message.action) {
                            case RECYCLE: {
                                if (!recycler.recycle(player)) break;
                                ModTriggers.FIRST_RECYCLE.trigger(player);
                                break;
                            }
                            case SWITCH_AUTO: {
                                recycler.switchWorking();
                                break;
                            }
                            case TAKE_ALL: {
                                player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(p -> {
                                    ItemStackHandler inventOutput = recycler.getInventoryOutput();
                                    IntStream.range(0, inventOutput.getSlots()).filter(slot -> !inventOutput.getStackInSlot(slot).func_190926_b()).forEach(slot -> inventOutput.setStackInSlot(slot, ItemHandlerHelper.insertItemStacked((IItemHandler)p, (ItemStack)inventOutput.getStackInSlot(slot), (boolean)false)));
                                });
                                break;
                            }
                            case DISCOVER_RECIPE: {
                                ItemStack stack = recycler.getInventoryWorking().getStackInSlot(0);
                                if (!stack.func_190926_b() && (((Boolean)ConfigRecycler.shared_general.permanent_discover_button.get()).booleanValue() || player.func_211513_k(2)) && RecyclingManager.INSTANCE.discoverRecipe(player.func_71121_q(), stack)) {
                                    recycler.updateRecyclingRecipe();
                                    LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
                                    break;
                                }
                                LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
                                break;
                            }
                            case REMOVE_RECIPE: {
                                ItemStack stack = recycler.getInventoryWorking().getStackInSlot(0);
                                if (!stack.func_190926_b() && (((Boolean)ConfigRecycler.shared_general.permanent_discover_button.get()).booleanValue() || player.func_211513_k(2)) && RecyclingManager.INSTANCE.removeRecipe(stack)) {
                                    recycler.resetLastRecipe();
                                    recycler.updateRecyclingRecipe();
                                    LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
                                    break;
                                }
                                LangKey.MESSAGE_REMOVE_RECIPE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum RecyclerAction {
        RECYCLE,
        SWITCH_AUTO,
        TAKE_ALL,
        DISCOVER_RECIPE,
        REMOVE_RECIPE;

    }
}

