/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecipeLoaderHelper;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.recipe.SimpleStack;
import ovh.corail.recycler.registry.ModBlocks;
import ovh.corail.recycler.registry.ModItems;

public class RecyclingManager {
    public static final RecyclingManager INSTANCE = new RecyclingManager();
    private final Set<RecyclingRecipe> recipes = ConcurrentHashMap.newKeySet();
    private final Set<Item> deniedItems = ConcurrentHashMap.newKeySet();
    private final List<ImmutablePair<SimpleStack, SimpleStack>> grindList = new ArrayList<ImmutablePair<SimpleStack, SimpleStack>>();
    private final File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_recycler");
    private final File deniedFile = new File(this.configDir, "denied_recipes.json");
    private final File userDefinedFile = new File(this.configDir, "user_defined_recipes.json");
    private final File grindFile = new File(this.configDir, "grind_list.json");

    private RecyclingManager() {
        if (!this.configDir.exists() && !this.configDir.mkdir()) {
            ModRecycler.LOGGER.warn("Impossible to create the config folder");
        }
    }

    public boolean discoverRecipe(ServerWorld level, ItemStack stack) {
        RecyclingRecipe recipe = this.getRecipe(stack, false);
        if (recipe != null) {
            return this.setDeniedRecipe(recipe, false);
        }
        recipe = level.func_199532_z().func_215366_a(IRecipeType.field_222149_a).values().stream().filter(cr -> Helper.areItemEqual(cr.func_77571_b(), stack) && Helper.isValidRecipe(cr)).map(r -> new RecyclingRecipe((IRecipe<?>)r).setUserDefined(true)).findFirst().orElse(null);
        if (recipe != null && recipe.isValid()) {
            this.setDeniedRecipe(recipe, false);
            this.recipes.add(recipe);
            return this.saveUserDefinedRecipes();
        }
        return false;
    }

    public void loadRecipes() {
        this.clear();
        this.loadDenied();
        this.loadGrindList();
        if (((Boolean)ConfigRecycler.general.recycleEnchantedBook.get()).booleanValue()) {
            this.recipes.add(new RecyclingRecipe(new SimpleStack(Items.field_151134_bR), new SimpleStack[0]));
        }
        this.recipes.add(new RecyclingRecipe(new SimpleStack(ModBlocks.recycler), new SimpleStack[]{new SimpleStack(Items.field_151042_j, 4), new SimpleStack(Items.field_221586_n, 4), new SimpleStack(Items.field_221675_bZ)}));
        this.loadUserDefinedRecipes();
        RecipeLoaderHelper.loadDefaultRecipes(this.recipes);
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    private void clear() {
        this.recipes.clear();
        this.deniedItems.clear();
        this.grindList.clear();
    }

    private void loadDenied() {
        if (!this.deniedFile.exists()) {
            Stream.of(ModBlocks.recycler, Blocks.field_196650_c, Blocks.field_196654_e, Blocks.field_196656_g, Items.field_151121_aF, Items.field_151102_aT, Items.field_151061_bv, Items.field_151065_br, Items.field_151064_bs, Items.field_151059_bz, Blocks.field_196817_hS, Blocks.field_196814_hQ, Blocks.field_196650_c).forEach(itemLike -> {
                Item item;
                if (itemLike != null && (item = itemLike.func_199767_j()).getRegistryName() != null) {
                    this.deniedItems.add(item);
                }
            });
            this.saveDenied();
        } else {
            Helper.loadAsJson(this.deniedFile, String.class).forEach(rlString -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(rlString));
                if (item != Items.field_190931_a) {
                    this.deniedItems.add(item);
                }
            });
        }
    }

    private synchronized void saveDenied() {
        Helper.saveAsJson(this.deniedFile, this.deniedItems.stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList()));
    }

    public boolean isDeniedRecipe(RecyclingRecipe recipe) {
        return this.deniedItems.stream().anyMatch(recipe::isIngredient);
    }

    public boolean setDeniedRecipe(RecyclingRecipe recipe, boolean state) {
        recipe.setDenied(state);
        boolean denied = this.isDeniedRecipe(recipe);
        if (state != denied) {
            if (denied) {
                this.deniedItems.remove(recipe.getIngredient().getItem());
            } else {
                this.deniedItems.add(recipe.getIngredient().getItem());
            }
            this.saveDenied();
            return true;
        }
        return false;
    }

    public boolean addUserDefinedRecipe(RecyclingRecipe recipe) {
        this.recipes.remove(recipe);
        this.recipes.add(recipe.setUserDefined(true));
        return this.saveUserDefinedRecipes();
    }

    public boolean removeRecipe(ItemStack stack) {
        RecyclingRecipe recipe = this.getRecipe(stack, false);
        if (recipe == null) {
            return false;
        }
        if (recipe.isUserDefined()) {
            this.recipes.remove(recipe);
            this.saveUserDefinedRecipes();
        } else {
            this.setDeniedRecipe(recipe, true);
        }
        return true;
    }

    public List<RecyclingRecipe> getRecipesForSearch(String searchText) {
        return this.recipes.stream().filter(recipe -> !(recipe.isIngredient(Items.field_151134_bR) || recipe.isDenied() || !searchText.isEmpty() && !recipe.getIngredient().getTranslation().contains(searchText) || (Boolean)ConfigRecycler.general.onlyUserRecipes.get() != false && !recipe.isUserDefined())).sorted().collect(Collectors.toList());
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack) {
        return this.getRecipe(stack, true);
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack, boolean checked) {
        if (stack.func_190926_b() || checked && stack.func_77973_b() == Items.field_151134_bR && EnchantedBookItem.func_92110_g((ItemStack)stack).size() < 2) {
            return null;
        }
        RecyclingRecipe recipe = this.recipes.stream().filter(r -> r.isIngredient(stack)).findFirst().orElse(null);
        if (recipe == null) {
            return null;
        }
        if (checked) {
            if (((Boolean)ConfigRecycler.general.onlyUserRecipes.get()).booleanValue() && !recipe.isUserDefined()) {
                return null;
            }
            if (recipe.isDenied()) {
                return null;
            }
        }
        return recipe;
    }

    public NonNullList<ItemStack> getResultStack(ItemStack stack, int nb_input) {
        return this.getResultStack(stack, nb_input, false);
    }

    private SimpleStack getIngredient(SimpleStack stack, boolean withGrind) {
        if (withGrind) {
            for (ImmutablePair<SimpleStack, SimpleStack> grind : this.grindList) {
                if (!stack.is((SimpleStack)grind.getLeft())) continue;
                float ratio = (float)((SimpleStack)grind.getRight()).getCount() / (float)((SimpleStack)grind.getLeft()).getCount();
                new SimpleStack(((SimpleStack)grind.getRight()).getItem(), MathHelper.func_76141_d((float)(ratio * (float)stack.getCount())));
            }
        }
        return stack.copy();
    }

    public NonNullList<ItemStack> getResultStack(ItemStack stack, int nb_input, boolean withLoss) {
        NonNullList itemsList = NonNullList.func_191196_a();
        RecyclingRecipe currentRecipe = this.getRecipe(stack);
        if (currentRecipe == null) {
            return itemsList;
        }
        boolean isDamaged = stack.func_77958_k() > 0 && stack.func_77952_i() > 0;
        for (int i = 0; i < currentRecipe.getCount(); ++i) {
            SimpleStack ingredient = this.getIngredient(currentRecipe.getResult(i), isDamaged || withLoss);
            float modifiedSize = ingredient.getCount();
            if (isDamaged) {
                modifiedSize *= (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
            }
            if (withLoss) {
                modifiedSize /= 2.0f;
            }
            ingredient.setCount(((Boolean)ConfigRecycler.general.recycleRoundDown.get() != false ? MathHelper.func_76141_d((float)modifiedSize) : Math.round(modifiedSize)) * nb_input);
            ItemStack result = new ItemStack((IItemProvider)ingredient.getItem());
            int fullStackCount = ingredient.getCount() / result.func_77976_d();
            if (fullStackCount > 0) {
                result.func_190920_e(result.func_77976_d());
                IntStream.range(0, fullStackCount).forEach(aInt -> itemsList.add((Object)result.func_77946_l()));
                ingredient.shrink(fullStackCount * result.func_77976_d());
            }
            if (ingredient.getCount() <= 0) continue;
            result.func_190920_e(ingredient.getCount());
            itemsList.add((Object)result);
        }
        if (((Boolean)ConfigRecycler.general.recycleMagicItem.get()).booleanValue()) {
            itemsList.addAll(this.getEnchantedBooks(stack));
        }
        return itemsList;
    }

    private NonNullList<ItemStack> getEnchantedBooks(ItemStack stack) {
        Map<Enchantment, Integer> enchants = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(p -> p.getKey() != null && p.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        NonNullList books = NonNullList.func_191196_a();
        if (!enchants.isEmpty()) {
            if (stack.func_77973_b() == Items.field_151134_bR) {
                if (enchants.size() < 2) {
                    return books;
                }
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                    EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                    books.add((Object)currentBook);
                }
            } else {
                ItemStack currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData(entry.getKey(), entry.getValue().intValue()));
                }
                books.add((Object)currentBook);
            }
        }
        return books;
    }

    private void loadGrindList() {
        if (!this.grindFile.exists()) {
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.field_234759_km_), (Object)new SimpleStack(ModItems.netherite_nugget, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.field_151045_i), (Object)new SimpleStack(ModItems.diamond_shard, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.field_151042_j), (Object)new SimpleStack(Items.field_191525_da, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.field_151043_k), (Object)new SimpleStack(Items.field_151074_bl, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.field_151116_aA), (Object)new SimpleStack(Items.field_179555_bs, 4)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Blocks.field_196662_n), (Object)new SimpleStack(Items.field_151055_y, 4)));
            Helper.saveAsJson(this.grindFile, this.grindList.stream().map(p -> ImmutablePair.of((Object)((SimpleStack)p.getLeft()).toString(), (Object)((SimpleStack)p.getRight()).toString())).collect(Collectors.toList()));
        } else {
            Type token = new TypeToken<List<ImmutablePair<String, String>>>(){}.getType();
            List<ImmutablePair> jsonList = Helper.loadAsJson(this.grindFile, token);
            for (ImmutablePair pair : jsonList) {
                SimpleStack input = SimpleStack.fromJson((String)pair.getLeft());
                SimpleStack output = SimpleStack.fromJson((String)pair.getRight());
                if (input.isEmpty() || output.isEmpty()) continue;
                this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)input, (Object)output));
            }
        }
    }

    public synchronized boolean saveUserDefinedRecipes() {
        return Helper.saveAsJson(this.userDefinedFile, this.recipes.stream().filter(recipe -> recipe.isUserDefined() && recipe.isValid()).map(JsonRecyclingRecipe::new).collect(Collectors.toList()));
    }

    private void loadUserDefinedRecipes() {
        Object jsonRecipesList;
        if (!this.userDefinedFile.exists()) {
            jsonRecipesList = NonNullList.func_191196_a();
            Helper.saveAsJson(this.userDefinedFile, jsonRecipesList);
        } else {
            jsonRecipesList = Helper.loadAsJson(this.userDefinedFile, JsonRecyclingRecipe.class);
        }
        Iterator iterator = jsonRecipesList.iterator();
        while (iterator.hasNext()) {
            JsonRecyclingRecipe jsonRecipe = (JsonRecyclingRecipe)iterator.next();
            RecyclingRecipe recipe = new RecyclingRecipe(jsonRecipe);
            if (!recipe.ingredient.isEmpty() && recipe.getCount() > 0) {
                recipe.setUserDefined(true);
                this.recipes.add(recipe);
                continue;
            }
            ModRecycler.LOGGER.warn("Error while reading json recipe : " + jsonRecipe.inputItem);
        }
    }
}

