/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.tileentity;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.registry.ModItems;
import ovh.corail.recycler.registry.ModSounds;
import ovh.corail.recycler.registry.ModTags;
import ovh.corail.recycler.registry.ModTileEntityTypes;

public class TileEntityRecycler
extends TileEntity
implements ITickableTileEntity,
INameable {
    private final ItemStackHandler inventInput = new ItemStackHandlerAutoSaved(18);
    private final ItemStackHandler inventWorking = new RecyclerWorkingStackHandler();
    private final ItemStackHandler inventOutput = new ItemStackHandlerAutoSaved(18);
    private final ItemStackHandler inventVisual = new ItemStackHandler(9);
    private final EnergyStorage energyStorage = this.createEnergyStorage();
    private RecyclingRecipe lastRecipe = null;
    private String customName;
    private boolean isWorking = false;
    private int countTicks = 0;
    private int progress = 0;
    private int inputMax = 0;
    private int cantRecycleTicks = 0;
    private boolean recyclingBookGift = false;
    private LazyOptional<?> holderInventInput = LazyOptional.of(() -> this.inventInput);
    private LazyOptional<?> holderInventOutput = LazyOptional.of(() -> this.inventOutput);
    private LazyOptional<?> holderEnergyStorage = LazyOptional.of(() -> this.energyStorage);

    public TileEntityRecycler() {
        super(ModTileEntityTypes.RECYCLER);
    }

    public ItemStackHandler getInventoryInput() {
        return this.inventInput;
    }

    public ItemStackHandler getInventoryWorking() {
        return this.inventWorking;
    }

    public ItemStackHandler getInventoryOutput() {
        return this.inventOutput;
    }

    public ItemStackHandler getInventoryVisual() {
        return this.inventVisual;
    }

    public boolean isOutputEmpty() {
        return IntStream.range(0, this.inventOutput.getSlots()).allMatch(slot -> this.inventOutput.getStackInSlot(slot).func_190926_b());
    }

    private void transferSlotWorking() {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)this.inventWorking.extractItem(0, this.inventWorking.getStackInSlot(0).func_190916_E(), false), (boolean)false);
    }

    public boolean recycle(@Nullable ServerPlayerEntity player) {
        assert (this.field_145850_b != null);
        RecyclingManager recyclingManager = RecyclingManager.INSTANCE;
        ItemStack workingStack = this.inventWorking.getStackInSlot(0);
        ItemStack diskStack = this.inventWorking.getStackInSlot(1);
        ItemStack bookStack = this.inventWorking.getStackInSlot(2);
        if (workingStack.func_190926_b() || diskStack.func_190926_b()) {
            return false;
        }
        RecyclingRecipe recipe = recyclingManager.getRecipe(workingStack);
        if (recipe == null) {
            this.transferSlotWorking();
            return false;
        }
        int nb_input = this.getMaxRecycle(recipe);
        if (nb_input == 0) {
            return false;
        }
        if (this.isWorking) {
            nb_input = 1;
        }
        int loss = 0;
        if ((Integer)ConfigRecycler.general.chanceLoss.get() > 0) {
            int res = Helper.RANDOM.nextInt(100 * nb_input);
            if (res < (Integer)ConfigRecycler.general.chanceLoss.get() * nb_input) {
                loss = MathHelper.func_76141_d((float)((float)res / (float)((Integer)ConfigRecycler.general.chanceLoss.get()).intValue() * (float)nb_input));
            }
            if (loss > 0) {
                LangKey.MESSAGE_LOSS.sendMessage((PlayerEntity)player, new Object[0]);
            }
        }
        NonNullList result = NonNullList.func_191196_a();
        if (loss < nb_input) {
            result.addAll(recyclingManager.getResultStack(workingStack, nb_input - loss));
        }
        if (loss > 0) {
            result.addAll(recyclingManager.getResultStack(workingStack, loss, true));
        }
        Helper.mergeStackInList((NonNullList<ItemStack>)result);
        if (!Helper.canInsertInInventory((IItemHandlerModifiable)this.inventOutput, (NonNullList<ItemStack>)result)) {
            LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        result.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)stack, (boolean)false));
        int diskDamage = 10 * nb_input;
        if (diskStack.func_77952_i() + diskDamage >= diskStack.func_77958_k()) {
            LangKey.MESSAGE_BROKEN_DISK.sendMessage((PlayerEntity)player, new Object[0]);
            this.inventWorking.setStackInSlot(1, ItemStack.field_190927_a);
        } else {
            diskStack.func_196085_b(diskStack.func_77952_i() + diskDamage);
        }
        bookStack.func_190918_g(this.getBookCount(workingStack) * nb_input);
        workingStack.func_190918_g(nb_input * recipe.getIngredient().getCount());
        ModSounds.playSoundAllAround(ModSounds.RECYCLER, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
        if (this.inventWorking.getStackInSlot(0).func_190926_b()) {
            this.updateRecyclingRecipe();
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        if (Helper.atInterval(this.field_145850_b, 10)) {
            int slotId;
            ItemStack stackToRecycle = this.inventWorking.getStackInSlot(0);
            boolean requireRecipeUpdate = false;
            if (stackToRecycle.func_190926_b()) {
                slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> {
                    ItemStack stackInSlot = this.inventInput.getStackInSlot(slot);
                    return !stackInSlot.func_190926_b() && this.inventWorking.isItemValid(0, stackInSlot);
                }).findFirst().orElse(-1);
                if (slotId >= 0) {
                    this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId, this.inventInput.getStackInSlot(slotId).func_190916_E(), false), false);
                    requireRecipeUpdate = true;
                }
            } else if (stackToRecycle.func_77985_e() && stackToRecycle.func_190916_E() < stackToRecycle.func_77976_d() && (slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> Helper.areItemEqual(stackToRecycle, this.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                this.inventWorking.insertItem(0, this.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (this.inventWorking.getStackInSlot(1).func_190926_b() && (slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> this.inventWorking.isItemValid(1, this.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                this.inventWorking.insertItem(1, this.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (this.inventWorking.getStackInSlot(2).func_190916_E() < this.inventWorking.getSlotLimit(2) && (slotId = IntStream.range(0, this.inventInput.getSlots()).filter(slot -> this.inventWorking.isItemValid(2, this.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                this.inventWorking.insertItem(2, this.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (requireRecipeUpdate) {
                this.updateRecyclingRecipe();
            }
        }
        RecyclingRecipe baseRecipe = this.lastRecipe != null && this.lastRecipe.isIngredient(this.inventWorking.getStackInSlot(0)) ? this.lastRecipe : (this.lastRecipe = RecyclingManager.INSTANCE.getRecipe(this.inventWorking.getStackInSlot(0)));
        this.inputMax = this.getMaxRecycle(baseRecipe);
        if (!this.isWorking) {
            return;
        }
        if (!((Boolean)ConfigRecycler.shared_general.allow_automation.get()).booleanValue()) {
            this.updateWorking(false);
            return;
        }
        if (this.energyStorage.getEnergyStored() >= 10) {
            this.energyStorage.extractEnergy(10, false);
            this.countTicks -= 2;
        } else {
            --this.countTicks;
        }
        int maxTicks = (Integer)ConfigRecycler.general.timeToRecycle.get();
        if (this.inputMax < 1) {
            ++this.cantRecycleTicks;
            this.countTicks = maxTicks;
        }
        if (this.cantRecycleTicks > 40) {
            if (!this.inventWorking.getStackInSlot(0).func_190926_b()) {
                this.transferSlotWorking();
            }
            this.updateWorking(false);
            this.cantRecycleTicks = 0;
            this.countTicks = maxTicks;
        }
        if (this.countTicks <= 0) {
            if (!this.recycle(null)) {
                ++this.cantRecycleTicks;
            }
            this.countTicks = maxTicks;
        } else if (this.cantRecycleTicks <= 1 && Helper.atInterval(this.countTicks, 15)) {
            ModSounds.playSoundAllAround(ModSounds.RECYCLER_WORKING, SoundCategory.BLOCKS, this.field_145850_b, this.field_174879_c, 0.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
            for (int i = 0; i < 4; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + Helper.RANDOM.nextDouble(), (double)this.field_174879_c.func_177956_o() + Helper.RANDOM.nextDouble(), (double)this.field_174879_c.func_177952_p() + Helper.RANDOM.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        this.progress = (maxTicks - this.countTicks) * 100 / maxTicks;
    }

    public int getMaxRecycle(@Nullable RecyclingRecipe recipe) {
        ItemStack ingredient;
        int maxRecycle;
        if (recipe != null && (maxRecycle = (ingredient = this.inventWorking.getStackInSlot(0)).func_190916_E() / Math.max(recipe.getIngredient().getCount(), 1)) > 0) {
            int bookCount;
            ItemStack disk = this.inventWorking.getStackInSlot(1);
            if (disk.func_190926_b()) {
                return 0;
            }
            maxRecycle = Math.min(maxRecycle, (disk.func_77958_k() - disk.func_77952_i()) / 10);
            if (ingredient.func_77948_v() && (bookCount = this.getBookCount(ingredient)) > 0) {
                maxRecycle = Math.min(maxRecycle, this.inventWorking.getStackInSlot(2).func_190916_E() / bookCount);
            }
            return maxRecycle;
        }
        return 0;
    }

    public int getBookCount(ItemStack stack) {
        ListNBT list;
        String tagName;
        boolean isEnchantedBook = stack.func_77973_b() == Items.field_151134_bR;
        String string = tagName = isEnchantedBook ? "StoredEnchantments" : "Enchantments";
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(tagName, 9) && !(list = stack.func_77978_p().func_150295_c(tagName, 10)).isEmpty()) {
            return isEnchantedBook ? list.size() : 1;
        }
        return 0;
    }

    public void updateRecyclingRecipe() {
        int slotId;
        RecyclingRecipe recipe = RecyclingManager.INSTANCE.getRecipe(this.getInventoryWorking().getStackInSlot(0));
        boolean hasRecipe = recipe != null;
        NonNullList<ItemStack> currentRecipe = hasRecipe ? RecyclingManager.INSTANCE.getResultStack(this.getInventoryWorking().getStackInSlot(0), 1) : NonNullList.func_191196_a();
        if (hasRecipe) {
            for (slotId = 0; slotId < Math.min(currentRecipe.size(), this.inventVisual.getSlots()); ++slotId) {
                if (((ItemStack)currentRecipe.get(slotId)).func_77973_b() == this.inventVisual.getStackInSlot(slotId).func_77973_b()) continue;
                this.inventVisual.setStackInSlot(slotId, (ItemStack)currentRecipe.get(slotId));
            }
        }
        while (slotId < this.inventVisual.getSlots()) {
            if (!this.inventVisual.getStackInSlot(slotId).func_190926_b()) {
                this.inventVisual.setStackInSlot(slotId, ItemStack.field_190927_a);
            }
            ++slotId;
        }
        this.progress = 0;
        this.inputMax = this.getMaxRecycle(recipe);
    }

    public void resetLastRecipe() {
        this.lastRecipe = null;
    }

    public void switchWorking() {
        this.updateWorking(!this.isWorking);
    }

    public void updateWorking(boolean isWorking) {
        this.setProgress(0);
        if (isWorking != this.isWorking) {
            this.isWorking = isWorking;
            Optional.ofNullable(this.field_145850_b).ifPresent(l -> l.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockRecycler.ENABLED, (Comparable)Boolean.valueOf(isWorking))));
        }
    }

    public void setProgress(int progress) {
        if (progress == 0) {
            this.countTicks = (Integer)ConfigRecycler.general.timeToRecycle.get();
        }
        this.progress = progress;
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent("corail_recyclerblock.recycler.name");
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TranslationTextComponent(this.customName) : this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_145818_k_() ? new TranslationTextComponent(this.customName) : null;
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return side == Direction.DOWN ? this.holderInventOutput.cast() : this.holderInventInput.cast();
            }
            if (cap == CapabilityEnergy.ENERGY) {
                return this.holderEnergyStorage.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holderInventInput.invalidate();
        this.holderInventOutput.invalidate();
        this.holderEnergyStorage.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.holderInventInput = LazyOptional.of(() -> this.inventInput);
        this.holderInventOutput = LazyOptional.of(() -> this.inventOutput);
        this.holderEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("invent_input", (INBT)this.inventInput.serializeNBT());
        compound.func_218657_a("invent_working", (INBT)this.inventWorking.serializeNBT());
        compound.func_218657_a("invent_output", (INBT)this.inventOutput.serializeNBT());
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        compound.func_74768_a("count_ticks", this.countTicks);
        compound.func_74757_a("is_working", this.isWorking);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("cant_recycle_ticks", this.cantRecycleTicks);
        INBT nbt = CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null);
        if (nbt != null) {
            compound.func_218657_a("energy", nbt);
        }
        compound.func_74757_a("recycling_book_gift", this.recyclingBookGift);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventInput.deserializeNBT(compound.func_74775_l("invent_input"));
        CompoundNBT compoundInventWorking = compound.func_74775_l("invent_working");
        if (compoundInventWorking.func_150297_b("Size", 3)) {
            compoundInventWorking.func_74768_a("Size", EnumSlot.values().length);
        }
        this.inventWorking.deserializeNBT(compoundInventWorking);
        this.inventOutput.deserializeNBT(compound.func_74775_l("invent_output"));
        if (compound.func_150297_b("custom_name", 8)) {
            this.customName = compound.func_74779_i("custom_name");
        }
        this.countTicks = compound.func_74762_e("count_ticks");
        this.isWorking = compound.func_74767_n("is_working");
        this.progress = compound.func_74762_e("progress");
        this.cantRecycleTicks = compound.func_74762_e("cant_recycle_ticks");
        if (compound.func_74764_b("energy")) {
            CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, compound.func_74781_a("energy"));
        }
        this.recyclingBookGift = compound.func_74767_n("recycling_book_gift");
    }

    public void giveRecyclingBook() {
        if (!this.recyclingBookGift) {
            this.recyclingBookGift = true;
            ItemHandlerHelper.insertItem((IItemHandler)this.inventOutput, (ItemStack)new ItemStack((IItemProvider)ModItems.recycling_book), (boolean)false);
        }
    }

    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(10000, 20, 10){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int receiveEnergy = super.receiveEnergy(maxReceive, simulate);
                TileEntityRecycler.this.func_70296_d();
                return receiveEnergy;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int extractEnergy = super.extractEnergy(maxExtract, simulate);
                TileEntityRecycler.this.func_70296_d();
                return extractEnergy;
            }
        };
    }

    public class RecyclerData
    implements IIntArray {
        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityRecycler.this.isWorking ? 1 : 0;
                }
                case 1: {
                    return TileEntityRecycler.this.progress;
                }
                case 2: {
                    return TileEntityRecycler.this.inputMax;
                }
                case 3: {
                    return TileEntityRecycler.this.energyStorage.getEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityRecycler.this.isWorking = value > 0;
                }
                case 1: {
                    TileEntityRecycler.this.progress = value;
                }
                case 2: {
                    TileEntityRecycler.this.inputMax = value;
                }
                case 3: {
                    int diff = value - TileEntityRecycler.this.energyStorage.getEnergyStored();
                    if (diff >= 0) {
                        TileEntityRecycler.this.energyStorage.receiveEnergy(diff, false);
                        break;
                    }
                    TileEntityRecycler.this.energyStorage.extractEnergy(-diff, false);
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    }

    private class ItemStackHandlerAutoSaved
    extends ItemStackHandler {
        public ItemStackHandlerAutoSaved(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityRecycler.this.func_70296_d();
        }
    }

    public class RecyclerWorkingStackHandler
    extends ItemStackHandlerAutoSaved {
        public RecyclerWorkingStackHandler() {
            super(EnumSlot.values().length);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot >= 0 && slot < EnumSlot.values().length && EnumSlot.values()[slot].predicate.test(stack);
        }
    }

    public static enum EnumSlot {
        ITEM(p -> Items.field_151122_aG != p.func_77973_b() && !ModTags.Items.disks.func_230235_a_((Object)p.func_77973_b())),
        DISK(p -> ModTags.Items.disks.func_230235_a_((Object)p.func_77973_b())),
        BOOK(p -> Items.field_151122_aG == p.func_77973_b());

        public final Predicate<ItemStack> predicate;

        private EnumSlot(Predicate<ItemStack> predicate) {
            this.predicate = predicate;
        }
    }
}

