/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler;

import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.recycler.command.CommandRecycler;
import ovh.corail.recycler.compatibility.CompatibilityQuark;
import ovh.corail.recycler.compatibility.SupportMods;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.config.RecyclerModConfig;
import ovh.corail.recycler.gui.GuiRecycler;
import ovh.corail.recycler.gui.GuiRecyclingBook;
import ovh.corail.recycler.network.ClientProxy;
import ovh.corail.recycler.network.IProxy;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerProxy;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.registry.ModMenuTypes;
import ovh.corail.recycler.registry.ModTabs;
import ovh.corail.recycler.registry.ModTags;
import ovh.corail.recycler.registry.ModTriggers;

@Mod(value="corail_recycler")
public class ModRecycler {
    public static final String MOD_ID = "corail_recycler";
    public static final String MOD_NAME = "Corail Recycler";
    public static final String MOD_VER = "5.3.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"corail_recycler");
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public ModRecycler() {
        Reflection.initialize((Class[])new Class[]{PacketHandler.class, ModTriggers.class, ModTags.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        this.registerSharedConfig(context);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigRecycler.GENERAL_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        PROXY.preInit();
    }

    private void registerSharedConfig(ModLoadingContext context) {
        context.getActiveContainer().addConfig((ModConfig)new RecyclerModConfig(ConfigRecycler.SHARED_GENERAL_SPEC, context.getActiveContainer()));
    }

    @SubscribeEvent
    public void onRegisterCommand(RegisterCommandsEvent event) {
        CommandRecycler.registerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        RecyclingManager.INSTANCE.loadRecipes();
        LOGGER.info(RecyclingManager.INSTANCE.getRecipeCount() + " recycling recipes loaded");
    }

    private void clientInit(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ModMenuTypes.RECYCLER, (MenuScreens.ScreenConstructor)(SupportMods.QUARK.isLoaded() ? CompatibilityQuark.ButtonIgnoredScreen::new : GuiRecycler::new));
        MenuScreens.m_96206_(ModMenuTypes.RECYCLING_BOOK, GuiRecyclingBook::new);
    }
}

