/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.advancement;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import ovh.corail.recycler.advancement.ITriggerable;
import ovh.corail.recycler.advancement.StatelessCriterion;

public class AbstractTrigger
implements CriterionTrigger<StatelessCriterion>,
ITriggerable {
    private final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<StatelessCriterion>>> listeners = Maps.newIdentityHashMap();
    private final ResourceLocation rl;
    private final BiFunction<JsonObject, DeserializationContext, StatelessCriterion> factory;

    public AbstractTrigger(String name) {
        this(new ResourceLocation("corail_recycler", name));
    }

    public AbstractTrigger(ResourceLocation rl) {
        this(rl, (json, parser) -> new StatelessCriterion(rl));
    }

    public AbstractTrigger(ResourceLocation rl, BiFunction<JsonObject, DeserializationContext, StatelessCriterion> factory) {
        this.rl = rl;
        this.factory = factory;
    }

    public ResourceLocation m_7295_() {
        return this.rl;
    }

    public void m_6467_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<StatelessCriterion> listener) {
        this.listeners.computeIfAbsent(playerAdvancements, advancements -> Sets.newHashSet()).add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<StatelessCriterion> listener) {
        Set<CriterionTrigger.Listener<StatelessCriterion>> set = this.listeners.get(playerAdvancements);
        if (set != null && set.remove(listener) && set.isEmpty()) {
            this.listeners.remove(playerAdvancements);
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public StatelessCriterion createInstance(JsonObject json, DeserializationContext context) {
        return this.factory.apply(json, context);
    }

    @Override
    public void trigger(ServerPlayer player) {
        this.trigger(player, instance -> true);
    }

    public void trigger(ServerPlayer player, Predicate<StatelessCriterion> predic) {
        PlayerAdvancements playeradvancements = player.m_8960_();
        Set<CriterionTrigger.Listener<StatelessCriterion>> set = this.listeners.get(playeradvancements);
        if (set != null && !set.isEmpty()) {
            List<CriterionTrigger.Listener> list = set.stream().filter(l -> predic.test((StatelessCriterion)l.m_13685_())).toList();
            list.forEach(l -> l.m_13686_(playeradvancements));
        }
    }
}

