/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.block;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import ovh.corail.recycler.gui.RecyclerMenu;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.registry.ModTileEntityTypes;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class BlockRecycler
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.m_61465_((String)"enabled");

    public BlockRecycler() {
        this(BlockRecycler.getBuilder());
    }

    protected BlockRecycler(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String m_7705_() {
        return "corail_recycler.block.recycler";
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (Helper.isValidPlayer(player) && !player.m_5833_()) {
            TileEntityRecycler recycler;
            if (!level.m_5776_() && (recycler = BlockRecycler.getTileEntity(level, pos)) != null) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, playerInventory, p) -> new RecyclerMenu(id, playerInventory, recycler), (Component)new TranslatableComponent("corail_recycler.block.recycler")), buf -> buf.m_130064_(pos));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, ENABLED});
    }

    @Nullable
    public static TileEntityRecycler getTileEntity(Level level, BlockPos pos) {
        BlockEntity tile = level.m_7702_(pos);
        return tile instanceof TileEntityRecycler ? (TileEntityRecycler)tile : null;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (level instanceof ServerLevel) {
            ChunkPos chunkPos = new ChunkPos(pos);
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)level), (String)"corail_recycler", (BlockPos)pos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)false);
        }
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityRecycler recycler;
        if (oldState.m_60734_() != newState.m_60734_() && (recycler = BlockRecycler.getTileEntity(level, pos)) != null) {
            IntStream.range(0, recycler.getInventoryInput().getSlots()).forEach(slot -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)recycler.getInventoryInput().getStackInSlot(slot)));
            IntStream.range(0, recycler.getInventoryWorking().getSlots()).forEach(slot -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)recycler.getInventoryWorking().getStackInSlot(slot)));
            IntStream.range(0, recycler.getInventoryOutput().getSlots()).forEach(slot -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)recycler.getInventoryOutput().getStackInSlot(slot)));
        }
        if (level instanceof ServerLevel && !oldState.m_60713_(newState.m_60734_())) {
            ChunkPos chunkPos = new ChunkPos(pos);
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)level), (String)"corail_recycler", (BlockPos)pos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)false, (boolean)false);
        }
        super.m_6810_(oldState, level, pos, newState, isMoving);
    }

    public static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(5.0f, 20.0f).m_60918_(SoundType.f_56742_).m_60999_().m_60953_(state -> (Boolean)state.m_61143_((Property)ENABLED) != false ? 15 : 0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityRecycler(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (!level.m_5776_()) {
            return BlockRecycler.createTickerHelper(entityType, ModTileEntityTypes.RECYCLER, TileEntityRecycler::serverTick);
        }
        return null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

