/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.command.ModIdArgument;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.recipe.SimpleStack;

public class CommandRecycler {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_MODID = (ctx, build) -> SharedSuggestionProvider.m_82970_(ModList.get().getMods().stream().map(IModInfo::getModId).toList(), (SuggestionsBuilder)build);

    private static int processAddRecipe(CommandContext<CommandSourceStack> context) throws IllegalArgumentException {
        SimpleStack ingredient = CommandRecycler.createStack(context, "ing");
        NonNullList results = NonNullList.m_122779_();
        int id = 1;
        while (id < 10) {
            try {
                results.add((Object)CommandRecycler.createStack(context, "r" + id));
                ++id;
            }
            catch (IllegalArgumentException e) {
                id = 10;
            }
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81373_() instanceof ServerPlayer ? (ServerPlayer)((CommandSourceStack)context.getSource()).m_81373_() : null;
        RecyclingRecipe recipe = new RecyclingRecipe(ingredient, (NonNullList<SimpleStack>)results);
        if (recipe.isValid() && RecyclingManager.INSTANCE.addUserDefinedRecipe(recipe)) {
            LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((Player)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((Player)player, new Object[0]);
        return 0;
    }

    private static int processDiscoverRecipe(CommandContext<CommandSourceStack> context, ItemStack stack) {
        ServerPlayer player = CommandRecycler.getPlayerOrNull((CommandSourceStack)context.getSource());
        if (stack.m_41619_() && player != null) {
            stack = player.m_21205_();
        }
        if (!stack.m_41619_() && RecyclingManager.INSTANCE.discoverRecipe(((CommandSourceStack)context.getSource()).m_81372_(), stack)) {
            LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((Player)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((Player)player, new Object[0]);
        return 0;
    }

    private static int processRemoveRecipe(CommandContext<CommandSourceStack> context, ItemStack stack) {
        ServerPlayer player = CommandRecycler.getPlayerOrNull((CommandSourceStack)context.getSource());
        if (stack.m_41619_() && player != null) {
            stack = player.m_21205_();
        }
        if (!stack.m_41619_() && RecyclingManager.INSTANCE.removeRecipe(stack)) {
            LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS.sendMessage((Player)player, new Object[0]);
            return 1;
        }
        LangKey.MESSAGE_REMOVE_RECIPE_FAILED.sendMessage((Player)player, new Object[0]);
        return 0;
    }

    private static int processExportCraftingRecipes(CommandContext<CommandSourceStack> context) {
        Optional<String> modid = CommandRecycler.getModidOrNull(context);
        Predicate<Map.Entry> predic = modid.isEmpty() ? entry -> true : entry -> ((String)modid.get()).equals(((ResourceLocation)entry.getKey()).m_135827_());
        RecyclingManager rm = RecyclingManager.INSTANCE;
        List<JsonRecyclingRecipe> list = ((CommandSourceStack)context.getSource()).m_81372_().m_7465_().m_44054_(RecipeType.f_44107_).entrySet().stream().filter(predic).map(Map.Entry::getValue).filter(recipe -> Helper.isValidRecipe(recipe) && rm.getRecipe(recipe.m_8043_(), false) == null).map(JsonRecyclingRecipe::new).toList();
        ServerPlayer player = CommandRecycler.getPlayerOrNull((CommandSourceStack)context.getSource());
        LangKey.MESSAGE_FOUND_RECIPES.sendMessage((Player)player, list.size());
        if (list.size() > 0) {
            File path = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_recycler");
            if (modid.isPresent()) {
                path = new File(path, modid.get());
            }
            path.mkdirs();
            File exportFile = new File(path, "export_crafting_recipes.json");
            boolean success = Helper.saveAsJson(exportFile, list);
            (success ? LangKey.MESSAGE_EXPORT_SUCCESS : LangKey.MESSAGE_EXPORT_FAILED).sendMessage((Player)player, new Object[0]);
        }
        return 1;
    }

    private static int showUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("recycler <command>"), false);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("discover_recipe : add the recycling recipe of the crafting result of the item hold in main hand"), false);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("remove_recipe : remove the recycling recipe of the item hold in main hand"), false);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("export_crafting_recipes [modid] : save the list of all crafting recipes in \"recycling\" format in the config directory"), false);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("add_recipe : add a custom recipe based on the ingredient and results provided in param <item> <count>"), false);
        return 1;
    }

    public static void registerCommand(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder createRecipeBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)CommandAction.ADD_RECIPE.m_7912_()).executes(CommandRecycler::showUsage);
        createRecipeBuilder.then(CommandRecycler.createItemArgument("ing").then(CommandRecycler.createIntegerArgument("ingc", null).then(CommandRecycler.createItemArgument("r1").then(CommandRecycler.createIntegerArgument("r1c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r2").then(CommandRecycler.createIntegerArgument("r2c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r3").then(CommandRecycler.createIntegerArgument("r3c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r4").then(CommandRecycler.createIntegerArgument("r4c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r5").then(CommandRecycler.createIntegerArgument("r5c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r6").then(CommandRecycler.createIntegerArgument("r6c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r7").then(CommandRecycler.createIntegerArgument("r7c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r8").then(CommandRecycler.createIntegerArgument("r8c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe)).then(CommandRecycler.createItemArgument("r9").then(CommandRecycler.createIntegerArgument("r9c", (Command<CommandSourceStack>)((Command)CommandRecycler::processAddRecipe))))))))))))))))))))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"recycler").requires(p -> p.m_6761_(2))).executes(CommandRecycler::showUsage)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)CommandAction.DISCOVER_RECIPE.m_7912_()).executes(c -> CommandRecycler.processDiscoverRecipe((CommandContext<CommandSourceStack>)c, ItemStack.f_41583_))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_120960_()).executes(c -> CommandRecycler.processDiscoverRecipe((CommandContext<CommandSourceStack>)c, ItemArgument.m_120963_((CommandContext)c, (String)"item").m_120980_(1, false)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)CommandAction.REMOVE_RECIPE.m_7912_()).executes(c -> CommandRecycler.processRemoveRecipe((CommandContext<CommandSourceStack>)c, ItemStack.f_41583_))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_120960_()).executes(c -> CommandRecycler.processRemoveRecipe((CommandContext<CommandSourceStack>)c, ItemArgument.m_120963_((CommandContext)c, (String)"item").m_120980_(1, false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)CommandAction.EXPORT_CRAFTING_RECIPES.m_7912_()).executes(CommandRecycler::processExportCraftingRecipes)).then((ArgumentBuilder)Commands.m_82129_((String)"modid", (ArgumentType)ModIdArgument.modIdArgument()).suggests(SUGGESTION_MODID))).executes(CommandRecycler::processExportCraftingRecipes))).then((ArgumentBuilder)createRecipeBuilder));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ItemInput> createItemArgument(String itemName) {
        return (RequiredArgumentBuilder)Commands.m_82129_((String)itemName, (ArgumentType)ItemArgument.m_120960_()).executes(CommandRecycler::showUsage);
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Integer> createIntegerArgument(String intName, @Nullable Command<CommandSourceStack> action) {
        return (RequiredArgumentBuilder)Commands.m_82129_((String)intName, (ArgumentType)IntegerArgumentType.integer()).executes(action == null ? CommandRecycler::showUsage : action);
    }

    private static SimpleStack createStack(CommandContext<CommandSourceStack> context, String name) {
        return new SimpleStack(ItemArgument.m_120963_(context, (String)name).m_120979_(), IntegerArgumentType.getInteger(context, (String)(name + "c")));
    }

    private static Optional<String> getModidOrNull(CommandContext<CommandSourceStack> source) {
        try {
            String modid = (String)source.getArgument("modid", String.class);
            if (modid != null) {
                return Optional.of(modid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Nullable
    private static ServerPlayer getPlayerOrNull(CommandSourceStack source) {
        return source.m_81373_() instanceof ServerPlayer ? (ServerPlayer)source.m_81373_() : null;
    }

    private static enum CommandAction implements StringRepresentable
    {
        DISCOVER_RECIPE,
        REMOVE_RECIPE,
        EXPORT_CRAFTING_RECIPES,
        ADD_RECIPE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

