/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.network.UpdateConfigMessage;

public class ConfigRecycler {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static final ForgeConfigSpec SHARED_GENERAL_SPEC;
    public static final General general;
    public static final SharedGeneral shared_general;

    private static String getTranslation(String name) {
        return "corail_recycler.config." + name;
    }

    public static UpdateConfigMessage getUpdatePacket() {
        return new UpdateConfigMessage((Boolean)ConfigRecycler.shared_general.allow_automation.get(), (Boolean)ConfigRecycler.shared_general.permanent_discover_button.get());
    }

    public static void updateConfig(UpdateConfigMessage packet) {
        ConfigRecycler.shared_general.allow_automation.set((Object)packet.allow_automation());
        ConfigRecycler.shared_general.permanent_discover_button.set((Object)packet.permanent_discover_button());
    }

    static {
        Pair confGeneral = new ForgeConfigSpec.Builder().configure(General::new);
        general = (General)confGeneral.getLeft();
        GENERAL_SPEC = (ForgeConfigSpec)confGeneral.getRight();
        Pair confSharedGeneral = new ForgeConfigSpec.Builder().configure(SharedGeneral::new);
        shared_general = (SharedGeneral)confSharedGeneral.getLeft();
        SHARED_GENERAL_SPEC = (ForgeConfigSpec)confSharedGeneral.getRight();
    }

    public static class SharedGeneral {
        public final ForgeConfigSpec.ConfigValue<Boolean> allow_automation;
        public final ForgeConfigSpec.ConfigValue<Boolean> permanent_discover_button;

        SharedGeneral(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.allow_automation = builder.comment("allow_automation [false/true|default:true]").translation(ConfigRecycler.getTranslation("allow_automation")).define("Allow_automation", true);
            this.permanent_discover_button = builder.comment("The button discover doesn't require permission 2 [false/true|default:false]").translation(ConfigRecycler.getTranslation("permanent_discover_button")).define("permanent_discover_button", false);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> onlyUserRecipes;
        public final ForgeConfigSpec.ConfigValue<Boolean> recycleMagicItem;
        public final ForgeConfigSpec.ConfigValue<Boolean> recycleEnchantedBook;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceLoss;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowSound;
        public final ForgeConfigSpec.ConfigValue<Integer> timeToRecycle;
        public final ForgeConfigSpec.ConfigValue<Boolean> recycleRoundDown;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.onlyUserRecipes = builder.comment("only_user_recipes [false/true|default:false]").translation(ConfigRecycler.getTranslation("only_user_recipes")).define("only_user_recipes", false);
            this.recycleMagicItem = builder.comment("recycle_magic_item [false/true|default:true]").translation(ConfigRecycler.getTranslation("recycle_magic_item")).define("recycle_magic_item", true);
            this.recycleEnchantedBook = builder.comment("recycle_enchanted_book [false/true|default:true]").translation(ConfigRecycler.getTranslation("recycle_enchanted_book")).define("recycle_enchanted_book", true);
            this.chanceLoss = builder.comment("chance_loss [0..100|default:0]").translation(ConfigRecycler.getTranslation("chance_loss")).defineInRange("chance_loss", 0, 0, 100);
            this.allowSound = builder.comment("allow_sound [false/true|default:true]").translation(ConfigRecycler.getTranslation("allow_sound")).define("allow_sound", true);
            this.timeToRecycle = builder.comment("time_to_recycle [5..10000|default:100]").translation(ConfigRecycler.getTranslation("time_to_recycle")).defineInRange("time_to_recycle", 100, 5, 10000);
            this.recycleRoundDown = builder.comment("recycle_round_down [false/true|default:false]").translation(ConfigRecycler.getTranslation("recycle_round_down")).define("recycle_round_down", false);
            builder.pop();
        }
    }

    @Mod.EventBusSubscriber(modid="corail_recycler", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ConfigEvent {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onReloadConfig(ModConfigEvent.Reloading event) {
            if (event.getConfig().getModId().equals("corail_recycler") && event.getConfig().getType() == ModConfig.Type.SERVER) {
                ModRecycler.PROXY.markConfigDirty();
            }
        }
    }
}

