/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.gui.ButtonRecycler;
import ovh.corail.recycler.gui.RecyclerMenu;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerRecyclerMessage;
import ovh.corail.recycler.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecycler
extends AbstractContainerScreen<RecyclerMenu> {
    private static final ResourceLocation TEXTURE_RECYCLER = new ResourceLocation("corail_recycler:textures/gui/vanilla_recycler.png");
    private static final ButtonRecycler[] BUTTONS = new ButtonRecycler[5];
    private final ResourceLocation TEXTURE_BAR = new ResourceLocation("textures/gui/bars.png");
    private boolean isInit = true;

    public GuiRecycler(RecyclerMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 232;
        this.f_97727_ = 203;
    }

    public void m_7856_() {
        super.m_7856_();
        this.getMinecraft().f_91068_.m_90926_(true);
        GuiRecycler.BUTTONS[0] = new ButtonRecycler(this.f_97735_ + 174, this.f_97736_ + 120, 53, 14, (Component)LangKey.BUTTON_RECYLE.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.RECYCLE, ((RecyclerMenu)this.f_97732_).getPosition())));
        this.m_142416_((GuiEventListener)GuiRecycler.BUTTONS[0]);
        GuiRecycler.BUTTONS[1] = new ButtonRecycler(this.f_97735_ + 174, this.f_97736_ + 139, 53, 14, (Component)LangKey.BUTTON_AUTO.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.SWITCH_AUTO, ((RecyclerMenu)this.f_97732_).getPosition())));
        this.m_142416_((GuiEventListener)GuiRecycler.BUTTONS[1]);
        GuiRecycler.BUTTONS[2] = new ButtonRecycler(this.f_97735_ + 174, this.f_97736_ + 157, 53, 14, (Component)LangKey.BUTTON_TAKE_ALL.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.TAKE_ALL, ((RecyclerMenu)this.f_97732_).getPosition())));
        this.m_142416_((GuiEventListener)GuiRecycler.BUTTONS[2]);
        GuiRecycler.BUTTONS[3] = new ButtonRecycler(this.f_97735_ + 174, this.f_97736_ + 175, 53, 14, (Component)LangKey.BUTTON_DISCOVER_RECIPE.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.DISCOVER_RECIPE, ((RecyclerMenu)this.f_97732_).getPosition())));
        this.m_142416_((GuiEventListener)GuiRecycler.BUTTONS[3]);
        GuiRecycler.BUTTONS[4] = new ButtonRecycler(this.f_97735_ + 174, this.f_97736_ + 175, 53, 14, (Component)LangKey.BUTTON_REMOVE_RECIPE.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.REMOVE_RECIPE, ((RecyclerMenu)this.f_97732_).getPosition())));
        this.m_142416_((GuiEventListener)GuiRecycler.BUTTONS[4]);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_RECYCLER);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (Slot slot : ((RecyclerMenu)this.m_6262_()).f_38839_) {
            this.m_93228_(poseStack, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 110, 238, 18, 18);
            Slot slot2 = slot;
            if (!(slot2 instanceof SlotRecycler)) continue;
            SlotRecycler slotRecycler = (SlotRecycler)slot2;
            if (this.isInit) {
                slotRecycler.timeInUse = 0;
                continue;
            }
            if (slotRecycler.timeInUse <= 0) continue;
            this.m_93228_(poseStack, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 110, 203, 18, 18);
            --slotRecycler.timeInUse;
        }
        this.isInit = false;
    }

    public void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        int colorRed = -65536;
        int colorGreen = -16711936;
        float scale = 0.6f;
        float revScale = 1.0f / scale;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_RECYCLER);
        this.m_93228_(poseStack, 115, 71, 79, 210, 22, 15);
        if (((RecyclerMenu)this.f_97732_).isWorking() && ((RecyclerMenu)this.f_97732_).getInputMax() > 0) {
            this.m_93228_(poseStack, 115, 71, 79, 225, ((RecyclerMenu)this.f_97732_).getProgress() * 22 / 100, 15);
        }
        int currentPower = ((RecyclerMenu)this.f_97732_).getEnergy();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.TEXTURE_BAR);
        GuiRecycler.m_93133_((PoseStack)poseStack, (int)70, (int)112, (float)0.0f, (float)20.0f, (int)136, (int)3, (int)136, (int)256);
        GuiRecycler.m_93133_((PoseStack)poseStack, (int)70, (int)112, (float)0.0f, (float)25.0f, (int)((int)(96.56 * (double)currentPower) / ((RecyclerMenu)this.f_97732_).getRecycler().getMaxEnergy()), (int)2, (int)136, (int)256);
        GuiRecycler.m_93133_((PoseStack)poseStack, (int)70, (int)112, (float)0.0f, (float)81.0f, (int)136, (int)3, (int)136, (int)256);
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        this.f_96547_.m_92883_(poseStack, "ENERGY", 134.0f * revScale, 98.0f * revScale, -8355712);
        Slot diskSlot = (Slot)((RecyclerMenu)this.f_97732_).f_38839_.get(1);
        ItemStack diskStack = diskSlot.m_7993_();
        int useLeft = diskStack.m_41619_() ? 0 : (diskStack.m_41776_() - diskStack.m_41773_()) / 10;
        this.f_96547_.m_92883_(poseStack, String.valueOf(useLeft), (float)((int)((float)(diskSlot.f_40220_ + 20) * revScale)), (float)((int)((float)(diskSlot.f_40221_ + 4) * revScale)), useLeft > 0 ? colorGreen : colorRed);
        Slot bookSlot = (Slot)((RecyclerMenu)this.f_97732_).f_38839_.get(2);
        ItemStack bookStack = bookSlot.m_7993_();
        int left = bookStack.m_41619_() ? 0 : bookStack.m_41613_();
        this.f_96547_.m_92883_(poseStack, String.valueOf(left), (float)((int)((float)(bookSlot.f_40220_ + 20) * revScale)), (float)((int)((float)(bookSlot.f_40221_ + 4) * revScale)), left > 0 ? colorGreen : colorRed);
        Slot recycledSlot = (Slot)((RecyclerMenu)this.f_97732_).f_38839_.get(0);
        this.f_96547_.m_92883_(poseStack, String.valueOf(((RecyclerMenu)this.f_97732_).getInputMax()), (float)((int)((float)(recycledSlot.f_40220_ + 20) * revScale)), (float)((int)((float)(recycledSlot.f_40221_ + 4) * revScale)), ((RecyclerMenu)this.f_97732_).getInputMax() > 0 ? colorGreen : colorRed);
        this.f_96547_.m_92883_(poseStack, String.format("%5s", currentPower) + " / " + ((RecyclerMenu)this.f_97732_).getRecycler().getMaxEnergy(), (float)((int)(120.0f * revScale)), (float)((int)(104.0f * revScale)), currentPower >= 10 ? colorGreen : -8355712);
        poseStack.m_85849_();
        if (bookSlot.m_7993_().m_41619_()) {
            this.getMinecraft().m_91291_().m_115218_(new ItemStack((ItemLike)Items.f_42517_), bookSlot.f_40220_, bookSlot.f_40221_);
            RenderSystem.m_69456_((int)516);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)bookSlot.f_40220_, (int)bookSlot.f_40221_, (int)(bookSlot.f_40220_ + 16), (int)(bookSlot.f_40221_ + 16), (int)-796884864);
            RenderSystem.m_69456_((int)515);
        }
        if (diskSlot.m_7993_().m_41619_()) {
            this.getMinecraft().m_91291_().m_115218_(new ItemStack((ItemLike)ModItems.steel_disk), diskSlot.f_40220_, diskSlot.f_40221_);
            RenderSystem.m_69456_((int)516);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)diskSlot.f_40220_, (int)diskSlot.f_40221_, (int)(diskSlot.f_40220_ + 16), (int)(diskSlot.f_40221_ + 16), (int)-2139062144);
            RenderSystem.m_69456_((int)515);
        }
        int entityX = 86;
        int entityY = 50;
        Optional.ofNullable(this.getMinecraft().f_91074_).ifPresent(p -> InventoryScreen.m_98850_((int)entityX, (int)entityY, (int)20, (float)(2 * entityX - mouseX), (float)(entityY - mouseY), (LivingEntity)p));
    }

    public void m_7379_() {
        super.m_7379_();
        this.getMinecraft().f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.updateButtons();
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }

    private void updateButtons() {
        boolean isEmptySlot = ((RecyclerMenu)this.f_97732_).getRecycler().getInventoryWorking().getStackInSlot(0).m_41619_();
        boolean hasPermission = Optional.ofNullable(this.getMinecraft().f_91074_).map(p -> (Boolean)ConfigRecycler.shared_general.permanent_discover_button.get() != false || p.m_20310_(2)).orElse(false);
        boolean hasRecipe = IntStream.range(0, ((RecyclerMenu)this.f_97732_).getRecycler().getInventoryVisual().getSlots()).anyMatch(slot -> !((RecyclerMenu)this.f_97732_).getRecycler().getInventoryVisual().getStackInSlot(slot).m_41619_());
        GuiRecycler.BUTTONS[0].f_93623_ = hasRecipe && ((RecyclerMenu)this.f_97732_).getInputMax() > 0 && !((RecyclerMenu)this.f_97732_).isWorking();
        GuiRecycler.BUTTONS[1].f_93623_ = (Boolean)ConfigRecycler.shared_general.allow_automation.get() != false && hasRecipe && !((RecyclerMenu)this.f_97732_).getRecycler().getInventoryWorking().getStackInSlot(1).m_41619_();
        GuiRecycler.BUTTONS[2].f_93623_ = !((RecyclerMenu)this.f_97732_).getRecycler().isOutputEmpty();
        GuiRecycler.BUTTONS[3].f_93624_ = hasPermission && !hasRecipe && !isEmptySlot;
        GuiRecycler.BUTTONS[3].f_93623_ = GuiRecycler.BUTTONS[3].f_93624_;
        GuiRecycler.BUTTONS[4].f_93624_ = hasPermission && hasRecipe && !isEmptySlot;
        GuiRecycler.BUTTONS[4].f_93623_ = GuiRecycler.BUTTONS[4].f_93624_;
    }
}

