/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.recycler.gui.RecyclingBookMenu;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerRecyclingBookMessage;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecyclingBook
extends AbstractContainerScreen<RecyclingBookMenu> {
    private static final ResourceLocation TEXTURE_VANILLA_RECYCLER = new ResourceLocation("corail_recycler:textures/gui/vanilla_recycler.png");
    private static final ResourceLocation TEXTURE_RECYCLING_BOOK = new ResourceLocation("corail_recycler:textures/gui/book.png");
    private PageButton forwardButton;
    private PageButton backButton;
    private EditBox searchBox;
    private String lastText = "";
    private final Map<Integer, Rectangle> recipeFlags = new HashMap<Integer, Rectangle>();

    public GuiRecyclingBook(RecyclingBookMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 250;
        this.f_97727_ = 150;
    }

    public void m_7856_() {
        super.m_7856_();
        this.getMinecraft().f_91068_.m_90926_(true);
        this.backButton = new PageButton(this.f_97735_ + 20, this.f_97736_ + 135, false, pressable -> {
            if (((RecyclingBookMenu)this.f_97732_).getPageNum() > 0) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((RecyclingBookMenu)this.f_97732_).getPageNum() - 1));
            }
        }, true);
        this.m_142416_((GuiEventListener)this.backButton);
        this.forwardButton = new PageButton(this.f_97735_ + 212, this.f_97736_ + 135, true, pressable -> {
            if (((RecyclingBookMenu)this.f_97732_).getPageNum() < ((RecyclingBookMenu)this.f_97732_).getPageMax()) {
                PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.CHANGE_PAGE, ((RecyclingBookMenu)this.f_97732_).getPageNum() + 1));
            }
        }, true);
        this.m_142416_((GuiEventListener)this.forwardButton);
        this.recipeFlags.clear();
        ((RecyclingBookMenu)this.f_97732_).f_38839_.stream().filter(slot -> Helper.atInterval(slot.getSlotIndex(), 10, false)).forEach(slot -> {
            int startPosX = this.f_97735_ + slot.f_40220_;
            int startPosY = this.f_97736_ + slot.f_40221_;
            int slotId = slot.getSlotIndex() / 10;
            this.recipeFlags.put(slotId * 3, new Rectangle(startPosX, startPosY + 16, 5, 5));
            this.recipeFlags.put(slotId * 3 + 1, new Rectangle(startPosX + 5, startPosY + 16, 5, 5));
            this.recipeFlags.put(slotId * 3 + 2, new Rectangle(startPosX + 10, startPosY + 16, 5, 5));
        });
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 32, this.f_97736_ + 141, 64, 12, (Component)new TextComponent("search"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.configureSearchBox();
    }

    private void configureSearchBox() {
        this.searchBox.m_94186_(true);
        this.searchBox.m_94178_(true);
        this.searchBox.m_94199_(20);
        this.searchBox.m_94144_("");
        this.searchBox.m_94190_(false);
        this.searchBox.m_94182_(false);
    }

    private void updateButton(int buttonNum, boolean state) {
        if (buttonNum == 0) {
            this.backButton.f_93623_ = this.backButton.f_93624_ = state;
        } else if (buttonNum == 1) {
            this.forwardButton.f_93623_ = this.forwardButton.f_93624_ = state;
        }
    }

    private void updateButtons() {
        if (((RecyclingBookMenu)this.f_97732_).getPageNum() <= 0) {
            ((RecyclingBookMenu)this.f_97732_).setPageNum(0);
            this.updateButton(0, false);
            this.updateButton(1, ((RecyclingBookMenu)this.f_97732_).getPageMax() > 0);
        } else if (((RecyclingBookMenu)this.f_97732_).getPageNum() >= ((RecyclingBookMenu)this.f_97732_).getPageMax()) {
            ((RecyclingBookMenu)this.f_97732_).setPageNum(((RecyclingBookMenu)this.f_97732_).getPageMax());
            this.updateButton(0, true);
            this.updateButton(1, false);
        } else {
            this.updateButton(0, true);
            this.updateButton(1, true);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode == 256) {
            return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
        }
        if (keyCode == 259) {
            String text = this.searchBox.m_94155_();
            if (text.length() < 2) {
                this.searchBox.m_94144_("");
            } else {
                this.searchBox.m_94144_(text.substring(0, text.length() - 1));
            }
            return true;
        }
        return false;
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchBox.m_5534_(Character.toLowerCase(p_charTyped_1_), p_charTyped_2_)) {
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public void m_181908_() {
        String currentText;
        super.m_181908_();
        ClientLevel world = this.getMinecraft().f_91073_;
        if (world != null && Helper.atInterval(world.m_46467_(), 10) && !this.lastText.equals(currentText = this.searchBox.m_94155_())) {
            this.lastText = currentText;
            PacketHandler.sendToServer(new ServerRecyclingBookMessage(ServerRecyclingBookMessage.RecyclingBookAction.SEARCH_TEXT, this.searchBox.m_94155_().toLowerCase(Locale.US)));
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.getMinecraft().f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.updateButtons();
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_RECYCLING_BOOK);
        GuiRecyclingBook.m_93133_((PoseStack)poseStack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)256, (int)158, (int)256, (int)158);
        GuiRecyclingBook.m_93172_((PoseStack)poseStack, (int)(this.searchBox.f_93620_ - 4), (int)(this.searchBox.f_93621_ - 3), (int)(this.searchBox.f_93620_ + this.searchBox.m_5711_() + 7), (int)(this.searchBox.f_93621_ + this.searchBox.m_93694_() - 1), (int)-7968700);
        GuiRecyclingBook.m_93172_((PoseStack)poseStack, (int)(this.searchBox.f_93620_ - 3), (int)(this.searchBox.f_93621_ - 2), (int)(this.searchBox.f_93620_ + this.searchBox.m_5711_() + 6), (int)(this.searchBox.f_93621_ + this.searchBox.m_93694_() - 2), (int)-16777216);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_VANILLA_RECYCLER);
        for (Slot slot : ((RecyclingBookMenu)this.f_97732_).f_38839_) {
            int recipeId;
            int startPosX = this.f_97735_ + slot.f_40220_;
            int startPosY = this.f_97736_ + slot.f_40221_;
            this.m_93228_(poseStack, startPosX, startPosY, 112, 222, 16, 16);
            if (!Helper.atInterval(slot.getSlotIndex(), 10, false) || !((RecyclingBookMenu)this.f_97732_).isUserDefinedRecipe(recipeId = slot.getSlotIndex() / 10)) continue;
            Rectangle pos = this.recipeFlags.get(recipeId * 3);
            GuiRecyclingBook.m_93172_((PoseStack)poseStack, (int)pos.x, (int)pos.y, (int)(pos.x + pos.width), (int)(pos.y + pos.height), (int)-16776961);
        }
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        this.recipeFlags.entrySet().stream().filter(p -> ((Rectangle)p.getValue()).contains(mouseX, mouseY)).findFirst().ifPresent(entry -> {
            int recipeId = (Integer)entry.getKey() / 3;
            boolean valid = ((RecyclingBookMenu)this.f_97732_).isUserDefinedRecipe(recipeId);
            if (valid) {
                this.m_96602_(poseStack, (Component)new TextComponent("user defined"), mouseX, mouseY);
            }
        });
        super.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        float revScale = 2.0f;
        ((RecyclingBookMenu)this.f_97732_).f_38839_.stream().filter(p -> Helper.atInterval(p.getSlotIndex(), 10, false) && !p.m_7993_().m_41619_()).forEach(slot -> {
            String text = ChatFormatting.BOLD + slot.m_7993_().m_41611_().getString();
            this.f_96547_.m_92883_(poseStack, text, ((float)slot.f_40220_ + 45.5f) * revScale - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)(slot.f_40221_ - 24) * revScale, -10860534);
        });
        String pageMessage = ((RecyclingBookMenu)this.f_97732_).getPageNum() + 1 + "/" + (((RecyclingBookMenu)this.f_97732_).getPageMax() + 1);
        this.f_96547_.m_92883_(poseStack, pageMessage, (float)(this.f_97726_ - 50) * revScale - (float)this.f_96547_.m_92895_(pageMessage), 141.0f * revScale, -10860534);
        poseStack.m_85849_();
        GuiRecyclingBook.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)LangKey.MESSAGE_RECYCLING_BOOK.getText(ChatFormatting.BOLD), (int)(this.f_97726_ / 2), (int)-10, (int)-2838729);
    }

    private record Rectangle(int x, int y, int width, int height) {
        private boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }
}

