/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.gui.SlotWorking;
import ovh.corail.recycler.registry.ModMenuTypes;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public class RecyclerMenu
extends AbstractContainerMenu {
    private final TileEntityRecycler recycler;
    private final ContainerData recyclerData;

    protected RecyclerMenu(MenuType<? extends RecyclerMenu> containerType, int windowId, Inventory playerInventory, TileEntityRecycler recycler) {
        super(containerType, windowId);
        this.recycler = recycler;
        recycler.giveRecyclingBook();
        this.recyclerData = new TileEntityRecycler.RecyclerData(recycler);
        this.m_38884_(this.recyclerData);
        this.addSlots(playerInventory);
        this.recycler.updateRecyclingRecipe();
    }

    public RecyclerMenu(int windowId, Inventory playerInventory, TileEntityRecycler recycler) {
        this(ModMenuTypes.RECYCLER, windowId, playerInventory, recycler);
    }

    public RecyclerMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        this(windowId, playerInventory, (TileEntityRecycler)Objects.requireNonNull(playerInventory.f_35978_.f_19853_.m_7702_(pos)));
    }

    public RecyclerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130135_());
    }

    public boolean isWorking() {
        return this.recyclerData.m_6413_(0) == 1;
    }

    public int getProgress() {
        return this.recyclerData.m_6413_(1);
    }

    public int getInputMax() {
        return this.recyclerData.m_6413_(2);
    }

    public int getEnergy() {
        return this.recyclerData.m_6413_(3);
    }

    public BlockPos getPosition() {
        return this.recycler.m_58899_();
    }

    public TileEntityRecycler getRecycler() {
        return this.recycler;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 39 ? !this.m_38903_(itemstack1, 39, 74, true) : index < 75 && !this.m_38903_(itemstack1, 3, 20, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }

    private void addSlots(Inventory playerInventory) {
        int x;
        int y;
        this.m_38897_((Slot)new SlotWorking(this, 0, 81, 69, TileEntityRecycler.RecyclerWorkingStackHandler.EnumSlot.ITEM.predicate));
        this.m_38897_((Slot)new SlotWorking(this, 1, 96, 91, TileEntityRecycler.RecyclerWorkingStackHandler.EnumSlot.DISK.predicate));
        this.m_38897_((Slot)new SlotWorking(this, 2, 66, 91, TileEntityRecycler.RecyclerWorkingStackHandler.EnumSlot.BOOK.predicate));
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryInput(), x + y * 3, x * 18 + 7, y * 18 + 8));
            }
        }
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryOutput(), x + y * 3, x * 18 + 173, y * 18 + 8));
            }
        }
        InvWrapper inventPlayer = new InvWrapper((Container)playerInventory);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_((Slot)new SlotRecycler((IItemHandler)inventPlayer, x + y * 9, x * 18 + 7, y == 0 ? 178 : y * 18 + 102));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_((Slot)new SlotRecycler((IItemHandler)this.recycler.getInventoryVisual(), x + y * 3, x * 18 + 110, y * 18 + 8, p -> false, false));
            }
        }
    }
}

