/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.registry.ModMenuTypes;

public class RecyclingBookMenu
extends AbstractContainerMenu {
    public static final Component NAME = new TranslatableComponent("corail_recycler.message.recycling_book");
    private final SimpleContainerData recyclingBookData = new SimpleContainerData(6);
    private final ItemStackHandler BOOK_INVENTORY = new ItemStackHandler(40);
    private String searchText = "";

    public RecyclingBookMenu(int windowId, Inventory playerInventory) {
        super(ModMenuTypes.RECYCLING_BOOK, windowId);
        this.initSlots();
        if (!playerInventory.f_35978_.f_19853_.m_5776_()) {
            this.initPage(0);
        }
        this.m_38884_((ContainerData)this.recyclingBookData);
    }

    public RecyclingBookMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory);
    }

    public void initPage(int pageNum) {
        List<RecyclingRecipe> recipes = RecyclingManager.INSTANCE.getRecipesForSearch(this.searchText);
        this.setPageMax(Math.max(Mth.m_14167_((float)((float)recipes.size() / 4.0f)) - 1, 0));
        this.setPageNum(Mth.m_14045_((int)pageNum, (int)0, (int)this.getPageMax()));
        int skipped = this.getPageNum() * 4;
        int slotId = 0;
        int recipeIdMax = Math.min(skipped + 4, recipes.size());
        for (int recipeId = skipped; recipeId < recipeIdMax; ++recipeId) {
            RecyclingRecipe recipe = recipes.get(recipeId);
            this.recyclingBookData.m_8050_(recipeId - skipped, recipe.isUserDefined() ? 1 : 0);
            this.BOOK_INVENTORY.setStackInSlot(slotId++, recipe.getIngredient().asItemStack());
            for (int i = 0; i < 9; ++i) {
                this.BOOK_INVENTORY.setStackInSlot(slotId++, i < recipe.getCount() ? recipe.getResult(i).asItemStack() : ItemStack.f_41583_);
            }
        }
        while (slotId < 40) {
            this.BOOK_INVENTORY.setStackInSlot(slotId++, ItemStack.f_41583_);
        }
    }

    public void updateSearchText(String searchText) {
        this.searchText = searchText;
        this.initPage(0);
    }

    public int getPageNum() {
        return this.recyclingBookData.m_6413_(4);
    }

    public void setPageNum(int num) {
        this.recyclingBookData.m_8050_(4, num);
    }

    public int getPageMax() {
        return this.recyclingBookData.m_6413_(5);
    }

    public void setPageMax(int num) {
        this.recyclingBookData.m_8050_(5, num);
    }

    public boolean isUserDefinedRecipe(int recipeSquareNum) {
        return this.recyclingBookData.m_6413_(recipeSquareNum) != 0;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    private void initSlots() {
        int slotId = 0;
        for (int j = 0; j < 2; ++j) {
            int startX = 30;
            int startY = 20 + j * 16 * 3 + 8 * j;
            if (j == 1) {
                startY += 10;
            }
            for (int i = 0; i < 2; ++i) {
                this.m_38897_((Slot)new SlotRecycler((IItemHandler)this.BOOK_INVENTORY, slotId++, startX, startY + 16, p -> false, false));
                startX += 21;
                for (int caseY = 0; caseY < 3; ++caseY) {
                    for (int caseX = 0; caseX < 3; ++caseX) {
                        this.m_38897_((Slot)new SlotRecycler((IItemHandler)this.BOOK_INVENTORY, slotId++, startX + caseX * 16, startY + caseY * 16, p -> false, false));
                    }
                }
                startX = 150;
            }
        }
    }
}

