/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.compatibility.CompatibilityProjectE;
import ovh.corail.recycler.recipe.SimpleStack;

public class Helper {
    public static final Random RANDOM = new Random();
    private static final Predicate<Ingredient> VALID_INGREDIENT = ingredient -> {
        if (ingredient == Ingredient.f_43901_) {
            return true;
        }
        if (ingredient.m_43908_().length > 0) {
            return CompatibilityProjectE.philosophers_stone == null || Arrays.stream(ingredient.m_43908_()).noneMatch(stack -> stack.m_150930_(CompatibilityProjectE.philosophers_stone));
        }
        return false;
    };
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public static boolean isValidPlayer(@Nullable Player player) {
        return player != null && !(player instanceof FakePlayer);
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return Helper.atInterval(ticksExisted, tick, true);
    }

    public static boolean atInterval(long ticksExisted, int tick, boolean ignoreZero) {
        return (!ignoreZero || ticksExisted > 0L) && ticksExisted % (long)tick == 0L;
    }

    public static boolean atInterval(Level level, int tick) {
        return Helper.atInterval(level.m_46467_(), tick, true);
    }

    public static boolean areItemEqual(ItemStack s1, ItemStack s2) {
        return !s1.m_41619_() && s1.m_41720_() == s2.m_41720_();
    }

    public static boolean isValidRecipe(@Nullable Recipe<?> recipe) {
        return recipe != null && recipe.m_7527_().size() > 0 && !recipe.m_8043_().m_41619_() && recipe.m_7527_().stream().allMatch(VALID_INGREDIENT);
    }

    public static NonNullList<SimpleStack> mergetoSimpleStack(List<ItemStack> list) {
        NonNullList simpleStacks = NonNullList.m_122779_();
        for (ItemStack currentStack : list) {
            if (currentStack.m_41619_()) continue;
            if (currentStack.m_41753_() && currentStack.m_41613_() < currentStack.m_41741_()) {
                int toAdd = currentStack.m_41613_();
                for (SimpleStack simpleStack : simpleStacks) {
                    int left;
                    int added;
                    if (!simpleStack.is(currentStack) || (added = Math.min(toAdd, left = currentStack.m_41741_() - simpleStack.getCount())) <= 0) continue;
                    simpleStack.grow(added);
                    if ((toAdd -= added) != 0) continue;
                    break;
                }
                if (toAdd == 0) continue;
                simpleStacks.add((Object)new SimpleStack(currentStack.m_41720_(), toAdd));
                continue;
            }
            simpleStacks.add((Object)new SimpleStack(currentStack));
        }
        return simpleStacks;
    }

    public static void mergeStackInList(NonNullList<ItemStack> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            ItemStack currentStack = (ItemStack)list.get(i);
            if (currentStack.m_41619_() || !currentStack.m_41753_() || currentStack.m_41613_() >= currentStack.m_41741_()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                int add;
                ItemStack lookStack = (ItemStack)list.get(j);
                if (lookStack.m_41619_() || !Helper.areItemEqual(currentStack, lookStack) || (add = Math.min(lookStack.m_41613_(), currentStack.m_41741_() - currentStack.m_41613_())) <= 0) continue;
                lookStack.m_41774_(add);
                currentStack.m_41769_(add);
                if (currentStack.m_41613_() == currentStack.m_41741_()) continue block0;
            }
        }
        list.removeIf(ItemStack::m_41619_);
    }

    public static boolean canInsertInInventory(IItemHandlerModifiable inventory, NonNullList<ItemStack> items) {
        int[] slotSizes = IntStream.range(0, inventory.getSlots()).map(slotId -> Optional.of(inventory.getStackInSlot(slotId)).filter(s -> !s.m_41619_()).map(ItemStack::m_41613_).orElse(0)).toArray();
        int emptySlots = (int)Arrays.stream(slotSizes).filter(i -> i == 0).count();
        if (emptySlots >= items.size()) {
            return true;
        }
        int minCount = items.size() - emptySlots;
        block0: for (ItemStack stackIn : items) {
            if (minCount <= 0) {
                return true;
            }
            if (stackIn.m_41619_()) {
                --minCount;
                continue;
            }
            if (!stackIn.m_41753_()) continue;
            int left = stackIn.m_41613_();
            for (int slotId2 = 0; slotId2 < inventory.getSlots(); ++slotId2) {
                int add;
                int stacksize;
                ItemStack currentStack = inventory.getStackInSlot(slotId2);
                if (!Helper.areItemEqual(stackIn, currentStack) || (stacksize = slotSizes[slotId2]) >= currentStack.m_41741_() || (add = Math.min(left, currentStack.m_41741_() - stacksize)) <= 0) continue;
                slotSizes[slotId2] = stacksize + add;
                if ((left -= add) > 0) continue;
                --minCount;
                continue block0;
            }
        }
        return minCount <= 0;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    public static <T> T unsafeNullCast() {
        return null;
    }

    public static boolean saveAsJson(File file, List<?> list) {
        if (file.exists() && !file.delete()) {
            ModRecycler.LOGGER.warn("can't delete file " + file.getName());
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(GSON.toJson(list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static <T> List<T> loadAsJson(File file, Type token) {
        List list = new ArrayList();
        try {
            list = (List)GSON.fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> loadAsJson(File file, Class<T> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JsonArray arrayDatas = new JsonParser().parse((Reader)new BufferedReader(new FileReader(file))).getAsJsonArray();
            for (JsonElement elem : arrayDatas) {
                list.add(GSON.fromJson(elem, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

