/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.registry.ModTriggers;
import ovh.corail.recycler.tileentity.TileEntityRecycler;

public record ServerRecyclerMessage(RecyclerAction action, BlockPos pos) {
    static ServerRecyclerMessage fromBytes(FriendlyByteBuf buf) {
        return new ServerRecyclerMessage(RecyclerAction.values()[buf.readShort()], buf.m_130135_());
    }

    static void toBytes(ServerRecyclerMessage msg, FriendlyByteBuf buf) {
        buf.writeShort(msg.action.ordinal());
        buf.m_130064_(msg.pos);
    }

    public static enum RecyclerAction {
        RECYCLE,
        SWITCH_AUTO,
        TAKE_ALL,
        DISCOVER_RECIPE,
        REMOVE_RECIPE;

    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    TileEntityRecycler recycler;
                    ServerPlayer player = ctx.getSender();
                    if (player != null && (recycler = BlockRecycler.getTileEntity(player.f_19853_, message.pos)) != null) {
                        switch (message.action) {
                            case RECYCLE: {
                                if (!recycler.recycle(player)) break;
                                ModTriggers.FIRST_RECYCLE.trigger(player);
                                break;
                            }
                            case SWITCH_AUTO: {
                                recycler.switchWorking();
                                break;
                            }
                            case TAKE_ALL: {
                                player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(p -> {
                                    ItemStackHandler inventOutput = recycler.getInventoryOutput();
                                    IntStream.range(0, inventOutput.getSlots()).filter(slot -> !inventOutput.getStackInSlot(slot).m_41619_()).forEach(slot -> inventOutput.setStackInSlot(slot, ItemHandlerHelper.insertItemStacked((IItemHandler)p, (ItemStack)inventOutput.getStackInSlot(slot), (boolean)false)));
                                });
                                break;
                            }
                            case DISCOVER_RECIPE: {
                                ItemStack stack = recycler.getInventoryWorking().getStackInSlot(0);
                                if (!stack.m_41619_() && (((Boolean)ConfigRecycler.shared_general.permanent_discover_button.get()).booleanValue() || player.m_20310_(2)) && RecyclingManager.INSTANCE.discoverRecipe(player.m_9236_(), stack)) {
                                    recycler.updateRecyclingRecipe();
                                    LangKey.MESSAGE_ADD_RECIPE_SUCCESS.sendMessage((Player)player, new Object[0]);
                                    break;
                                }
                                LangKey.MESSAGE_ADD_RECIPE_FAILED.sendMessage((Player)player, new Object[0]);
                                break;
                            }
                            case REMOVE_RECIPE: {
                                ItemStack stack = recycler.getInventoryWorking().getStackInSlot(0);
                                if (!stack.m_41619_() && (((Boolean)ConfigRecycler.shared_general.permanent_discover_button.get()).booleanValue() || player.m_20310_(2)) && RecyclingManager.INSTANCE.removeRecipe(stack)) {
                                    recycler.resetLastRecipe();
                                    recycler.updateRecyclingRecipe();
                                    LangKey.MESSAGE_REMOVE_RECIPE_SUCCESS.sendMessage((Player)player, new Object[0]);
                                    break;
                                }
                                LangKey.MESSAGE_REMOVE_RECIPE_FAILED.sendMessage((Player)player, new Object[0]);
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

