/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import ovh.corail.recycler.gui.RecyclingBookMenu;
import ovh.corail.recycler.helper.Helper;

public class ServerRecyclingBookMessage {
    private final RecyclingBookAction action;
    private int pageNum;
    private String searchText;

    public ServerRecyclingBookMessage(RecyclingBookAction action, int pageNum) {
        this.action = action;
        if (this.action == RecyclingBookAction.CHANGE_PAGE) {
            this.pageNum = pageNum;
        }
    }

    public ServerRecyclingBookMessage(RecyclingBookAction action, String searchText) {
        this.action = action;
        if (this.action == RecyclingBookAction.SEARCH_TEXT) {
            this.searchText = searchText;
        }
    }

    static ServerRecyclingBookMessage fromBytes(FriendlyByteBuf buf) {
        RecyclingBookAction currentAction = RecyclingBookAction.values()[buf.readShort()];
        return switch (currentAction) {
            case RecyclingBookAction.CHANGE_PAGE -> new ServerRecyclingBookMessage(currentAction, buf.readInt());
            case RecyclingBookAction.SEARCH_TEXT -> new ServerRecyclingBookMessage(currentAction, buf.m_130136_(20));
            default -> throw new IncompatibleClassChangeError();
        };
    }

    static void toBytes(ServerRecyclingBookMessage msg, FriendlyByteBuf buf) {
        buf.writeShort(msg.action.ordinal());
        switch (msg.action) {
            case CHANGE_PAGE: {
                buf.writeInt(msg.pageNum);
                break;
            }
            case SEARCH_TEXT: {
                buf.m_130070_(msg.searchText);
            }
        }
    }

    public static enum RecyclingBookAction {
        CHANGE_PAGE,
        SEARCH_TEXT;

    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclingBookMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    AbstractContainerMenu bookMenu$temp;
                    ServerPlayer player = ctx.getSender();
                    if (player != null && (bookMenu$temp = player.f_36096_) instanceof RecyclingBookMenu) {
                        RecyclingBookMenu bookMenu = (RecyclingBookMenu)bookMenu$temp;
                        switch (message.action) {
                            case CHANGE_PAGE: {
                                bookMenu.initPage(message.pageNum);
                                break;
                            }
                            case SEARCH_TEXT: {
                                bookMenu.updateSearchText(message.searchText);
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

