/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;

public record UpdateConfigMessage(boolean allow_automation, boolean permanent_discover_button) {
    static UpdateConfigMessage fromBytes(FriendlyByteBuf buf) {
        return new UpdateConfigMessage(buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateConfigMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.allow_automation);
        buf.writeBoolean(msg.permanent_discover_button);
    }

    static class Handler {
        Handler() {
        }

        static void handle(UpdateConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ConfigRecycler.updateConfig(message));
            }
            ctx.setPacketHandled(true);
        }
    }
}

