/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecipeLoaderHelper;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.recipe.SimpleStack;
import ovh.corail.recycler.registry.ModBlocks;
import ovh.corail.recycler.registry.ModItems;

public class RecyclingManager {
    public static final RecyclingManager INSTANCE = new RecyclingManager();
    private final Set<RecyclingRecipe> recipes = ConcurrentHashMap.newKeySet();
    private final Set<Item> deniedItems = ConcurrentHashMap.newKeySet();
    private final List<ImmutablePair<SimpleStack, SimpleStack>> grindList = new ArrayList<ImmutablePair<SimpleStack, SimpleStack>>();
    private final File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_recycler");
    private final File deniedFile = new File(this.configDir, "denied_recipes.json");
    private final File userDefinedFile = new File(this.configDir, "user_defined_recipes.json");
    private final File grindFile = new File(this.configDir, "grind_list.json");

    private RecyclingManager() {
        if (!this.configDir.exists() && !this.configDir.mkdir()) {
            ModRecycler.LOGGER.warn("Impossible to create the config folder");
        }
    }

    public boolean discoverRecipe(ServerLevel level, ItemStack stack) {
        RecyclingRecipe recipe = this.getRecipe(stack, false);
        if (recipe != null) {
            return this.setDeniedRecipe(recipe, false);
        }
        recipe = level.m_7465_().m_44054_(RecipeType.f_44107_).values().stream().filter(cr -> Helper.areItemEqual(cr.m_8043_(), stack) && Helper.isValidRecipe(cr)).map(r -> new RecyclingRecipe((Recipe<?>)r).setUserDefined(true)).findFirst().orElse(null);
        if (recipe != null && recipe.isValid()) {
            this.setDeniedRecipe(recipe, false);
            this.recipes.add(recipe);
            return this.saveUserDefinedRecipes();
        }
        return false;
    }

    public void loadRecipes() {
        this.clear();
        this.loadDenied();
        this.loadGrindList();
        if (((Boolean)ConfigRecycler.general.recycleEnchantedBook.get()).booleanValue()) {
            this.recipes.add(new RecyclingRecipe(new SimpleStack(Items.f_42690_), new SimpleStack[0]));
        }
        this.recipes.add(new RecyclingRecipe(new SimpleStack(ModBlocks.recycler), new SimpleStack[]{new SimpleStack(Items.f_42416_, 4), new SimpleStack(Items.f_42647_, 4), new SimpleStack(Items.f_42009_)}));
        this.loadUserDefinedRecipes();
        RecipeLoaderHelper.loadDefaultRecipes(this.recipes);
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    private void clear() {
        this.recipes.clear();
        this.deniedItems.clear();
        this.grindList.clear();
    }

    private void loadDenied() {
        if (!this.deniedFile.exists()) {
            Stream.of(ModBlocks.recycler, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Items.f_42516_, Items.f_42501_, Items.f_42545_, Items.f_42593_, Items.f_42542_, Items.f_42613_, Blocks.f_50452_, Blocks.f_50450_, Blocks.f_50122_).forEach(itemLike -> {
                Item item;
                if (itemLike != null && (item = itemLike.m_5456_()).getRegistryName() != null) {
                    this.deniedItems.add(item);
                }
            });
            this.saveDenied();
        } else {
            Helper.loadAsJson(this.deniedFile, String.class).forEach(rlString -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(rlString));
                if (item != Items.f_41852_) {
                    this.deniedItems.add(item);
                }
            });
        }
    }

    private synchronized void saveDenied() {
        Helper.saveAsJson(this.deniedFile, this.deniedItems.stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).toList());
    }

    public boolean isDeniedRecipe(RecyclingRecipe recipe) {
        return this.deniedItems.stream().anyMatch(recipe::isIngredient);
    }

    public boolean setDeniedRecipe(RecyclingRecipe recipe, boolean state) {
        recipe.setDenied(state);
        boolean denied = this.isDeniedRecipe(recipe);
        if (state != denied) {
            if (denied) {
                this.deniedItems.remove(recipe.getIngredient().getItem());
            } else {
                this.deniedItems.add(recipe.getIngredient().getItem());
            }
            this.saveDenied();
            return true;
        }
        return false;
    }

    public boolean addUserDefinedRecipe(RecyclingRecipe recipe) {
        this.recipes.remove(recipe);
        this.recipes.add(recipe.setUserDefined(true));
        return this.saveUserDefinedRecipes();
    }

    public boolean removeRecipe(ItemStack stack) {
        RecyclingRecipe recipe = this.getRecipe(stack, false);
        if (recipe == null) {
            return false;
        }
        if (recipe.isUserDefined()) {
            this.recipes.remove(recipe);
            this.saveUserDefinedRecipes();
        } else {
            this.setDeniedRecipe(recipe, true);
        }
        return true;
    }

    public List<RecyclingRecipe> getRecipesForSearch(String searchText) {
        return this.recipes.stream().filter(recipe -> !(recipe.isIngredient(Items.f_42690_) || recipe.isDenied() || !searchText.isEmpty() && !recipe.getIngredient().getTranslation().contains(searchText) || (Boolean)ConfigRecycler.general.onlyUserRecipes.get() != false && !recipe.isUserDefined())).sorted().toList();
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack) {
        return this.getRecipe(stack, true);
    }

    @Nullable
    public RecyclingRecipe getRecipe(ItemStack stack, boolean checked) {
        if (stack.m_41619_() || checked && stack.m_41720_() == Items.f_42690_ && EnchantedBookItem.m_41163_((ItemStack)stack).size() < 2) {
            return null;
        }
        RecyclingRecipe recipe = this.recipes.stream().filter(r -> r.isIngredient(stack)).findFirst().orElse(null);
        if (recipe == null) {
            return null;
        }
        if (checked) {
            if (((Boolean)ConfigRecycler.general.onlyUserRecipes.get()).booleanValue() && !recipe.isUserDefined()) {
                return null;
            }
            if (recipe.isDenied()) {
                return null;
            }
        }
        return recipe;
    }

    public NonNullList<ItemStack> getResultStack(ItemStack stack, int nb_input) {
        return this.getResultStack(stack, nb_input, false);
    }

    private SimpleStack getIngredient(SimpleStack stack, boolean withGrind) {
        if (withGrind) {
            for (ImmutablePair<SimpleStack, SimpleStack> grind : this.grindList) {
                if (!stack.is((SimpleStack)grind.getLeft())) continue;
                float ratio = (float)((SimpleStack)grind.getRight()).getCount() / (float)((SimpleStack)grind.getLeft()).getCount();
                new SimpleStack(((SimpleStack)grind.getRight()).getItem(), Mth.m_14143_((float)(ratio * (float)stack.getCount())));
            }
        }
        return stack.copy();
    }

    public NonNullList<ItemStack> getResultStack(ItemStack stack, int nb_input, boolean withLoss) {
        NonNullList itemsList = NonNullList.m_122779_();
        RecyclingRecipe currentRecipe = this.getRecipe(stack);
        if (currentRecipe == null) {
            return itemsList;
        }
        boolean isDamaged = stack.m_41776_() > 0 && stack.m_41773_() > 0;
        for (int i = 0; i < currentRecipe.getCount(); ++i) {
            SimpleStack ingredient = this.getIngredient(currentRecipe.getResult(i), isDamaged || withLoss);
            float modifiedSize = ingredient.getCount();
            if (isDamaged) {
                modifiedSize *= (float)(stack.m_41776_() - stack.m_41773_()) / (float)stack.m_41776_();
            }
            if (withLoss) {
                modifiedSize /= 2.0f;
            }
            ingredient.setCount(((Boolean)ConfigRecycler.general.recycleRoundDown.get() != false ? Mth.m_14143_((float)modifiedSize) : Math.round(modifiedSize)) * nb_input);
            ItemStack result = new ItemStack((ItemLike)ingredient.getItem());
            int fullStackCount = ingredient.getCount() / result.m_41741_();
            if (fullStackCount > 0) {
                result.m_41764_(result.m_41741_());
                IntStream.range(0, fullStackCount).forEach(aInt -> itemsList.add((Object)result.m_41777_()));
                ingredient.shrink(fullStackCount * result.m_41741_());
            }
            if (ingredient.getCount() <= 0) continue;
            result.m_41764_(ingredient.getCount());
            itemsList.add((Object)result);
        }
        if (((Boolean)ConfigRecycler.general.recycleMagicItem.get()).booleanValue()) {
            itemsList.addAll(this.getEnchantedBooks(stack));
        }
        return itemsList;
    }

    private NonNullList<ItemStack> getEnchantedBooks(ItemStack stack) {
        Map<Enchantment, Integer> enchants = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(p -> p.getKey() != null && p.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        NonNullList books = NonNullList.m_122779_();
        if (!enchants.isEmpty()) {
            if (stack.m_41720_() == Items.f_42690_) {
                if (enchants.size() < 2) {
                    return books;
                }
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    ItemStack currentBook = new ItemStack((ItemLike)Items.f_42690_);
                    EnchantedBookItem.m_41153_((ItemStack)currentBook, (EnchantmentInstance)new EnchantmentInstance(entry.getKey(), entry.getValue().intValue()));
                    books.add((Object)currentBook);
                }
            } else {
                ItemStack currentBook = new ItemStack((ItemLike)Items.f_42690_);
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    EnchantedBookItem.m_41153_((ItemStack)currentBook, (EnchantmentInstance)new EnchantmentInstance(entry.getKey(), entry.getValue().intValue()));
                }
                books.add((Object)currentBook);
            }
        }
        return books;
    }

    private void loadGrindList() {
        if (!this.grindFile.exists()) {
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_150998_), (Object)new SimpleStack(Items.f_151049_, 4)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_151052_), (Object)new SimpleStack(ModItems.copper_nugget, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_42418_), (Object)new SimpleStack(ModItems.netherite_nugget, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_42415_), (Object)new SimpleStack(ModItems.diamond_shard, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_42416_), (Object)new SimpleStack(Items.f_42749_, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_42417_), (Object)new SimpleStack(Items.f_42587_, 9)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Items.f_42454_), (Object)new SimpleStack(Items.f_42649_, 4)));
            this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)new SimpleStack(Blocks.f_50705_), (Object)new SimpleStack(Items.f_42398_, 4)));
            Helper.saveAsJson(this.grindFile, this.grindList.stream().map(p -> ImmutablePair.of((Object)((SimpleStack)p.getLeft()).toString(), (Object)((SimpleStack)p.getRight()).toString())).toList());
        } else {
            Type token = new TypeToken<List<ImmutablePair<String, String>>>(){}.getType();
            List<ImmutablePair> jsonList = Helper.loadAsJson(this.grindFile, token);
            for (ImmutablePair pair : jsonList) {
                SimpleStack input = SimpleStack.fromJson((String)pair.getLeft());
                SimpleStack output = SimpleStack.fromJson((String)pair.getRight());
                if (input.isEmpty() || output.isEmpty()) continue;
                this.grindList.add((ImmutablePair<SimpleStack, SimpleStack>)new ImmutablePair((Object)input, (Object)output));
            }
        }
    }

    public synchronized boolean saveUserDefinedRecipes() {
        return Helper.saveAsJson(this.userDefinedFile, this.recipes.stream().filter(recipe -> recipe.isUserDefined() && recipe.isValid()).map(JsonRecyclingRecipe::new).toList());
    }

    private void loadUserDefinedRecipes() {
        Object jsonRecipesList;
        if (!this.userDefinedFile.exists()) {
            jsonRecipesList = NonNullList.m_122779_();
            Helper.saveAsJson(this.userDefinedFile, jsonRecipesList);
        } else {
            jsonRecipesList = Helper.loadAsJson(this.userDefinedFile, JsonRecyclingRecipe.class);
        }
        Iterator iterator = jsonRecipesList.iterator();
        while (iterator.hasNext()) {
            JsonRecyclingRecipe jsonRecipe = (JsonRecyclingRecipe)iterator.next();
            RecyclingRecipe recipe = new RecyclingRecipe(jsonRecipe);
            if (!recipe.ingredient.isEmpty() && recipe.getCount() > 0) {
                recipe.setUserDefined(true);
                this.recipes.add(recipe);
                continue;
            }
            ModRecycler.LOGGER.warn("Error while reading json recipe : " + jsonRecipe.inputItem);
        }
    }
}

