/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import java.util.Arrays;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.SimpleStack;

public class RecyclingRecipe
implements Comparable<RecyclingRecipe> {
    protected final SimpleStack ingredient;
    protected final NonNullList<SimpleStack> results = NonNullList.m_122779_();
    protected Boolean isDenied = null;
    protected boolean isUserDefined = false;

    public RecyclingRecipe(SimpleStack stackIn, NonNullList<SimpleStack> stacksOut) {
        this.ingredient = stackIn;
        this.results.addAll(stacksOut);
    }

    public RecyclingRecipe(ItemStack stackIn, NonNullList<SimpleStack> stacksOut) {
        this.ingredient = new SimpleStack(stackIn);
        this.results.addAll(stacksOut);
    }

    public RecyclingRecipe(SimpleStack stackIn, SimpleStack[] stacksOut) {
        this.ingredient = stackIn;
        Collections.addAll(this.results, stacksOut);
    }

    public RecyclingRecipe(JsonRecyclingRecipe jsonRecipe) {
        this(SimpleStack.fromJson(jsonRecipe.inputItem), (SimpleStack[])Arrays.stream(jsonRecipe.outputItems).map(SimpleStack::fromJson).filter(outputItem -> !outputItem.isEmpty()).toArray(SimpleStack[]::new));
    }

    public RecyclingRecipe(Recipe<?> recipe) {
        this(recipe.m_8043_(), Helper.mergetoSimpleStack(recipe.m_7527_().stream().filter(ing -> ing.m_43908_().length > 0).map(ing -> ing.m_43908_()[0]).toList()));
    }

    public SimpleStack getIngredient() {
        return this.ingredient;
    }

    public boolean isIngredient(SimpleStack stack) {
        return this.ingredient.is(stack);
    }

    public boolean isIngredient(ItemStack stack) {
        return this.ingredient.is(stack);
    }

    public boolean isIngredient(Item item) {
        return this.ingredient.is(item);
    }

    public boolean isValid() {
        return !this.results.isEmpty() && !this.ingredient.isEmpty();
    }

    public RecyclingRecipe setUserDefined(boolean state) {
        this.isUserDefined = state;
        return this;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    void setDenied(boolean state) {
        this.isDenied = state;
    }

    public boolean isDenied() {
        if (this.isDenied == null) {
            this.isDenied = RecyclingManager.INSTANCE.isDeniedRecipe(this);
        }
        return this.isDenied;
    }

    public int getCount() {
        return this.results.size();
    }

    public SimpleStack getResult(int index) {
        return (SimpleStack)this.results.get(index);
    }

    public NonNullList<SimpleStack> getResults() {
        return this.results;
    }

    @Override
    public int compareTo(RecyclingRecipe otherRecipe) {
        return this.getIngredient().compareTo(otherRecipe.getIngredient());
    }

    public boolean equals(Object o) {
        RecyclingRecipe recipe;
        Object object;
        return this == o || (object = o) instanceof RecyclingRecipe && (recipe = (RecyclingRecipe)object).isIngredient(this.getIngredient());
    }

    public int hashCode() {
        return this.getIngredient().hashCode();
    }
}

