/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleStack
implements Comparable<SimpleStack> {
    public static final SimpleStack EMPTY = new SimpleStack(ItemStack.f_41583_);
    private final Item item;
    private int count;
    private String translation = null;

    public SimpleStack(ItemStack stack) {
        this(stack.m_41720_(), stack.m_41613_());
    }

    public SimpleStack(@Nullable Item item, int count) {
        if (item != null) {
            this.item = item;
            this.count = count;
        } else {
            this.item = Items.f_41852_;
            this.count = 1;
        }
    }

    public SimpleStack(Item item) {
        this(item, 1);
    }

    public SimpleStack(Block block, int count) {
        this(block.m_5456_(), count);
    }

    public SimpleStack(Block block) {
        this(block, 1);
    }

    public Item getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int value) {
        this.count = value;
    }

    public void grow(int value) {
        this.count += value;
    }

    public void shrink(int value) {
        this.count -= value;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == null || this.item == Items.f_41852_;
    }

    public ItemStack asItemStack() {
        return new ItemStack((ItemLike)this.item, this.count);
    }

    public String getTranslation() {
        if (this.translation == null) {
            this.translation = new TranslatableComponent(this.item.m_5524_()).getString().toLowerCase(Locale.US);
        }
        return this.translation;
    }

    public String toString() {
        return this.item.getRegistryName() + ":" + this.count;
    }

    public boolean is(ItemStack stack) {
        return this.is(stack.m_41720_());
    }

    public boolean is(SimpleStack stack) {
        return this.is(stack.item);
    }

    public boolean is(Item item) {
        return this.item == item;
    }

    public SimpleStack copy() {
        return new SimpleStack(this.item, this.count);
    }

    public static SimpleStack fromJson(String jsonString) {
        Item item;
        String[] parts = jsonString.split(":");
        if ((parts.length == 2 || parts.length == 3) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
            return new SimpleStack(item, parts.length == 3 ? Integer.parseInt(parts[2]) : 1);
        }
        return new SimpleStack(ItemStack.f_41583_);
    }

    @Override
    public int compareTo(SimpleStack otherStack) {
        return this.getTranslation().compareTo(otherStack.getTranslation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof SimpleStack)) return false;
        SimpleStack stack = (SimpleStack)object;
        if (this.getItem() != stack.getItem()) return false;
        return true;
    }

    public int hashCode() {
        return this.item.hashCode();
    }
}

