/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.tileentity;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.registry.ModItems;
import ovh.corail.recycler.registry.ModSounds;
import ovh.corail.recycler.registry.ModTags;
import ovh.corail.recycler.registry.ModTileEntityTypes;

public class TileEntityRecycler
extends BlockEntity
implements Nameable {
    private final ItemStackHandler inventInput = new ItemStackHandlerAutoSaved(18);
    private final ItemStackHandler inventWorking = new RecyclerWorkingStackHandler();
    private final ItemStackHandler inventOutput = new ItemStackHandlerAutoSaved(18);
    private final ItemStackHandler inventVisual = new ItemStackHandler(9);
    private final EnergyStorage energyStorage = this.createEnergyStorage();
    private RecyclingRecipe lastRecipe = null;
    private String customName;
    private boolean isWorking = false;
    private int countTicks = 0;
    private int progress = 0;
    private int inputMax = 0;
    private int cantRecycleTicks = 0;
    private boolean recyclingBookGift = false;
    private LazyOptional<?> holderInventInput = LazyOptional.of(() -> this.inventInput);
    private LazyOptional<?> holderInventOutput = LazyOptional.of(() -> this.inventOutput);
    private LazyOptional<?> holderEnergyStorage = LazyOptional.of(() -> this.energyStorage);

    public TileEntityRecycler(BlockPos pos, BlockState state) {
        super(ModTileEntityTypes.RECYCLER, pos, state);
    }

    public ItemStackHandler getInventoryInput() {
        return this.inventInput;
    }

    public ItemStackHandler getInventoryWorking() {
        return this.inventWorking;
    }

    public ItemStackHandler getInventoryOutput() {
        return this.inventOutput;
    }

    public ItemStackHandler getInventoryVisual() {
        return this.inventVisual;
    }

    public boolean isOutputEmpty() {
        return IntStream.range(0, this.inventOutput.getSlots()).allMatch(slot -> this.inventOutput.getStackInSlot(slot).m_41619_());
    }

    private void transferSlotWorking() {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)this.inventWorking.extractItem(0, this.inventWorking.getStackInSlot(0).m_41613_(), false), (boolean)false);
    }

    public boolean recycle(@Nullable ServerPlayer player) {
        assert (this.f_58857_ != null);
        RecyclingManager recyclingManager = RecyclingManager.INSTANCE;
        ItemStack workingStack = this.inventWorking.getStackInSlot(0);
        ItemStack diskStack = this.inventWorking.getStackInSlot(1);
        ItemStack bookStack = this.inventWorking.getStackInSlot(2);
        if (workingStack.m_41619_() || diskStack.m_41619_()) {
            return false;
        }
        RecyclingRecipe recipe = recyclingManager.getRecipe(workingStack);
        if (recipe == null) {
            this.transferSlotWorking();
            return false;
        }
        int nb_input = this.getMaxRecycle(recipe);
        if (nb_input == 0) {
            return false;
        }
        if (this.isWorking) {
            nb_input = 1;
        }
        int loss = 0;
        if ((Integer)ConfigRecycler.general.chanceLoss.get() > 0) {
            int res = Helper.RANDOM.nextInt(100 * nb_input);
            if (res < (Integer)ConfigRecycler.general.chanceLoss.get() * nb_input) {
                loss = Mth.m_14143_((float)((float)res / (float)((Integer)ConfigRecycler.general.chanceLoss.get()).intValue() * (float)nb_input));
            }
            if (loss > 0) {
                LangKey.MESSAGE_LOSS.sendMessage((Player)player, new Object[0]);
            }
        }
        NonNullList result = NonNullList.m_122779_();
        if (loss < nb_input) {
            result.addAll(recyclingManager.getResultStack(workingStack, nb_input - loss));
        }
        if (loss > 0) {
            result.addAll(recyclingManager.getResultStack(workingStack, loss, true));
        }
        Helper.mergeStackInList((NonNullList<ItemStack>)result);
        if (!Helper.canInsertInInventory((IItemHandlerModifiable)this.inventOutput, (NonNullList<ItemStack>)result)) {
            LangKey.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendMessage((Player)player, new Object[0]);
            return false;
        }
        result.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventOutput, (ItemStack)stack, (boolean)false));
        int diskDamage = 10 * nb_input;
        if (diskStack.m_41773_() + diskDamage >= diskStack.m_41776_()) {
            LangKey.MESSAGE_BROKEN_DISK.sendMessage((Player)player, new Object[0]);
            this.inventWorking.setStackInSlot(1, ItemStack.f_41583_);
        } else {
            diskStack.m_41721_(diskStack.m_41773_() + diskDamage);
        }
        bookStack.m_41774_(this.getBookCount(workingStack) * nb_input);
        workingStack.m_41774_(nb_input * recipe.getIngredient().getCount());
        ModSounds.playSoundAllAround(ModSounds.RECYCLER, SoundSource.BLOCKS, this.f_58857_, this.f_58858_, 0.5f, 0.5f + this.f_58857_.f_46441_.nextFloat() * 0.5f);
        if (this.inventWorking.getStackInSlot(0).m_41619_()) {
            this.updateRecyclingRecipe();
        }
        return true;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileEntityRecycler recycler) {
        if (Helper.atInterval(level, 10)) {
            int slotId;
            ItemStack stackToRecycle = recycler.inventWorking.getStackInSlot(0);
            boolean requireRecipeUpdate = false;
            if (stackToRecycle.m_41619_()) {
                slotId = IntStream.range(0, recycler.inventInput.getSlots()).filter(slot -> {
                    ItemStack stackInSlot = recycler.inventInput.getStackInSlot(slot);
                    return !stackInSlot.m_41619_() && recycler.inventWorking.isItemValid(0, stackInSlot);
                }).findFirst().orElse(-1);
                if (slotId >= 0) {
                    recycler.inventWorking.insertItem(0, recycler.inventInput.extractItem(slotId, recycler.inventInput.getStackInSlot(slotId).m_41613_(), false), false);
                    requireRecipeUpdate = true;
                }
            } else if (stackToRecycle.m_41753_() && stackToRecycle.m_41613_() < stackToRecycle.m_41741_() && (slotId = IntStream.range(0, recycler.inventInput.getSlots()).filter(slot -> Helper.areItemEqual(stackToRecycle, recycler.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                recycler.inventWorking.insertItem(0, recycler.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (recycler.inventWorking.getStackInSlot(1).m_41619_() && (slotId = IntStream.range(0, recycler.inventInput.getSlots()).filter(slot -> recycler.inventWorking.isItemValid(1, recycler.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                recycler.inventWorking.insertItem(1, recycler.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (recycler.inventWorking.getStackInSlot(2).m_41613_() < recycler.inventWorking.getSlotLimit(2) && (slotId = IntStream.range(0, recycler.inventInput.getSlots()).filter(slot -> recycler.inventWorking.isItemValid(2, recycler.inventInput.getStackInSlot(slot))).findFirst().orElse(-1)) >= 0) {
                recycler.inventWorking.insertItem(2, recycler.inventInput.extractItem(slotId, 1, false), false);
                requireRecipeUpdate = true;
            }
            if (requireRecipeUpdate) {
                recycler.updateRecyclingRecipe();
            }
        }
        RecyclingRecipe baseRecipe = recycler.lastRecipe != null && recycler.lastRecipe.isIngredient(recycler.inventWorking.getStackInSlot(0)) ? recycler.lastRecipe : (recycler.lastRecipe = RecyclingManager.INSTANCE.getRecipe(recycler.inventWorking.getStackInSlot(0)));
        recycler.inputMax = recycler.getMaxRecycle(baseRecipe);
        if (!recycler.isWorking) {
            return;
        }
        if (!((Boolean)ConfigRecycler.shared_general.allow_automation.get()).booleanValue()) {
            recycler.updateWorking(false);
            return;
        }
        if (recycler.energyStorage.getEnergyStored() >= 10) {
            recycler.energyStorage.extractEnergy(10, false);
            recycler.countTicks -= 2;
        } else {
            --recycler.countTicks;
        }
        int maxTicks = (Integer)ConfigRecycler.general.timeToRecycle.get();
        if (recycler.inputMax < 1) {
            ++recycler.cantRecycleTicks;
            recycler.countTicks = maxTicks;
        }
        if (recycler.cantRecycleTicks > 40) {
            if (!recycler.inventWorking.getStackInSlot(0).m_41619_()) {
                recycler.transferSlotWorking();
            }
            recycler.updateWorking(false);
            recycler.cantRecycleTicks = 0;
            recycler.countTicks = maxTicks;
        }
        if (recycler.countTicks <= 0) {
            if (!recycler.recycle(null)) {
                ++recycler.cantRecycleTicks;
            }
            recycler.countTicks = maxTicks;
        } else if (recycler.cantRecycleTicks <= 1 && Helper.atInterval(recycler.countTicks, 15)) {
            ModSounds.playSoundAllAround(ModSounds.RECYCLER_WORKING, SoundSource.BLOCKS, level, pos, 0.5f, 0.5f + level.f_46441_.nextFloat() * 0.5f);
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + Helper.RANDOM.nextDouble(), (double)pos.m_123342_() + Helper.RANDOM.nextDouble(), (double)pos.m_123343_() + Helper.RANDOM.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        recycler.progress = (maxTicks - recycler.countTicks) * 100 / maxTicks;
    }

    public int getMaxRecycle(@Nullable RecyclingRecipe recipe) {
        ItemStack ingredient;
        int maxRecycle;
        if (recipe != null && (maxRecycle = (ingredient = this.inventWorking.getStackInSlot(0)).m_41613_() / Math.max(recipe.getIngredient().getCount(), 1)) > 0) {
            int bookCount;
            ItemStack disk = this.inventWorking.getStackInSlot(1);
            if (disk.m_41619_()) {
                return 0;
            }
            maxRecycle = Math.min(maxRecycle, (disk.m_41776_() - disk.m_41773_()) / 10);
            if (ingredient.m_41793_() && (bookCount = this.getBookCount(ingredient)) > 0) {
                maxRecycle = Math.min(maxRecycle, this.inventWorking.getStackInSlot(2).m_41613_() / bookCount);
            }
            return maxRecycle;
        }
        return 0;
    }

    public int getBookCount(ItemStack stack) {
        ListTag list;
        String tagName;
        boolean isEnchantedBook = stack.m_41720_() == Items.f_42690_;
        String string = tagName = isEnchantedBook ? "StoredEnchantments" : "Enchantments";
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(tagName, 9) && !(list = stack.m_41783_().m_128437_(tagName, 10)).isEmpty()) {
            return isEnchantedBook ? list.size() : 1;
        }
        return 0;
    }

    public void updateRecyclingRecipe() {
        int slotId;
        RecyclingRecipe recipe = RecyclingManager.INSTANCE.getRecipe(this.getInventoryWorking().getStackInSlot(0));
        boolean hasRecipe = recipe != null;
        NonNullList<ItemStack> currentRecipe = hasRecipe ? RecyclingManager.INSTANCE.getResultStack(this.getInventoryWorking().getStackInSlot(0), 1) : NonNullList.m_122779_();
        if (hasRecipe) {
            for (slotId = 0; slotId < Math.min(currentRecipe.size(), this.inventVisual.getSlots()); ++slotId) {
                if (((ItemStack)currentRecipe.get(slotId)).m_41720_() == this.inventVisual.getStackInSlot(slotId).m_41720_()) continue;
                this.inventVisual.setStackInSlot(slotId, (ItemStack)currentRecipe.get(slotId));
            }
        }
        while (slotId < this.inventVisual.getSlots()) {
            if (!this.inventVisual.getStackInSlot(slotId).m_41619_()) {
                this.inventVisual.setStackInSlot(slotId, ItemStack.f_41583_);
            }
            ++slotId;
        }
        this.progress = 0;
        this.inputMax = this.getMaxRecycle(recipe);
    }

    public void resetLastRecipe() {
        this.lastRecipe = null;
    }

    public void switchWorking() {
        this.updateWorking(!this.isWorking);
    }

    public void updateWorking(boolean isWorking) {
        this.setProgress(0);
        if (isWorking != this.isWorking) {
            this.isWorking = isWorking;
            Optional.ofNullable(this.f_58857_).ifPresent(l -> l.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BlockRecycler.ENABLED, (Comparable)Boolean.valueOf(isWorking))));
        }
    }

    public void setProgress(int progress) {
        if (progress == 0) {
            this.countTicks = (Integer)ConfigRecycler.general.timeToRecycle.get();
        }
        this.progress = progress;
    }

    public Component m_7755_() {
        return new TranslatableComponent("corail_recyclerblock.recycler.name");
    }

    public boolean m_8077_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public Component m_5446_() {
        return this.m_8077_() ? new TranslatableComponent(this.customName) : this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.m_8077_() ? new TranslatableComponent(this.customName) : null;
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return side == Direction.DOWN ? this.holderInventOutput.cast() : this.holderInventInput.cast();
            }
            if (cap == CapabilityEnergy.ENERGY) {
                return this.holderEnergyStorage.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holderInventInput.invalidate();
        this.holderInventOutput.invalidate();
        this.holderEnergyStorage.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.holderInventInput = LazyOptional.of(() -> this.inventInput);
        this.holderInventOutput = LazyOptional.of(() -> this.inventOutput);
        this.holderEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128365_("invent_input", (Tag)this.inventInput.serializeNBT());
        compound.m_128365_("invent_working", (Tag)this.inventWorking.serializeNBT());
        compound.m_128365_("invent_output", (Tag)this.inventOutput.serializeNBT());
        if (this.m_8077_()) {
            compound.m_128359_("custom_name", this.customName);
        }
        compound.m_128405_("count_ticks", this.countTicks);
        compound.m_128379_("is_working", this.isWorking);
        compound.m_128405_("progress", this.progress);
        compound.m_128405_("cant_recycle_ticks", this.cantRecycleTicks);
        Tag nbt = this.energyStorage.serializeNBT();
        if (nbt != null) {
            compound.m_128365_("energy", nbt);
        }
        compound.m_128379_("recycling_book_gift", this.recyclingBookGift);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventInput.deserializeNBT(compound.m_128469_("invent_input"));
        CompoundTag compoundInventWorking = compound.m_128469_("invent_working");
        if (compoundInventWorking.m_128425_("Size", 3)) {
            compoundInventWorking.m_128405_("Size", RecyclerWorkingStackHandler.EnumSlot.values().length);
        }
        this.inventWorking.deserializeNBT(compoundInventWorking);
        this.inventOutput.deserializeNBT(compound.m_128469_("invent_output"));
        if (compound.m_128425_("custom_name", 8)) {
            this.customName = compound.m_128461_("custom_name");
        }
        this.countTicks = compound.m_128451_("count_ticks");
        this.isWorking = compound.m_128471_("is_working");
        this.progress = compound.m_128451_("progress");
        this.cantRecycleTicks = compound.m_128451_("cant_recycle_ticks");
        if (compound.m_128441_("energy")) {
            this.energyStorage.deserializeNBT(compound.m_128423_("energy"));
        }
        this.recyclingBookGift = compound.m_128471_("recycling_book_gift");
    }

    public void giveRecyclingBook() {
        if (!this.recyclingBookGift) {
            this.recyclingBookGift = true;
            ItemHandlerHelper.insertItem((IItemHandler)this.inventOutput, (ItemStack)new ItemStack((ItemLike)ModItems.recycling_book), (boolean)false);
        }
    }

    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(10000, 20, 10){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int receiveEnergy = super.receiveEnergy(maxReceive, simulate);
                TileEntityRecycler.this.m_6596_();
                return receiveEnergy;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int extractEnergy = super.extractEnergy(maxExtract, simulate);
                TileEntityRecycler.this.m_6596_();
                return extractEnergy;
            }
        };
    }

    private class ItemStackHandlerAutoSaved
    extends ItemStackHandler {
        public ItemStackHandlerAutoSaved(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityRecycler.this.m_6596_();
        }
    }

    public class RecyclerWorkingStackHandler
    extends ItemStackHandlerAutoSaved {
        public RecyclerWorkingStackHandler() {
            super(EnumSlot.values().length);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot >= 0 && slot < EnumSlot.values().length && EnumSlot.values()[slot].predicate.test(stack);
        }

        public static enum EnumSlot {
            ITEM(p -> Items.f_42517_ != p.m_41720_() && !ModTags.Items.disks.m_8110_((Object)p.m_41720_())),
            DISK(p -> ModTags.Items.disks.m_8110_((Object)p.m_41720_())),
            BOOK(p -> Items.f_42517_ == p.m_41720_());

            public final Predicate<ItemStack> predicate;

            private EnumSlot(Predicate<ItemStack> predicate) {
                this.predicate = predicate;
            }
        }
    }

    public class RecyclerData
    implements ContainerData {
        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> {
                    if (TileEntityRecycler.this.isWorking) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> TileEntityRecycler.this.progress;
                case 2 -> TileEntityRecycler.this.inputMax;
                case 3 -> TileEntityRecycler.this.energyStorage.getEnergyStored();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityRecycler.this.isWorking = value > 0;
                    break;
                }
                case 1: {
                    TileEntityRecycler.this.progress = value;
                    break;
                }
                case 2: {
                    TileEntityRecycler.this.inputMax = value;
                    break;
                }
                case 3: {
                    int diff = value - TileEntityRecycler.this.energyStorage.getEnergyStored();
                    if (diff >= 0) {
                        TileEntityRecycler.this.energyStorage.receiveEnergy(diff, false);
                        break;
                    }
                    TileEntityRecycler.this.energyStorage.extractEnergy(-diff, false);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    }
}

