/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.blocks;

import com.icarusfell.diabloloot.blocks.GemTableContainer;
import com.icarusfell.diabloloot.blocks.ModBlocks;
import com.icarusfell.diabloloot.handlers.GemCreationHandler;
import com.icarusfell.diabloloot.items.SkillGem;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GemTableTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private GemCreationHandler gemhandler = new GemCreationHandler();
    private int counter;

    public GemTableTile() {
        super(ModBlocks.GEMTABLE_TILE);
    }

    public void func_73660_a() {
        this.handler.ifPresent(h -> {
            if (!(!h.getStackInSlot(0).func_77942_o() || !h.getStackInSlot(1).func_77942_o() || h.getStackInSlot(0).func_77978_p().func_74779_i("gemName").contains(h.getStackInSlot(1).func_77978_p().func_74779_i("gemName")) && h.getStackInSlot(0).func_77978_p().func_74779_i("gemDisplayName").contains(h.getStackInSlot(1).func_77978_p().func_74779_i("gemDisplayName")) && h.getStackInSlot(0).func_77978_p().func_74762_e("gemLevel") == h.getStackInSlot(1).func_77978_p().func_74762_e("gemLevel") && h.getStackInSlot(0).func_77978_p().func_74779_i("gemAbrv").contains(h.getStackInSlot(1).func_77978_p().func_74779_i("gemAbrv")) && h.getStackInSlot(0).func_77978_p().func_74762_e("gemHunger") == h.getStackInSlot(1).func_77978_p().func_74762_e("gemHunger"))) {
                h.getStackInSlot(1).func_190918_g(1);
            }
            if (h.getStackInSlot(0).func_77942_o() && h.getStackInSlot(0).func_77978_p().func_74767_n("hasGem")) {
                ItemStack currentgem = this.gemhandler.createGem();
                currentgem.func_77982_d(new CompoundNBT());
                currentgem.func_77978_p().func_74757_a("gemActive", true);
                if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedWeapon")) {
                    currentgem.func_77978_p().func_74778_a("gemType", "\u00a7cAttack");
                }
                if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedArmor")) {
                    currentgem.func_77978_p().func_74778_a("gemType", "\u00a7aDefense");
                }
                if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedBow")) {
                    currentgem.func_77978_p().func_74778_a("gemType", "\u00a7eRanged");
                }
                currentgem.func_77978_p().func_74778_a("gemName", h.getStackInSlot(0).func_77978_p().func_74779_i("gemName"));
                currentgem.func_77978_p().func_74778_a("gemAbrv", h.getStackInSlot(0).func_77978_p().func_74779_i("gemAbrv"));
                currentgem.func_77978_p().func_74778_a("gemDisplayName", h.getStackInSlot(0).func_77978_p().func_74779_i("gemDisplayName"));
                currentgem.func_77978_p().func_74768_a("gemLevel", h.getStackInSlot(0).func_77978_p().func_74762_e("gemLevel"));
                currentgem.func_77978_p().func_74768_a("gemHunger", h.getStackInSlot(0).func_77978_p().func_74762_e("gemHunger"));
                this.gemhandler.setCustomName(currentgem);
                currentgem.func_77978_p().func_74757_a("recentlyPut", true);
                h.insertItem(1, currentgem, false);
            } else if (!h.getStackInSlot(1).func_190926_b()) {
                h.getStackInSlot(1).func_190918_g(1);
            }
        });
    }

    public void getClicked(PlayerEntity player, int operation) {
        if (operation == 0) {
            this.handler.ifPresent(h -> {
                if (h.getStackInSlot(0).func_77942_o() && h.getStackInSlot(0).func_77978_p().func_74767_n("hasGem")) {
                    if (h.getStackInSlot(2).func_190926_b()) {
                        ItemStack newgem = this.gemhandler.createGem();
                        ItemStack newitem = h.getStackInSlot(0).func_77946_l();
                        newgem.func_77982_d(new CompoundNBT());
                        newgem.func_77978_p().func_74757_a("gemActive", true);
                        if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedWeapon")) {
                            newgem.func_77978_p().func_74778_a("gemType", "\u00a7cAttack");
                        }
                        if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedArmor")) {
                            newgem.func_77978_p().func_74778_a("gemType", "\u00a7aDefense");
                        }
                        if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedBow")) {
                            newgem.func_77978_p().func_74778_a("gemType", "\u00a7eRanged");
                        }
                        newgem.func_77978_p().func_74778_a("gemName", newitem.func_77978_p().func_74779_i("gemName"));
                        newgem.func_77978_p().func_74778_a("gemAbrv", newitem.func_77978_p().func_74779_i("gemAbrv"));
                        newgem.func_77978_p().func_74778_a("gemDisplayName", newitem.func_77978_p().func_74779_i("gemDisplayName"));
                        newgem.func_77978_p().func_74768_a("gemLevel", newitem.func_77978_p().func_74762_e("gemLevel"));
                        newgem.func_77978_p().func_74768_a("gemHunger", newitem.func_77978_p().func_74762_e("gemHunger"));
                        this.gemhandler.setCustomName(newgem);
                        newitem.func_77978_p().func_82580_o("hasGem");
                        newitem.func_77978_p().func_82580_o("gemAbrv");
                        newitem.func_77978_p().func_82580_o("gemDisplayName");
                        newitem.func_77978_p().func_82580_o("gemName");
                        newitem.func_77978_p().func_82580_o("gemLevel");
                        h.getStackInSlot(0).func_190918_g(1);
                        h.insertItem(0, newitem, false);
                        h.insertItem(2, newgem, false);
                    } else {
                        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7cGem slot must be empty."), UUID.randomUUID());
                    }
                } else {
                    player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7cThis item doesn't have a gem in it."), UUID.randomUUID());
                }
            });
        }
        if (operation == 1) {
            this.handler.ifPresent(h -> {
                if (h.getStackInSlot(0).func_77942_o() && !h.getStackInSlot(0).func_77978_p().func_74767_n("hasGem")) {
                    if (h.getStackInSlot(2).func_77973_b() instanceof SkillGem && h.getStackInSlot(2).func_77978_p().func_74767_n("gemActive")) {
                        if (h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedWeapon") && h.getStackInSlot(2).func_77978_p().func_74779_i("gemType").contains("Attack") || h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedArmor") && h.getStackInSlot(2).func_77978_p().func_74779_i("gemType").contains("Defense") || h.getStackInSlot(0).func_77978_p().func_74767_n("canBeModifiedBow") && h.getStackInSlot(2).func_77978_p().func_74779_i("gemType").contains("Ranged")) {
                            ItemStack newitem = h.getStackInSlot(0).func_77946_l();
                            newitem.func_77978_p().func_74757_a("hasGem", true);
                            newitem.func_77978_p().func_74778_a("gemName", h.getStackInSlot(2).func_77978_p().func_74779_i("gemName"));
                            newitem.func_77978_p().func_74778_a("gemAbrv", h.getStackInSlot(2).func_77978_p().func_74779_i("gemAbrv"));
                            newitem.func_77978_p().func_74778_a("gemDisplayName", h.getStackInSlot(2).func_77978_p().func_74779_i("gemDisplayName"));
                            newitem.func_77978_p().func_74768_a("gemLevel", h.getStackInSlot(2).func_77978_p().func_74762_e("gemLevel"));
                            newitem.func_77978_p().func_74768_a("gemHunger", h.getStackInSlot(2).func_77978_p().func_74762_e("gemHunger"));
                            h.getStackInSlot(0).func_190918_g(1);
                            h.getStackInSlot(2).func_190918_g(1);
                            h.insertItem(0, newitem, false);
                        } else {
                            player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7cGem type and item type should be the same."), UUID.randomUUID());
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7cYou have to have a gem to put in."), UUID.randomUUID());
                    }
                } else {
                    player.func_145747_a((ITextComponent)new StringTextComponent("\u00a7cThis item already has a gem in it."), UUID.randomUUID());
                }
            });
        }
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        this.counter = tag.func_74762_e("counter");
        super.func_230337_a_(p_230337_1_, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        tag.func_74768_a("counter", this.counter);
        return super.func_189515_b(tag);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                GemTableTile.this.func_70296_d();
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                this.validateSlotIndex(slot);
                this.stacks.set(slot, (Object)stack);
                this.onContentsChanged(slot);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return stack.func_77942_o() && stack.func_77978_p().func_74767_n("canBeModifiedWeapon") || stack.func_77942_o() && stack.func_77978_p().func_74767_n("canBeModifiedArmor") || stack.func_77942_o() && stack.func_77978_p().func_74767_n("canBeModifiedBow");
                }
                if (slot == 1) {
                    return stack.func_77942_o() && stack.func_77973_b() instanceof SkillGem && stack.func_77978_p().func_74767_n("gemActive") && stack.func_77978_p().func_74767_n("recentlyPut");
                }
                if (slot == 2) {
                    return stack.func_77942_o() && stack.func_77973_b() instanceof SkillGem && stack.func_77978_p().func_74767_n("gemActive");
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new GemTableContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

