/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import com.icarusfell.diabloloot.handlers.CustomArmorHandler;
import com.icarusfell.diabloloot.handlers.CustomWeaponHandler;
import com.icarusfell.diabloloot.handlers.GemCreationHandler;
import com.icarusfell.diabloloot.items.Currency;
import com.icarusfell.diabloloot.items.SkillGem;
import com.icarusfell.diabloloot.lists.ItemList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobDropsHandler {
    private CustomArmorHandler armorhandler = new CustomArmorHandler();
    private CustomWeaponHandler weaponhandler = new CustomWeaponHandler();
    private GemCreationHandler gemhandler = new GemCreationHandler();

    @SubscribeEvent
    public void onMonsterDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            ItemStack stack;
            if (event.getEntity() instanceof MonsterEntity || event.getEntity() instanceof SlimeEntity || event.getEntity() instanceof FlyingEntity) {
                if (new Random().nextInt(100) + 1 < 5) {
                    stack = this.armorhandler.returnRandomArmor();
                    this.armorhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.armorhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.armorhandler.setRandomUUID(stack);
                    this.armorhandler.setToBeModified(stack);
                    this.armorhandler.addCustomModifiers(stack);
                    this.armorhandler.hideVanillaModifiers(stack);
                    this.armorhandler.setCustomName(stack);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(100) + 1 < 5) {
                    stack = this.weaponhandler.returnRandomWeapon();
                    this.weaponhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.weaponhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.weaponhandler.setToBeModified(stack);
                    this.weaponhandler.addCustomModifiers(stack);
                    this.weaponhandler.hideVanillaModifiers(stack);
                    this.weaponhandler.setCustomName(stack);
                    this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(200) + 1 == 1) {
                    stack = this.gemhandler.createGem();
                    this.gemhandler.create(stack);
                    this.gemhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(25) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.transmutation_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(25) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.alteration_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(75) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.emperors_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(75) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.chaos_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(250) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.enforcing_crystal);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(250) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.corruption_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(1000) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.exalted_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(1250) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.mirror_of_cubeland);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
            }
            if (event.getEntity() instanceof AnimalEntity) {
                if (new Random().nextInt(100) + 1 < 2) {
                    stack = this.armorhandler.returnRandomArmor();
                    this.armorhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.armorhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.armorhandler.setRandomUUID(stack);
                    this.armorhandler.setToBeModified(stack);
                    this.armorhandler.addCustomModifiers(stack);
                    this.armorhandler.hideVanillaModifiers(stack);
                    this.armorhandler.setCustomName(stack);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(100) + 1 < 2) {
                    stack = this.weaponhandler.returnRandomWeapon();
                    this.weaponhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.weaponhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.weaponhandler.setToBeModified(stack);
                    this.weaponhandler.addCustomModifiers(stack);
                    this.weaponhandler.hideVanillaModifiers(stack);
                    this.weaponhandler.setCustomName(stack);
                    this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(250) + 1 == 1) {
                    stack = this.gemhandler.createGem();
                    this.gemhandler.create(stack);
                    this.gemhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(50) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.transmutation_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(50) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.alteration_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(150) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.emperors_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(150) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.chaos_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(500) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.enforcing_crystal);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(500) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.corruption_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(1750) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.exalted_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(2000) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.mirror_of_cubeland);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
            }
        }
    }

    @SubscribeEvent
    public void onExistArmor(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!(stack.func_77973_b() instanceof ArmorItem) || stack.func_77942_o()) continue;
                stack.func_77982_d(new CompoundNBT());
                if (stack.func_77978_p().func_74767_n("canBeModifiedArmor")) continue;
                this.armorhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                this.armorhandler.setItemLevel(stack, this.returnRandomLevel((Entity)player));
                this.armorhandler.setRandomUUID(stack);
                this.armorhandler.setToBeModified(stack);
                this.armorhandler.addCustomModifiers(stack);
                this.armorhandler.hideVanillaModifiers(stack);
                this.armorhandler.setCustomName(stack);
                stack.func_77978_p().func_74757_a("handcrafted", true);
            }
        }
    }

    @SubscribeEvent
    public void onExistGem(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!(stack.func_77973_b() instanceof SkillGem) || stack.func_77942_o()) continue;
                stack.func_77982_d(new CompoundNBT());
                if (stack.func_77978_p().func_74767_n("gemActive")) continue;
                this.gemhandler.create(stack);
            }
        }
    }

    @SubscribeEvent
    public void itemEvent(ItemTossEvent event) {
        if (event.getEntityItem().func_92059_d().func_82837_s() || event.getEntityItem().func_92059_d().func_77973_b() instanceof Currency) {
            event.getEntityItem().func_200203_b(event.getEntityItem().func_92059_d().func_200301_q());
            event.getEntityItem().func_174805_g(true);
        }
    }

    private int returnRandomLevel(Entity entity) {
        int minLvl = entity.getPersistentData().func_74762_e("diablolootlevel") - 1;
        int maxLvl = entity.getPersistentData().func_74762_e("diablolootlevel") + 1;
        if (entity.getPersistentData().func_74762_e("diablolootlevel") == 1) {
            return new Random().nextInt(maxLvl - minLvl) + minLvl + 1;
        }
        if (entity.getPersistentData().func_74762_e("diablolootlevel") == 100) {
            return new Random().nextInt(maxLvl - minLvl) + minLvl;
        }
        return new Random().nextInt(maxLvl - minLvl + 1) + minLvl;
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.getPersistentData().func_74767_n("diablolootstarterWeapon")) {
            player.getPersistentData().func_74757_a("diablolootstarterWeapon", true);
            ItemStack stack = this.weaponhandler.returnRandomWeapon();
            this.weaponhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
            this.weaponhandler.setItemLevel(stack, 1);
            this.weaponhandler.setToBeModified(stack);
            this.weaponhandler.addCustomModifiers(stack);
            this.weaponhandler.hideVanillaModifiers(stack);
            this.weaponhandler.setCustomName(stack);
            this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
            ItemStack book = new ItemStack((IItemProvider)ItemList.book_of_skills);
            player.func_191521_c(book);
        }
    }

    @SubscribeEvent
    public void onExistWeapon(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if ((!(stack.func_77973_b() instanceof SwordItem) || stack.func_77942_o()) && (!(stack.func_77973_b() instanceof AxeItem) || stack.func_77942_o())) continue;
                stack.func_77982_d(new CompoundNBT());
                if (stack.func_77978_p().func_74767_n("canBeModifiedWeapon")) continue;
                this.weaponhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                this.weaponhandler.setItemLevel(stack, this.returnRandomLevel((Entity)player));
                this.weaponhandler.setToBeModified(stack);
                this.weaponhandler.addCustomModifiers(stack);
                this.weaponhandler.hideVanillaModifiers(stack);
                this.weaponhandler.setCustomName(stack);
                stack.func_77978_p().func_74757_a("handcrafted", true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void render(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            Minecraft mc = Minecraft.func_71410_x();
            String health = (int)mc.field_71439_g.getPersistentData().func_74769_h("diablolootdefaultHealth") + " / " + (int)mc.field_71439_g.getPersistentData().func_74769_h("diablolootmaxHealth");
            if (mc.field_195558_d.func_198087_p() / 2 >= 120 && mc.field_195558_d.func_198087_p() / 2 <= 143) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 65), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 143 && mc.field_195558_d.func_198087_p() / 2 <= 158) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 75), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 158 && mc.field_195558_d.func_198087_p() / 2 <= 175) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 90), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 175 && mc.field_195558_d.func_198087_p() / 2 <= 190) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 95), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 190 && mc.field_195558_d.func_198087_p() / 2 <= 232) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 140), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 232 && mc.field_195558_d.func_198087_p() / 2 <= 302) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 200), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 302 && mc.field_195558_d.func_198087_p() / 2 <= 400) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 280), 0xFF3737);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 400) {
                mc.field_71466_p.func_175063_a(health, (float)(mc.field_195558_d.func_198107_o() / 2 - 80), (float)(mc.field_195558_d.func_198087_p() / 2 + 370), 0xFF3737);
            }
            String armor = (int)mc.field_71439_g.getPersistentData().func_74769_h("diablolootphysicalArmor") + "";
            if (mc.field_195558_d.func_198087_p() / 2 >= 120 && mc.field_195558_d.func_198087_p() / 2 <= 143) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 + -10), (float)(mc.field_195558_d.func_198087_p() / 2 + 65), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 143 && mc.field_195558_d.func_198087_p() / 2 <= 158) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 75), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 158 && mc.field_195558_d.func_198087_p() / 2 <= 175) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 90), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 175 && mc.field_195558_d.func_198087_p() / 2 <= 190) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 95), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 190 && mc.field_195558_d.func_198087_p() / 2 <= 232) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 140), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 232 && mc.field_195558_d.func_198087_p() / 2 <= 302) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 200), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 302 && mc.field_195558_d.func_198087_p() / 2 <= 400) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 280), 0xC3C4C4);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 400) {
                mc.field_71466_p.func_175063_a(armor, (float)(mc.field_195558_d.func_198107_o() / 2 - 10), (float)(mc.field_195558_d.func_198087_p() / 2 + 370), 0xC3C4C4);
            }
            String iarmor = (int)mc.field_71439_g.getPersistentData().func_74769_h("diablolooticeArmor") + "";
            if (mc.field_195558_d.func_198087_p() / 2 >= 120 && mc.field_195558_d.func_198087_p() / 2 <= 143) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 65), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 143 && mc.field_195558_d.func_198087_p() / 2 <= 158) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 75), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 158 && mc.field_195558_d.func_198087_p() / 2 <= 175) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 90), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 175 && mc.field_195558_d.func_198087_p() / 2 <= 190) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 95), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 190 && mc.field_195558_d.func_198087_p() / 2 <= 232) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 140), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 232 && mc.field_195558_d.func_198087_p() / 2 <= 302) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 200), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 302 && mc.field_195558_d.func_198087_p() / 2 <= 400) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 280), 131056);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 400) {
                mc.field_71466_p.func_175063_a(iarmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 15), (float)(mc.field_195558_d.func_198087_p() / 2 + 370), 131056);
            }
            String farmor = (int)mc.field_71439_g.getPersistentData().func_74769_h("diablolootfireArmor") + "";
            if (mc.field_195558_d.func_198087_p() / 2 >= 120 && mc.field_195558_d.func_198087_p() / 2 <= 143) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 65), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 143 && mc.field_195558_d.func_198087_p() / 2 <= 158) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 75), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 158 && mc.field_195558_d.func_198087_p() / 2 <= 175) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 90), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 175 && mc.field_195558_d.func_198087_p() / 2 <= 190) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 95), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 190 && mc.field_195558_d.func_198087_p() / 2 <= 232) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 140), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 232 && mc.field_195558_d.func_198087_p() / 2 <= 302) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 200), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 302 && mc.field_195558_d.func_198087_p() / 2 <= 400) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 280), 16742401);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 400) {
                mc.field_71466_p.func_175063_a(farmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 40), (float)(mc.field_195558_d.func_198087_p() / 2 + 370), 16742401);
            }
            String carmor = (int)mc.field_71439_g.getPersistentData().func_74769_h("diablolootchaosArmor") + "";
            if (mc.field_195558_d.func_198087_p() / 2 >= 120 && mc.field_195558_d.func_198087_p() / 2 <= 143) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 65), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 143 && mc.field_195558_d.func_198087_p() / 2 <= 158) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 75), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 158 && mc.field_195558_d.func_198087_p() / 2 <= 175) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 90), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 175 && mc.field_195558_d.func_198087_p() / 2 <= 190) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 95), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 190 && mc.field_195558_d.func_198087_p() / 2 <= 232) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 140), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 232 && mc.field_195558_d.func_198087_p() / 2 <= 302) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 200), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 302 && mc.field_195558_d.func_198087_p() / 2 <= 400) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 280), 57678);
            } else if (mc.field_195558_d.func_198087_p() / 2 > 400) {
                mc.field_71466_p.func_175063_a(carmor, (float)(mc.field_195558_d.func_198107_o() / 2 + 65), (float)(mc.field_195558_d.func_198087_p() / 2 + 370), 57678);
            }
            String exp = mc.field_71439_g.getPersistentData().func_74762_e("diablolootexp") + " / " + mc.field_71439_g.getPersistentData().func_74762_e("diablolootexpneeded");
            mc.field_71466_p.func_175063_a(exp, (float)(mc.field_195558_d.func_198107_o() / 2 - 22), 17.0f, 0xF7FF00);
            String level = mc.field_71439_g.getPersistentData().func_74762_e("diablolootlevel") + "";
            mc.field_71466_p.func_175063_a(level, (float)(mc.field_195558_d.func_198107_o() / 2), 2.0f, 16751360);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHealthBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
            event.setCanceled(true);
        }
    }
}

