/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.handlers;

import com.icarusfell.diabloloot.handlers.CustomArmorHandler;
import com.icarusfell.diabloloot.handlers.CustomRangedWeaponHandler;
import com.icarusfell.diabloloot.handlers.CustomWeaponHandler;
import com.icarusfell.diabloloot.handlers.GemCreationHandler;
import com.icarusfell.diabloloot.items.Currency;
import com.icarusfell.diabloloot.items.SkillGem;
import com.icarusfell.diabloloot.lists.ItemList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobDropsHandler {
    private CustomArmorHandler armorhandler = new CustomArmorHandler();
    private CustomWeaponHandler weaponhandler = new CustomWeaponHandler();
    private GemCreationHandler gemhandler = new GemCreationHandler();
    private CustomRangedWeaponHandler rangedweaponhandler = new CustomRangedWeaponHandler();

    @SubscribeEvent
    public void onMonsterDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            ItemStack stack;
            if (event.getEntity() instanceof MonsterEntity || event.getEntity() instanceof SlimeEntity || event.getEntity() instanceof FlyingEntity) {
                if (new Random().nextInt(100) + 1 < 5) {
                    stack = this.armorhandler.returnRandomArmor();
                    this.armorhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.armorhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.armorhandler.setRandomUUID(stack);
                    this.armorhandler.setToBeModified(stack);
                    this.armorhandler.addCustomModifiers(stack);
                    this.armorhandler.hideVanillaModifiers(stack);
                    this.armorhandler.setCustomName(stack);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(100) + 1 < 5) {
                    stack = this.weaponhandler.returnRandomWeapon();
                    this.weaponhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.weaponhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.weaponhandler.setToBeModified(stack);
                    this.weaponhandler.addCustomModifiers(stack);
                    this.weaponhandler.hideVanillaModifiers(stack);
                    this.weaponhandler.setCustomName(stack);
                    this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(100) + 1 < 5) {
                    stack = this.rangedweaponhandler.returnRandomBow();
                    this.rangedweaponhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                    this.rangedweaponhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.rangedweaponhandler.setToBeModified(stack);
                    this.rangedweaponhandler.addCustomModifiers(stack);
                    this.rangedweaponhandler.hideVanillaModifiers(stack);
                    this.rangedweaponhandler.setCustomName(stack);
                    this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(200) + 1 == 1) {
                    stack = this.gemhandler.createGem();
                    this.gemhandler.create(stack);
                    this.gemhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(25) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.transmutation_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(25) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.alteration_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(75) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.emperors_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(75) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.chaos_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(250) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.enforcing_crystal);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(250) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.corruption_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(1000) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.exalted_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(1250) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.mirror_of_cubeland);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
            }
            if (event.getEntity() instanceof AnimalEntity) {
                if (new Random().nextInt(100) + 1 < 2) {
                    stack = this.armorhandler.returnRandomArmor();
                    this.armorhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.armorhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.armorhandler.setRandomUUID(stack);
                    this.armorhandler.setToBeModified(stack);
                    this.armorhandler.addCustomModifiers(stack);
                    this.armorhandler.hideVanillaModifiers(stack);
                    this.armorhandler.setCustomName(stack);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(100) + 1 < 2) {
                    stack = this.weaponhandler.returnRandomWeapon();
                    this.weaponhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
                    this.weaponhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.weaponhandler.setToBeModified(stack);
                    this.weaponhandler.addCustomModifiers(stack);
                    this.weaponhandler.hideVanillaModifiers(stack);
                    this.weaponhandler.setCustomName(stack);
                    this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(100) + 1 < 2) {
                    stack = this.rangedweaponhandler.returnRandomBow();
                    this.rangedweaponhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                    this.rangedweaponhandler.setItemLevel(stack, this.returnRandomLevel(event.getEntity()));
                    this.rangedweaponhandler.setToBeModified(stack);
                    this.rangedweaponhandler.addCustomModifiers(stack);
                    this.rangedweaponhandler.hideVanillaModifiers(stack);
                    this.rangedweaponhandler.setCustomName(stack);
                    this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(250) + 1 == 1) {
                    stack = this.gemhandler.createGem();
                    this.gemhandler.create(stack);
                    this.gemhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(50) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.transmutation_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(50) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.alteration_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(150) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.emperors_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(150) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.chaos_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(500) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.enforcing_crystal);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(500) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.corruption_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(1750) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.exalted_orb);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
                if (new Random().nextInt(2000) + 1 == 5) {
                    stack = new ItemStack((IItemProvider)ItemList.mirror_of_cubeland);
                    this.armorhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
                }
            }
        }
    }

    @SubscribeEvent
    public void onExistArmor(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                CompoundNBT nbt;
                if (!(stack.func_77973_b() instanceof ArmorItem) || (nbt = stack.func_196082_o()).func_74767_n("canBeModifiedArmor")) continue;
                this.armorhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                this.armorhandler.setItemLevel(stack, this.returnRandomLevel((Entity)player));
                this.armorhandler.setRandomUUID(stack);
                this.armorhandler.setToBeModified(stack);
                this.armorhandler.addCustomModifiers(stack);
                this.armorhandler.hideVanillaModifiers(stack);
                this.armorhandler.setCustomName(stack);
                stack.func_77978_p().func_74757_a("handcrafted", true);
            }
        }
    }

    @SubscribeEvent
    public void onExistGem(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!(stack.func_77973_b() instanceof SkillGem) || stack.func_77942_o()) continue;
                stack.func_77982_d(new CompoundNBT());
                if (stack.func_77978_p().func_74767_n("gemActive")) continue;
                this.gemhandler.create(stack);
            }
        }
    }

    @SubscribeEvent
    public void onExistWeapon(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                CompoundNBT nbt;
                if (!(stack.func_77973_b() instanceof SwordItem) && !(stack.func_77973_b() instanceof AxeItem) || (nbt = stack.func_196082_o()).func_74767_n("canBeModifiedWeapon")) continue;
                this.weaponhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                this.weaponhandler.setItemLevel(stack, this.returnRandomLevel((Entity)player));
                this.weaponhandler.setToBeModified(stack);
                this.weaponhandler.addCustomModifiers(stack);
                this.weaponhandler.hideVanillaModifiers(stack);
                this.weaponhandler.setCustomName(stack);
                stack.func_77978_p().func_74757_a("handcrafted", true);
            }
        }
    }

    @SubscribeEvent
    public void onExistBow(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                CompoundNBT nbt;
                if (!(stack.func_77973_b() instanceof BowItem) || (nbt = stack.func_196082_o()).func_74767_n("canBeModifiedBow")) continue;
                this.rangedweaponhandler.setRandomTier(stack, 85, 75, 30, 20, 10);
                this.rangedweaponhandler.setItemLevel(stack, this.returnRandomLevel((Entity)player));
                this.rangedweaponhandler.setToBeModified(stack);
                this.rangedweaponhandler.addCustomModifiers(stack);
                this.rangedweaponhandler.hideVanillaModifiers(stack);
                this.rangedweaponhandler.setCustomName(stack);
                stack.func_77978_p().func_74757_a("handcrafted", true);
            }
        }
    }

    @SubscribeEvent
    public void itemEvent(ItemTossEvent event) {
        if (event.getEntityItem().func_92059_d().func_82837_s() || event.getEntityItem().func_92059_d().func_77973_b() instanceof Currency) {
            event.getEntityItem().func_200203_b(event.getEntityItem().func_92059_d().func_200301_q());
            event.getEntityItem().func_174805_g(true);
        }
    }

    private int returnRandomLevel(Entity entity) {
        int minLvl = entity.getPersistentData().func_74762_e("diablolootlevel") - 1;
        int maxLvl = entity.getPersistentData().func_74762_e("diablolootlevel") + 1;
        if (entity.getPersistentData().func_74762_e("diablolootlevel") == 1) {
            return new Random().nextInt(maxLvl - minLvl) + minLvl + 1;
        }
        if (entity.getPersistentData().func_74762_e("diablolootlevel") == 100) {
            return new Random().nextInt(maxLvl - minLvl) + minLvl;
        }
        return new Random().nextInt(maxLvl - minLvl + 1) + minLvl;
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.getPersistentData().func_74767_n("diablolootstarterWeapon")) {
            player.getPersistentData().func_74757_a("diablolootstarterWeapon", true);
            ItemStack stack = this.weaponhandler.returnRandomWeapon();
            this.weaponhandler.setRandomTier(stack, 70, 50, 40, 35, 30);
            this.weaponhandler.setItemLevel(stack, 1);
            this.weaponhandler.setToBeModified(stack);
            this.weaponhandler.addCustomModifiers(stack);
            this.weaponhandler.hideVanillaModifiers(stack);
            this.weaponhandler.setCustomName(stack);
            this.weaponhandler.drop(stack, event.getEntity(), event.getEntity().func_130014_f_());
            ItemStack book = new ItemStack((IItemProvider)ItemList.book_of_skills);
            player.func_191521_c(book);
        }
    }
}

