/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.diabloloot.oldtradecode;

import com.icarusfell.diabloloot.oldtradecode.TradeContainer;
import com.icarusfell.diabloloot.oldtradecode.TradeItemStackHandler;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class TradeManager
implements INamedContainerProvider {
    public static final TradeManager EMPTY = new TradeManager(null, null);
    public static final int TICKS_COUNT = 400;
    private PlayerEntity sender;
    private PlayerEntity reciever;
    private TradeItemStackHandler handler;
    private boolean recieverAccepted;
    private boolean isComplete;

    public TradeManager(PlayerEntity sender, PlayerEntity reciever) {
        this.sender = sender;
        this.reciever = reciever;
        this.handler = new TradeItemStackHandler(24, this);
    }

    public PlayerEntity getSender() {
        return this.sender;
    }

    public PlayerEntity getReciever() {
        return this.reciever;
    }

    public boolean isAccepted() {
        return this.recieverAccepted;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void accept() {
        this.recieverAccepted = true;
    }

    public void run() {
        if (this.recieverAccepted) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.sender), (INamedContainerProvider)this);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.reciever), (INamedContainerProvider)this);
        }
    }

    public void message() {
        String _sender = this.sender != null ? this.sender.func_145748_c_().func_150254_d() : "";
        this.reciever.func_145747_a((ITextComponent)new StringTextComponent("\u00a7a" + _sender + " has send you a trade invite!"));
    }

    public void nullifyData(PlayerEntity player) {
        player.getPersistentData().func_74778_a("diablolootsender", "");
        player.getPersistentData().func_74757_a("diablolootaccepted", false);
        player.getPersistentData().func_74757_a("diablolootpending", false);
        player.getPersistentData().func_74757_a("diablolootisSender", false);
        player.getPersistentData().func_74757_a("diablolootisReciever", false);
        player.getPersistentData().func_74757_a("diablolootready", false);
        player.getPersistentData().func_74768_a("diabloloottickscount", 0);
        player.getPersistentData().func_218657_a("tradeinv", (INBT)new CompoundNBT());
    }

    public void writeDataSender() {
        String UUID2 = this.reciever.func_110124_au().toString();
        this.sender.getPersistentData().func_74778_a("diablolootreciever", UUID2);
        this.sender.getPersistentData().func_74757_a("diablolootaccepted", this.recieverAccepted);
        this.sender.getPersistentData().func_74757_a("diablolootpending", !this.recieverAccepted);
        this.sender.getPersistentData().func_74757_a("diablolootisSender", true);
        this.sender.getPersistentData().func_74757_a("diablolootready", false);
        this.sender.getPersistentData().func_74768_a("diabloloottickscount", 400);
        this.sender.getPersistentData().func_218657_a("tradeinv", (INBT)this.handler.serializeNBT());
    }

    public void writeDataReciever() {
        String UUID2 = this.sender.func_110124_au().toString();
        this.reciever.getPersistentData().func_74778_a("diablolootsender", UUID2);
        this.reciever.getPersistentData().func_74757_a("diablolootaccepted", this.recieverAccepted);
        this.reciever.getPersistentData().func_74757_a("diablolootpending", !this.recieverAccepted);
        this.reciever.getPersistentData().func_74757_a("diablolootisReciever", true);
        this.reciever.getPersistentData().func_74757_a("diablolootready", false);
        this.reciever.getPersistentData().func_74768_a("diabloloottickscount", 400);
        this.reciever.getPersistentData().func_218657_a("tradeinv", (INBT)this.handler.serializeNBT());
    }

    public void writeItemStackHandler() {
        this.sender.getPersistentData().func_218657_a("tradeinv", (INBT)this.handler.serializeNBT());
        this.reciever.getPersistentData().func_218657_a("tradeinv", (INBT)this.handler.serializeNBT());
    }

    public void buildItemHandler(CompoundNBT nbt) {
        this.handler.deserializeNBT(nbt);
    }

    public TradeItemStackHandler getItemHandler() {
        return this.handler;
    }

    public void refund() {
        ArrayList<ItemStack> senderList = new ArrayList<ItemStack>();
        for (int i = 0; i < 11; ++i) {
            ItemStack is = this.handler.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            senderList.add(is);
        }
        for (ItemStack is : senderList) {
            this.sender.field_71071_by.func_70441_a(is);
        }
        senderList.clear();
        ArrayList<ItemStack> recieverList = new ArrayList<ItemStack>();
        for (int i = 0; i < 11; ++i) {
            ItemStack is = this.handler.getStackInSlot(i + 12);
            if (is.func_190926_b()) continue;
            recieverList.add(is);
        }
        for (ItemStack is : recieverList) {
            this.reciever.field_71071_by.func_70441_a(is);
        }
        recieverList.clear();
    }

    public void exchange() {
        ArrayList<ItemStack> recieverList = new ArrayList<ItemStack>();
        for (int i = 0; i < 11; ++i) {
            ItemStack is = this.handler.getStackInSlot(i);
            if (is.func_190926_b()) continue;
            recieverList.add(is);
        }
        for (ItemStack is : recieverList) {
            this.reciever.field_71071_by.func_70441_a(is);
        }
        recieverList.clear();
        ArrayList<ItemStack> senderList = new ArrayList<ItemStack>();
        for (int i = 0; i < 11; ++i) {
            ItemStack is = this.handler.getStackInSlot(i + 12);
            if (is.func_190926_b()) continue;
            senderList.add(is);
        }
        for (ItemStack is : senderList) {
            this.reciever.field_71071_by.func_70441_a(is);
        }
        senderList.clear();
    }

    public void close() {
        if (!this.isComplete) {
            this.refund();
        } else {
            this.exchange();
        }
    }

    public void complete() {
        this.isComplete = true;
    }

    public static TradeManager build(PlayerEntity sender, PlayerEntity reciever) {
        TradeManager tm = new TradeManager(sender, reciever);
        CompoundNBT invData = (CompoundNBT)reciever.getPersistentData().func_74781_a("tradeinv");
        tm.buildItemHandler(invData);
        boolean recieverAcceptedData = reciever.getPersistentData().func_74767_n("diablolootaccepted");
        if (recieverAcceptedData) {
            tm.accept();
        }
        return tm;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TradeContainer(i, playerEntity.field_70170_p, this, playerInventory, playerEntity);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("trade");
    }

    public static class TradeManagerHelper {
        public static CompoundNBT getInvCompound(PlayerEntity player) {
            return (CompoundNBT)player.getPersistentData().func_74781_a("tradeinv");
        }

        public static boolean hasAccepted(PlayerEntity player) {
            return player.getPersistentData().func_74767_n("diablolootaccepted");
        }

        public static boolean isPending(PlayerEntity player) {
            return player.getPersistentData().func_74767_n("diablolootpending");
        }

        public static boolean isSender(PlayerEntity player) {
            return player.getPersistentData().func_74767_n("diablolootisSender");
        }

        public static boolean isReady(PlayerEntity player) {
            return player.getPersistentData().func_74767_n("diablolootready");
        }

        public static boolean isReciever(PlayerEntity player) {
            return player.getPersistentData().func_74767_n("diablolootisReciever");
        }

        public static void accept(PlayerEntity player) {
            player.getPersistentData().func_74757_a("diablolootaccepted", true);
        }

        public static void ready(PlayerEntity player) {
            player.getPersistentData().func_74757_a("diablolootready", true);
        }

        public static PlayerEntity getSender(PlayerEntity player) {
            String suuid = player.getPersistentData().func_74779_i("diablolootsender");
            UUID ruuid = UUID.fromString(suuid);
            return player.field_70170_p.func_217371_b(ruuid);
        }

        public static PlayerEntity getReciever(PlayerEntity player) {
            String suuid = player.getPersistentData().func_74779_i("diablolootreciever");
            UUID ruuid = UUID.fromString(suuid);
            return player.field_70170_p.func_217371_b(ruuid);
        }
    }
}

