/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments;

import com.favouritedragon.dragonenchantments.DragonEnchants;
import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.network.PacketSDoubleJump;
import com.favouritedragon.dragonenchantments.common.network.PacketSGigaSlash;
import com.favouritedragon.dragonenchantments.common.network.PacketSStormStride;
import com.favouritedragon.dragonenchantments.common.network.PacketSVoidWalk;
import com.favouritedragon.dragonenchantments.common.network.PacketSWindWalk;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class RegisterHandler {
    private static final int LIVING_UPDATE_INTERVAL = 3;
    private static final int PROJECTILE_UPDATE_INTERVAL = 10;

    private static void registerEntity(Class<? extends Entity> entityClass, String name, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ResourceLocation registryName = new ResourceLocation("dragon_enchants", name);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)id, (Object)DragonEnchants.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    private static void registerEntityAndEgg(Class<? extends Entity> entityClass, String name, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggColour, int spotColour) {
        ResourceLocation registryName = new ResourceLocation("dragon_enchants", name);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)id, (Object)DragonEnchants.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        EntityRegistry.registerEgg((ResourceLocation)registryName, (int)eggColour, (int)spotColour);
    }

    public static void registerItems() {
    }

    public static void registerEntities() {
        boolean id = false;
    }

    public static void registerLoot() {
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
    }

    public static void registerPackets() {
        DragonEnchants.NETWORK.registerMessage(PacketSDoubleJump.Handler.class, PacketSDoubleJump.class, 1, Side.SERVER);
        DragonEnchants.NETWORK.registerMessage(PacketSVoidWalk.Handler.class, PacketSVoidWalk.class, 2, Side.SERVER);
        DragonEnchants.NETWORK.registerMessage(PacketSStormStride.Handler.class, PacketSStormStride.class, 3, Side.SERVER);
        DragonEnchants.NETWORK.registerMessage(PacketSWindWalk.Handler.class, PacketSWindWalk.class, 4, Side.SERVER);
        DragonEnchants.NETWORK.registerMessage(PacketSGigaSlash.Handler.class, PacketSGigaSlash.class, 5, Side.SERVER);
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.berserk);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.cloudWalker);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.dolphin);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.doubleEdge);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.dragonSlayer);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.enderference);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.endWalker);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.gigaSlash);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.homing);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.lifeSteal);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.oblivion);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.solarPowered);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.soulDevour);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.stormProtection);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.stormStrider);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.thunderAspect);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.venomous);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.voidHunger);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.voidWalker);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.windWalker);
    }

    static void registerAll() {
        RegisterHandler.registerLoot();
        RegisterHandler.registerEntities();
        RegisterHandler.registerItems();
        RegisterHandler.registerPackets();
    }
}

