/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.armour.boots;

import com.favouritedragon.dragonenchantments.DragonEnchants;
import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.network.PacketSDoubleJump;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class CloudWalker
extends Enchantment {
    private static HashMap<String, Integer> timesJumped = new HashMap();

    public CloudWalker() {
        super(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        this.func_77322_b("dragon_enchants:cloud_walker");
        this.setRegistryName("cloud_walker");
    }

    @SubscribeEvent
    public static void clearDoubleJump(LivingFallEvent event) {
        int level;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && (level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.cloudWalker, (EntityLivingBase)entity)) > 0) {
            CloudWalker.setTimesJumped(entity.func_110124_au().toString(), 0);
            event.setCanceled(level >= 3);
            int i = 0;
            while ((float)i < event.getDistance()) {
                event.setDamageMultiplier((float)Math.pow(0.3 - (double)((float)level / 100.0f), i == 0 ? 1.0 : (double)i));
                ++i;
            }
        }
    }

    @SubscribeEvent
    public static void jumpAndFallEvent(LivingEvent.LivingUpdateEvent event) {
        int level;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && (level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.cloudWalker, (EntityLivingBase)entity)) > 0) {
            if (!entity.func_70644_a(MobEffects.field_76430_j)) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 20 + level * 5, level - 2, false, false));
            }
            if (entity.field_70181_x < 0.0 && !entity.field_70122_E) {
                entity.field_70181_x *= (double)(0.7f - (float)level / 100.0f);
            }
            if (!timesJumped.containsKey(entity.func_110124_au().toString())) {
                CloudWalker.setTimesJumped(entity.func_110124_au().toString(), 0);
            }
            if (entity.field_70122_E && CloudWalker.getTimesJumped(entity.func_110124_au().toString()) != 0) {
                CloudWalker.setTimesJumped(entity.func_110124_au().toString(), 0);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onKeyPressEvent(InputEvent.KeyInputEvent event) {
        int level;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && mc.field_71474_y.field_74314_A.func_151470_d() && (level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.cloudWalker, (EntityLivingBase)player)) > 0 && CloudWalker.getTimesJumped(player.func_110124_au().toString()) < level && !player.field_70122_E) {
            if (player.field_70170_p instanceof WorldClient) {
                WorldClient world = (WorldClient)player.field_70170_p;
                for (int angle = 0; angle < 360; angle += 3) {
                    double radians = Math.toRadians(angle);
                    double x = Math.cos(radians);
                    double z = Math.sin(radians);
                    world.func_175682_a(EnumParticleTypes.EXPLOSION_NORMAL, true, x + player.field_70165_t, player.func_174813_aQ().field_72338_b, z + player.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            player.func_130014_f_().func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSDoubleJump(player.func_189512_bd())));
            CloudWalker.setTimesJumped(player.func_110124_au().toString(), CloudWalker.getTimesJumped(player.func_110124_au().toString()) + 1);
        }
    }

    public static void doDoubleJump(EntityPlayer entity) {
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.cloudWalker, (EntityLivingBase)entity);
        ((EntityPlayerMP)entity).func_71121_q().func_152344_a(() -> {
            if (entity.field_70181_x > 0.0) {
                entity.func_70024_g(0.0, (double)(0.5f * (1.0f + (float)level / 10.0f)), 0.0);
                entity.field_70133_I = true;
            } else {
                entity.field_70181_x = 0.5f * (1.0f + (float)level / 10.0f);
                entity.field_70133_I = true;
            }
            ForgeHooks.onLivingJump((EntityLivingBase)entity);
        });
    }

    private static void setTimesJumped(String UUID2, int jumped) {
        if (timesJumped.containsKey(UUID2)) {
            timesJumped.replace(UUID2, jumped);
        } else {
            timesJumped.put(UUID2, jumped);
        }
    }

    private static int getTimesJumped(String UUID2) {
        return timesJumped.getOrDefault(UUID2, 0);
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 100 * enchantmentLevel;
    }
}

