/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.armour.boots;

import com.favouritedragon.dragonenchantments.DragonEnchants;
import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.network.PacketSStormStride;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class StormStrider
extends Enchantment {
    private static final UUID MOVEMENT_MODIFIER_ID = UUID.fromString("356f2c26-63e7-449e-b1d3-7de2f8967aca");

    public StormStrider() {
        super(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        this.func_77322_b("dragon_enchants:storm_strider");
        this.setRegistryName("storm_strider");
    }

    @SubscribeEvent
    public static void onThunder(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null) {
            EntityLivingBase entity = event.getEntityLiving();
            int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.stormStrider, (EntityLivingBase)entity);
            if (level > 0) {
                if (entity.field_70170_p.func_72911_I()) {
                    if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(MOVEMENT_MODIFIER_ID) == null) {
                        StormStrider.applyMovementModifier(entity, 1.5f + (float)level / 5.0f);
                    }
                } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(MOVEMENT_MODIFIER_ID) != null) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
                }
            } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(MOVEMENT_MODIFIER_ID) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLightningEvent(InputEvent.KeyInputEvent event) {
        RayTraceResult res;
        int level;
        World world;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && mc.field_71474_y.field_74311_E.func_151470_d() && (world = player.field_70170_p).func_72911_I() && (level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.stormStrider, (EntityLivingBase)player)) > 0 && (res = player.func_174822_a((double)(12 * level), 1.0f)) != null && res.field_72313_a == RayTraceResult.Type.BLOCK && res.field_72307_f != null) {
            double y = res.field_72307_f.field_72448_b;
            if (world.func_180495_p(new BlockPos(res.field_72307_f.field_72450_a, res.field_72307_f.field_72448_b, res.field_72307_f.field_72449_c)).func_177230_c() != Blocks.field_150350_a) {
                y += 1.0;
            }
            world.func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSStormStride(player.func_189512_bd(), res.field_72307_f.field_72450_a, y, res.field_72307_f.field_72449_c, level)));
        }
    }

    public static void StormStride(EntityPlayer entity, double x, double y, double z, int level) {
        int foodlevel = entity.func_71024_bL().func_75116_a();
        double distance = entity.func_70011_f(x, y, z);
        if (distance / (double)level <= (double)foodlevel || entity.func_184812_l_()) {
            ((EntityPlayerMP)entity).func_71121_q().func_152344_a(() -> {
                if (StormStrider.lightningTeleportTo((EntityLivingBase)entity, x, y, z)) {
                    AxisAlignedBB box = new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v);
                    List targets = entity.field_70170_p.func_72872_a(Entity.class, box = box.func_72314_b((double)(4 * level), 0.0, (double)(4 * level)));
                    if (!targets.isEmpty()) {
                        for (Entity hit : targets) {
                            if (hit == entity) continue;
                            Vec3d velocity = new Vec3d(hit.field_70165_t - entity.field_70165_t, hit.field_70163_u - entity.field_70163_u, hit.field_70161_v - entity.field_70161_v);
                            velocity.func_186678_a((double)level);
                            float amount = level * 3;
                            hit.func_70097_a(DamageSource.field_180137_b, amount);
                            hit.field_70159_w += velocity.field_72450_a * 0.3 * (double)level;
                            hit.field_70181_x += velocity.field_72448_b + 0.3 + (double)((float)level / 10.0f);
                            hit.field_70179_y += velocity.field_72449_c * 0.3 * (double)level;
                            DragonUtils.applyPlayerKnockback(hit);
                        }
                    }
                    if (entity.field_70170_p instanceof WorldServer) {
                        WorldServer world = (WorldServer)entity.field_70170_p;
                        for (int angle = 0; angle < 360; ++angle) {
                            double radians = Math.toRadians(angle);
                            double x1 = Math.cos(radians);
                            double z1 = Math.sin(radians);
                            world.func_184161_a((EntityPlayerMP)entity, EnumParticleTypes.CRIT_MAGIC, true, x + x1, y, z + z1, 1 + DragonUtils.getRandomNumberInRange(0, 1), 0.0, 0.0, 0.0, 2.0, new int[0]);
                        }
                    }
                    entity.func_71020_j((float)(distance / (double)level + 2.0));
                }
            });
        }
    }

    private static boolean lightningTeleportTo(EntityLivingBase entity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean teleport = entity.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (teleport) {
            DragonUtils.applyPlayerKnockback((Entity)entity);
            entity.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true));
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187752_dd, entity.func_184176_by(), 1.0f, 1.0f);
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187754_de, entity.func_184176_by(), 1.0f, 1.0f);
        }
        return teleport;
    }

    private static void applyMovementModifier(EntityLivingBase entity, float multiplier) {
        IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveSpeed.func_188479_b(MOVEMENT_MODIFIER_ID);
        moveSpeed.func_111121_a(new AttributeModifier(MOVEMENT_MODIFIER_ID, "Storm Strider Modifier", (double)multiplier, 1));
    }

    public int func_77325_b() {
        return 3;
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantments.voidWalker;
    }
}

