/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.armour.boots;

import akka.japi.Pair;
import com.favouritedragon.dragonenchantments.DragonEnchants;
import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.network.PacketSWindWalk;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class WindWalker
extends Enchantment {
    private static HashMap<String, Pair<Integer, Pair<Integer, Integer>>> dodgeMap = new HashMap();

    public WindWalker() {
        super(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        this.func_77322_b("dragon_enchants:wind_walker");
        this.setRegistryName("wind_walker");
    }

    private static int getCooldown(String UUID2) {
        if (!dodgeMap.containsKey(UUID2)) {
            return 0;
        }
        return (Integer)((Pair)dodgeMap.get(UUID2).second()).first();
    }

    private static int getLastPressedKey(String UUID2) {
        if (!dodgeMap.containsKey(UUID2)) {
            return 0;
        }
        return (Integer)dodgeMap.get(UUID2).first();
    }

    private static int getDoubleTapTicks(String UUID2) {
        if (!dodgeMap.containsKey(UUID2)) {
            return 0;
        }
        return (Integer)((Pair)dodgeMap.get(UUID2).second()).second();
    }

    private static void setCooldown(String UUID2, int ticks) {
        if (dodgeMap.containsKey(UUID2)) {
            dodgeMap.replace(UUID2, (Pair<Integer, Pair<Integer, Integer>>)new Pair((Object)WindWalker.getLastPressedKey(UUID2), (Object)new Pair((Object)ticks, (Object)WindWalker.getDoubleTapTicks(UUID2))));
        } else {
            dodgeMap.put(UUID2, (Pair<Integer, Pair<Integer, Integer>>)new Pair((Object)WindWalker.getLastPressedKey(UUID2), (Object)new Pair((Object)ticks, (Object)WindWalker.getDoubleTapTicks(UUID2))));
        }
    }

    private static void setLastPressedKey(String UUID2, int keycode) {
        if (dodgeMap.containsKey(UUID2)) {
            dodgeMap.replace(UUID2, (Pair<Integer, Pair<Integer, Integer>>)new Pair((Object)keycode, (Object)new Pair((Object)WindWalker.getCooldown(UUID2), (Object)WindWalker.getDoubleTapTicks(UUID2))));
        } else {
            dodgeMap.put(UUID2, (Pair<Integer, Pair<Integer, Integer>>)new Pair((Object)keycode, (Object)new Pair((Object)WindWalker.getCooldown(UUID2), (Object)WindWalker.getDoubleTapTicks(UUID2))));
        }
    }

    private static void setDoubleTapTicks(String UUID2, int ticks) {
        if (dodgeMap.containsKey(UUID2)) {
            dodgeMap.replace(UUID2, (Pair<Integer, Pair<Integer, Integer>>)new Pair((Object)WindWalker.getLastPressedKey(UUID2), (Object)new Pair((Object)WindWalker.getCooldown(UUID2), (Object)ticks)));
        } else {
            dodgeMap.put(UUID2, (Pair<Integer, Pair<Integer, Integer>>)new Pair((Object)WindWalker.getLastPressedKey(UUID2), (Object)new Pair((Object)WindWalker.getCooldown(UUID2), (Object)ticks)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onDoubleTapEvent(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        String UUID2 = mc.field_71439_g.func_110124_au().toString();
        KeyBinding left = mc.field_71474_y.field_74370_x;
        KeyBinding forward = mc.field_71474_y.field_74351_w;
        KeyBinding right = mc.field_71474_y.field_74366_z;
        KeyBinding back = mc.field_71474_y.field_74368_y;
        Vec3d origin = player.func_174791_d();
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.windWalker, (EntityLivingBase)player);
        if (level > 0) {
            int pressed = Keyboard.getEventKey();
            if (Keyboard.getEventKeyState() && !Keyboard.isRepeatEvent()) {
                if (left.func_151463_i() == pressed && WindWalker.getLastPressedKey(UUID2) == left.func_151463_i() && WindWalker.getDoubleTapTicks(UUID2) <= 8 && WindWalker.getCooldown(UUID2) <= 0) {
                    origin = origin.func_178787_e(DragonUtils.getVectorForRotation(player.field_70125_A, player.field_70177_z - 90.0f).func_186678_a((double)(level * 3)));
                    origin = new Vec3d(origin.field_72450_a, player.func_174813_aQ().field_72338_b, origin.field_72449_c);
                    player.field_70170_p.func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSWindWalk(player.func_110124_au().toString(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.windWalker, (EntityLivingBase)player))));
                }
                if (forward.func_151463_i() == pressed && WindWalker.getLastPressedKey(UUID2) == forward.func_151463_i() && WindWalker.getDoubleTapTicks(UUID2) <= 8 && WindWalker.getCooldown(UUID2) <= 0) {
                    origin = origin.func_178787_e(player.func_70040_Z().func_186678_a((double)(level * 3)));
                    origin = new Vec3d(origin.field_72450_a, player.func_174813_aQ().field_72338_b, origin.field_72449_c);
                    player.field_70170_p.func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSWindWalk(player.func_110124_au().toString(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.windWalker, (EntityLivingBase)player))));
                }
                if (right.func_151463_i() == pressed && WindWalker.getLastPressedKey(UUID2) == right.func_151463_i() && WindWalker.getDoubleTapTicks(UUID2) <= 8 && WindWalker.getCooldown(UUID2) <= 0) {
                    origin = origin.func_178787_e(DragonUtils.getVectorForRotation(player.field_70125_A, player.field_70177_z + 90.0f).func_186678_a((double)(level * 3)));
                    origin = new Vec3d(origin.field_72450_a, player.func_174813_aQ().field_72338_b, origin.field_72449_c);
                    player.field_70170_p.func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSWindWalk(player.func_110124_au().toString(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.windWalker, (EntityLivingBase)player))));
                }
                if (back.func_151463_i() == pressed && WindWalker.getLastPressedKey(UUID2) == back.func_151463_i() && WindWalker.getDoubleTapTicks(UUID2) <= 8 && WindWalker.getCooldown(UUID2) <= 0) {
                    origin = origin.func_178787_e(DragonUtils.getVectorForRotation(player.field_70125_A, player.field_70177_z + 180.0f).func_186678_a((double)(level * 3)));
                    origin = new Vec3d(origin.field_72450_a, player.func_174813_aQ().field_72338_b, origin.field_72449_c);
                    player.field_70170_p.func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSWindWalk(player.func_110124_au().toString(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, level)));
                    System.out.println("Teleportation position is wack.");
                }
                WindWalker.setLastPressedKey(UUID2, pressed);
                WindWalker.setDoubleTapTicks(UUID2, 0);
            }
        }
    }

    @SubscribeEvent
    public static void onTickEvent(LivingEvent.LivingUpdateEvent event) {
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.windWalker, (EntityLivingBase)event.getEntityLiving());
        if (level > 0) {
            EntityLivingBase entity = event.getEntityLiving();
            String UUID2 = entity.func_110124_au().toString();
            if (WindWalker.getCooldown(UUID2) > 0) {
                WindWalker.setCooldown(UUID2, WindWalker.getCooldown(UUID2) - 1);
            }
            WindWalker.setDoubleTapTicks(UUID2, WindWalker.getDoubleTapTicks(UUID2) + 1);
            entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 5, level - 1));
        }
    }

    public static void windWalk(EntityPlayer entity, double x, double y, double z, int level) {
        WindWalker.setDoubleTapTicks(entity.func_110124_au().toString(), 0);
        int foodlevel = entity.func_71024_bL().func_75116_a();
        double distance = entity.func_70011_f(x, y, z);
        if (distance <= (double)(level * 3) && (double)foodlevel >= distance / 2.0 && (!entity.func_70093_af() || entity.func_184812_l_())) {
            ((EntityPlayerMP)entity).func_71121_q().func_152344_a(() -> {
                if (DragonUtils.teleportTo((EntityLivingBase)entity, x, y, z, SoundEvents.field_187631_bo)) {
                    if (!entity.func_184812_l_()) {
                        entity.func_71024_bL().func_75114_a(entity.func_71024_bL().func_75116_a() - (int)(distance / 2.0));
                    }
                    WindWalker.setCooldown(entity.func_110124_au().toString(), 100 - level * 10);
                }
            });
        }
    }

    public int func_77325_b() {
        return 3;
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantments.stormStrider && ench != ModEnchantments.voidWalker && ench != ModEnchantments.endWalker;
    }
}

