/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.armour.leggings;

import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class Dolphin
extends Enchantment {
    private static final UUID MOVEMENT_MODIFIER_ID = UUID.fromString("bf6f2d30-9426-452a-8510-9537adb0237c");

    public Dolphin() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_LEGS, new EntityEquipmentSlot[]{EntityEquipmentSlot.LEGS});
        this.func_77322_b("dragon_enchants:dolphin");
        this.setRegistryName("dolphin");
    }

    @SubscribeEvent
    public static void onSwimEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity.func_70090_H()) {
                int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.dolphin, (EntityLivingBase)entity);
                if (level > 0) {
                    float multiplier = 2.0f + (float)level / 5.0f;
                    Dolphin.applyMovementModifier(entity, multiplier);
                }
            } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(MOVEMENT_MODIFIER_ID) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
            }
        }
    }

    private static void applyMovementModifier(EntityLivingBase entity, float multiplier) {
        IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveSpeed.func_188479_b(MOVEMENT_MODIFIER_ID);
        moveSpeed.func_111121_a(new AttributeModifier(MOVEMENT_MODIFIER_ID, "Dolphin Modifier", (double)multiplier, 1));
    }

    public int func_77325_b() {
        return 3;
    }
}

