/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.weapon;

import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class DragonSlayer
extends Enchantment {
    public DragonSlayer() {
        super(Enchantment.Rarity.RARE, Objects.requireNonNull(ModEnchantments.WEAPONS), new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.setRegistryName("dragon_slayer");
        this.func_77322_b("dragon_enchants:dragon_slayer");
    }

    @SubscribeEvent
    public static void onDragonHurt(LivingHurtEvent event) {
        int level;
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof EntityLivingBase && !attacker.field_70170_p.field_72995_K && (level = DragonUtils.getHeldLevelForEnchantment((EntityLivingBase)attacker, ModEnchantments.dragonSlayer, event)) > 0) {
            float amount = Math.max(event.getAmount(), event.getEntityLiving().func_110143_aJ());
            if (event.getEntityLiving() instanceof EntityDragon) {
                event.setAmount(event.getAmount() * (1.0f + 0.1f * (float)level));
            }
        }
    }

    public int func_77325_b() {
        return 5;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 20 + 5 * enchantmentLevel;
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77317_b(enchantmentLevel) + 200;
    }

    public boolean func_185261_e() {
        return true;
    }
}

