/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.weapon;

import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class Lifesteal
extends Enchantment {
    public Lifesteal() {
        super(Enchantment.Rarity.RARE, Objects.requireNonNull(ModEnchantments.WEAPONS), new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.setRegistryName("life_steal");
        this.func_77322_b("dragon_enchants:life_steal");
    }

    @SubscribeEvent
    public static void onLifeSteal(LivingAttackEvent event) {
        int level;
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof EntityLivingBase && !attacker.field_70170_p.field_72995_K && (level = DragonUtils.getHeldLevelForEnchantment((EntityLivingBase)attacker, ModEnchantments.lifeSteal, event)) > 0) {
            float amount = event.getAmount() > event.getEntityLiving().func_110143_aJ() ? event.getAmount() : event.getEntityLiving().func_110143_aJ();
            ((EntityLivingBase)attacker).func_70691_i(amount / 10.0f * (float)level);
        }
    }

    public boolean func_185261_e() {
        return true;
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10 + 40 * enchantmentLevel;
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77317_b(enchantmentLevel) + 50;
    }
}

