/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.weapon.sword;

import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class DoubleEdged
extends Enchantment {
    private static HashMap<String, Boolean> isCrit = new HashMap();

    public DoubleEdged() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b("dragon_enchants:double_edge");
        this.setRegistryName("double_edge");
    }

    @SubscribeEvent
    public static void onEnchantmentGet(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        int level;
        if (event.getEntityLiving() != null && (level = DragonUtils.getHeldLevelForEnchantment(entity = event.getEntityLiving(), ModEnchantments.doubleEdge)) > 0 && !isCrit.containsKey(entity.func_110124_au().toString())) {
            DoubleEdged.setIsCrit(entity.func_110124_au().toString(), false);
        }
    }

    @SubscribeEvent
    public static void onCritEvent(CriticalHitEvent event) {
        EntityLivingBase base;
        int level;
        if (event.getEntityLiving() != null && (level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.doubleEdge, (ItemStack)(base = event.getEntityLiving()).func_184614_ca())) > 0) {
            event.setDamageModifier(event.getDamageModifier() + (float)level / 5.0f);
            DoubleEdged.setIsCrit(base.func_110124_au().toString(), true);
        }
    }

    @SubscribeEvent
    public static void onHurtCritEvent(LivingHurtEvent event) {
        EntityLivingBase attacker;
        int level;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && (level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.doubleEdge, (ItemStack)(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca())) > 0 && DoubleEdged.isCrit(attacker.func_110124_au().toString())) {
            attacker.func_70097_a(DamageSource.func_92087_a((Entity)attacker), event.getAmount() / (float)(2 + level));
            attacker.func_70107_b(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v);
        }
    }

    private static void setIsCrit(String UUID2, boolean crit) {
        if (isCrit.containsKey(UUID2)) {
            isCrit.replace(UUID2, crit);
        } else {
            isCrit.put(UUID2, crit);
        }
    }

    private static boolean isCrit(String UUID2) {
        return isCrit.get(UUID2) == null ? false : isCrit.get(UUID2);
    }

    public int func_77325_b() {
        return 5;
    }
}

