/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.weapon.sword;

import com.favouritedragon.dragonenchantments.DragonEnchants;
import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.network.PacketSGigaSlash;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class Gigaslash
extends Enchantment {
    public static final UUID MODIFIER_UUID = UUID.fromString("f64334b8-2f79-47e1-bbc8-e9c098077dff");

    public Gigaslash() {
        super(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b("dragon_enchants:gigaslash");
        this.setRegistryName("gigaslash");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onUpdateTick(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        int level;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && player.func_184614_ca().func_77973_b() instanceof ItemSword && (level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.gigaSlash, (ItemStack)(stack = player.func_184614_ca()))) > 0) {
            int maxChargeTime = 40 + 5 * level;
            float damageMod = (float)Gigaslash.readChargeTime(stack) / (float)maxChargeTime * (float)level;
            if (mc.field_71474_y.field_74313_G.func_151470_d()) {
                player.func_130014_f_().func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSGigaSlash(player.func_110124_au().toString(), damageMod, level, true)));
                player.field_70159_w *= 0.675;
                player.field_70179_y *= 0.675;
            } else if (Gigaslash.readChargeTime(stack) > 20) {
                player.func_130014_f_().func_184135_a(DragonEnchants.NETWORK.getPacketFrom((IMessage)new PacketSGigaSlash(player.func_110124_au().toString(), damageMod, level, false)));
                player.func_184185_a(SoundEvents.field_187752_dd, 1.5f + (float)level / 10.0f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() / 5.0f);
                player.func_184185_a(SoundEvents.field_187754_de, 2.0f + (float)level / 10.0f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() / 5.0f);
                player.func_184609_a(EnumHand.MAIN_HAND);
                Gigaslash.writeNbt(player.func_184614_ca(), ((ItemSword)player.func_184614_ca().func_77973_b()).func_150931_i(), 0);
            }
        }
    }

    public static void setNbt(ItemStack stack, float damageMod) {
        Gigaslash.writeNbt(stack, Gigaslash.readInitialDamage(stack) + (double)damageMod, Gigaslash.readChargeTime(stack) + 1);
    }

    public static void attackEnemies(EntityPlayer player, int level, float damageMod) {
        if (level > 0) {
            ((EntityPlayerMP)player).func_71121_q().func_152344_a(() -> {
                int maxChargeTime = (int)((float)(Gigaslash.readChargeTime(player.func_184614_ca()) * level) / damageMod);
                float radius = (float)(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() / 2.0 + (double)Math.min(damageMod, 3.0f) + 1.0);
                AxisAlignedBB box = player.func_174813_aQ().func_186662_g((double)radius);
                List targets = player.field_70170_p.func_72872_a(EntityLivingBase.class, box);
                World world = player.field_70170_p;
                if (!targets.isEmpty()) {
                    for (EntityLivingBase living : targets) {
                        if (living == player || player.func_184187_bx() == living || (living.func_96124_cp() == null || living.func_96124_cp() == player.func_96124_cp()) && living.func_96124_cp() != null) continue;
                        Vec3d vel = living.func_174791_d().func_178788_d(player.func_174791_d()).func_186678_a(0.25);
                        vel = vel.func_186678_a(1.0 / DragonUtils.getMagnitude(vel));
                        vel = vel.func_186678_a((double)(1.0f + 0.5f * (float)level));
                        living.func_70097_a(DamageSource.field_180137_b, (float)Gigaslash.getAttackDamage(player.func_184614_ca()));
                        living.func_70024_g(vel.field_72450_a, vel.field_72448_b + 0.15, vel.field_72449_c);
                        living.func_70015_d(level + 1);
                    }
                }
                world.func_72942_c((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, true));
                if (world instanceof WorldServer) {
                    double d0 = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
                    double d1 = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
                    for (int angle = 0; angle < 360; angle += 10) {
                        d0 = -MathHelper.func_76126_a((float)((player.field_70177_z + (float)angle) * ((float)Math.PI / 180))) * radius / 2.0f;
                        d1 = MathHelper.func_76134_b((float)((player.field_70177_z + (float)angle) * ((float)Math.PI / 180))) * radius / 2.0f;
                        ((WorldServer)world).func_175739_a(EnumParticleTypes.CRIT_MAGIC, player.field_70165_t + d0, player.field_70163_u + (double)player.field_70131_O * 0.5, player.field_70161_v + d1, level * 2 + 5, d0, 0.0, d1, 0.2 + 0.1 * (double)level * (double)Gigaslash.readChargeTime(player.func_184614_ca()) / 50.0, new int[0]);
                        ((WorldServer)world).func_175739_a(EnumParticleTypes.ENCHANTMENT_TABLE, player.field_70165_t + d0, player.field_70163_u + (double)player.field_70131_O * 0.5, player.field_70161_v + d1, level * 2 + 10, d0, 0.0, d1, 0.2 + 0.1 * (double)level * (double)Gigaslash.readChargeTime(player.func_184614_ca()) / 50.0, new int[0]);
                    }
                }
                player.func_71020_j(10.0f + 2.5f * (float)level);
            });
        }
        Gigaslash.writeNbt(player.func_184614_ca(), ((ItemSword)player.func_184614_ca().func_77973_b()).func_150931_i(), 0);
    }

    private static void writeNbt(ItemStack stack, double initialDamage, int chargeTime) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        nbt.func_74768_a("GigaSlashChargeTime", chargeTime);
        if (!nbt.func_74764_b("InitialDamage")) {
            nbt.func_74780_a("InitialDamage", initialDamage);
        }
    }

    private static void writeModifier(ItemStack stack, double value) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        NBTTagCompound nestedNbt = new NBTTagCompound();
        AttributeModifier modifier = new AttributeModifier(MODIFIER_UUID, "Gigaslash Damage Boost", value, 0);
        nestedNbt.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        nestedNbt.func_74778_a("Name", modifier.func_111166_b());
        nestedNbt.func_74780_a("Amount", modifier.func_111164_d());
        nestedNbt.func_74768_a("Operation", modifier.func_111169_c());
        nestedNbt.func_74772_a("UUIDMost", modifier.func_111167_a().getMostSignificantBits());
        nestedNbt.func_74772_a("UUIDLeast", modifier.func_111167_a().getLeastSignificantBits());
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)nestedNbt);
        nbt.func_74782_a("AttributeModifiers", (NBTBase)list);
    }

    private static double getAttackDamage(ItemStack stack) {
        double value = 0.0;
        for (AttributeModifier modifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
            value = modifier.func_111164_d();
        }
        return value;
    }

    private static int readChargeTime(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        if (nbt.func_74764_b("GigaSlashChargeTime")) {
            return nbt.func_74762_e("GigaSlashChargeTime");
        }
        return 0;
    }

    private static double readInitialDamage(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (nbt.func_74764_b("IntialDamage")) {
            return nbt.func_74769_h("IntialDamage");
        }
        return 0.0;
    }

    public int func_77325_b() {
        return 5;
    }

    public int func_77321_a(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77317_b(enchantmentLevel) + 400;
    }

    public boolean func_185261_e() {
        return true;
    }
}

