/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.weapon.sword;

import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class SoulDevour
extends Enchantment {
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public SoulDevour() {
        super(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("soul_devour");
        this.func_77322_b("dragon_enchants:soul_devour");
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        EntityLivingBase trueEntity;
        Entity source = event.getSource().func_76346_g();
        Entity target = event.getEntity();
        if (source == null || target == null) {
            return;
        }
        if (source instanceof EntityLivingBase && target instanceof EntityLivingBase && DragonUtils.getHeldLevelForEnchantment(trueEntity = (EntityLivingBase)source, ModEnchantments.soulDevour) > 0) {
            ItemStack stack = (ItemStack)DragonUtils.getHeldLevelForEnchantmentAndHeldItem(trueEntity, ModEnchantments.soulDevour).second();
            int level = DragonUtils.getHeldLevelForEnchantment(trueEntity, ModEnchantments.soulDevour);
            short numberKilled = SoulDevour.readSoulsKilled(stack);
            if (((EntityLivingBase)target).func_110138_aP() >= 20.0f) {
                numberKilled = (short)(numberKilled + (int)(((EntityLivingBase)target).func_110138_aP() / 20.0f));
            }
            SoulDevour.writeNbt(stack, numberKilled, SoulDevour.readInitialDamage(stack, trueEntity), SoulDevour.readTotalHealthConsumed(stack));
            trueEntity.func_70691_i(((EntityLivingBase)target).func_110138_aP() / 4.0f);
            if (numberKilled < level * 25 + 1) {
                float mod = (float)(100 + numberKilled) / 100.0f;
                SoulDevour.writeModifier(stack, trueEntity, mod);
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityLivingBase trueEntity;
        Entity source = event.getSource().func_76346_g();
        Entity target = event.getEntity();
        if (source == null || target == null) {
            return;
        }
        if (source instanceof EntityLivingBase && target instanceof EntityLivingBase && DragonUtils.getHeldLevelForEnchantment(trueEntity = (EntityLivingBase)source, ModEnchantments.soulDevour) > 0) {
            ItemStack stack = (ItemStack)DragonUtils.getHeldLevelForEnchantmentAndHeldItem(trueEntity, ModEnchantments.soulDevour).second();
            double totalHealthConsumed = SoulDevour.readTotalHealthConsumed(stack);
            double healthConsumed = Math.min(event.getAmount(), ((EntityLivingBase)target).func_110143_aJ());
            totalHealthConsumed += healthConsumed;
            if (SoulDevour.readSoulsKilled(stack) > 0) {
                SoulDevour.writeNbt(stack, SoulDevour.readSoulsKilled(stack), totalHealthConsumed);
            } else {
                SoulDevour.writeNbt(stack, SoulDevour.readSoulsKilled(stack), SoulDevour.getAttackDamage(stack, trueEntity), totalHealthConsumed);
            }
            boolean updateInitialDamage = false;
            for (Enchantment enchantment : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
                if (!(enchantment instanceof EnchantmentDamage)) continue;
                updateInitialDamage = true;
            }
            if (updateInitialDamage) {
                SoulDevour.writeNbt(stack, SoulDevour.readSoulsKilled(stack), SoulDevour.readInitialDamage(stack, trueEntity) + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED), totalHealthConsumed);
            }
        }
    }

    private static void writeNbt(ItemStack stack, short numberKilled, double healthConsumed) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        nbt.func_74780_a("ConsumedHealth", healthConsumed);
        nbt.func_74777_a("SoulDevourKills", numberKilled);
    }

    private static void writeNbt(ItemStack stack, short numberKilled, double initialDamage, double healthConsumed) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        nbt.func_74780_a("ConsumedHealth", healthConsumed);
        nbt.func_74777_a("SoulDevourKills", numberKilled);
        if (!nbt.func_74764_b("InitialDamage")) {
            nbt.func_74780_a("InitialDamage", initialDamage);
        }
    }

    private static void writeModifier(ItemStack stack, EntityLivingBase entity, double value) {
        AttributeModifier modifier = new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon Modifier", SoulDevour.readInitialDamage(stack, entity) * value, 0);
        Multimap attributeMods = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        stack.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)new NBTTagList());
        for (Map.Entry modifierEntry : attributeMods.entries()) {
            if (((String)modifierEntry.getKey()).equals(SharedMonsterAttributes.field_111264_e.func_111108_a())) continue;
            AttributeModifier mod = new AttributeModifier(((AttributeModifier)modifierEntry.getValue()).func_111167_a(), ((AttributeModifier)modifierEntry.getValue()).func_111166_b(), ((AttributeModifier)modifierEntry.getValue()).func_111164_d(), ((AttributeModifier)modifierEntry.getValue()).func_111169_c());
            stack.func_185129_a((String)modifierEntry.getKey(), mod, EntityEquipmentSlot.MAINHAND);
        }
        stack.func_185129_a(SharedMonsterAttributes.field_111264_e.func_111108_a(), modifier, EntityEquipmentSlot.MAINHAND);
    }

    private static double getAttackDamage(ItemStack stack, EntityLivingBase entity) {
        double value = 0.0;
        for (AttributeModifier modifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
            value += entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            value += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            value += modifier.func_111164_d();
        }
        return value;
    }

    private static short readSoulsKilled(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        if (nbt.func_74764_b("SoulDevourKills")) {
            return nbt.func_74765_d("SoulDevourKills") > 75 ? (short)75 : nbt.func_74765_d("SoulDevourKills");
        }
        return 0;
    }

    private static double readTotalHealthConsumed(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        if (nbt.func_74764_b("ConsumedHealth")) {
            return nbt.func_74769_h("ConsumedHealth");
        }
        return 0.0;
    }

    private static double readInitialDamage(ItemStack stack, EntityLivingBase entity) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        assert (nbt != null);
        if (nbt.func_74764_b("InitialDamage")) {
            return nbt.func_74769_h("InitialDamage");
        }
        return 0.0;
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77317_b(enchantmentLevel) + 100;
    }
}

