/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.enchantments.weapon.sword;

import com.favouritedragon.dragonenchantments.common.enchantments.ModEnchantments;
import com.favouritedragon.dragonenchantments.common.util.DragonUtils;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class ThunderAspect
extends Enchantment {
    private static final HashMap<String, Boolean> isSweepAttack = new HashMap();

    public ThunderAspect() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("thunder_aspect");
        this.func_77322_b("dragon_enchants:thunder_aspect");
    }

    @SubscribeEvent
    public static void onEnchantmentGet(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        int level;
        if (event.getEntityLiving() != null && (level = DragonUtils.getHeldLevelForEnchantment(entity = event.getEntityLiving(), ModEnchantments.thunderAspect)) > 0 && !isSweepAttack.containsKey(entity.func_110124_au().toString())) {
            ThunderAspect.setIsSweepAttack(entity.func_110124_au().toString(), false);
        }
    }

    @SubscribeEvent
    public static void onPlayerSweep(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null) {
            ThunderAspect.setIsSweepAttack(player.func_110124_au().toString(), (double)player.func_184825_o(0.0f) >= 1.0);
        }
    }

    @SubscribeEvent
    public static void onSwingEvent(LivingAttackEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        EntityLivingBase hurt = event.getEntityLiving();
        if (attacker instanceof EntityLivingBase) {
            ItemStack stack = ((EntityLivingBase)attacker).func_184614_ca();
            if (hurt != null && hurt != attacker && stack.func_77948_v() && !(event.getSource() instanceof EntityDamageSourceIndirect)) {
                if (ThunderAspect.getSweepAttack(attacker.func_110124_au().toString())) {
                    int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.thunderAspect, (ItemStack)stack);
                    if (level > 0) {
                        if (!attacker.field_70170_p.field_72995_K) {
                            float amount = level;
                            if (attacker.field_70170_p.func_72896_J()) {
                                amount *= 1.25f;
                            } else if (attacker.field_70170_p.func_72911_I()) {
                                amount *= 1.5f;
                            }
                            hurt.func_70097_a(DamageSource.field_180137_b, event.getAmount() / 5.0f * amount);
                            Vec3d lookVec = attacker.func_70040_Z();
                            hurt.func_70024_g(lookVec.field_72450_a * (1.0 + 0.2 * (double)amount), lookVec.field_72448_b > 0.0 ? lookVec.field_72448_b * (1.0 + 0.2 * (double)amount) : 0.2 * (double)amount, lookVec.field_72449_c * (1.0 + 0.2 * (double)amount));
                        }
                        if (attacker.field_70170_p.field_72995_K) {
                            attacker.field_70170_p.func_184134_a(hurt.field_70165_t, hurt.field_70163_u, hurt.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.PLAYERS, 1.0f + attacker.field_70170_p.field_73012_v.nextFloat(), 1.0f + attacker.field_70170_p.field_73012_v.nextFloat(), true);
                        }
                    }
                    ThunderAspect.setIsSweepAttack(attacker.func_110124_au().toString(), false);
                } else {
                    int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.thunderAspect, (ItemStack)stack);
                    if (level > 0 && !attacker.field_70170_p.field_72995_K) {
                        float amount = level;
                        if (attacker.field_70170_p.func_72896_J()) {
                            amount *= 1.25f;
                        } else if (attacker.field_70170_p.func_72911_I()) {
                            amount *= 1.5f;
                        }
                        hurt.func_70097_a(DamageSource.field_180137_b, event.getAmount() / 10.0f * amount);
                        Vec3d lookVec = attacker.func_70040_Z();
                        hurt.func_70024_g(lookVec.field_72450_a * (1.0 + 0.1 * (double)amount), lookVec.field_72448_b > 0.0 ? lookVec.field_72448_b * (1.0 + 0.1 * (double)amount) : 0.1 * (double)amount, lookVec.field_72449_c * (1.0 + 0.1 * (double)amount));
                    }
                }
            }
        }
    }

    private static void setIsSweepAttack(String UUID2, boolean sweepAttack) {
        if (isSweepAttack.containsKey(UUID2)) {
            isSweepAttack.replace(UUID2, sweepAttack);
        } else {
            isSweepAttack.put(UUID2, sweepAttack);
        }
    }

    private static boolean getSweepAttack(String UUID2) {
        return isSweepAttack.get(UUID2) != null && isSweepAttack.get(UUID2) != false;
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1 + enchantmentLevel * 80;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 200;
    }

    public boolean func_185261_e() {
        return true;
    }
}

