/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.network;

import com.favouritedragon.dragonenchantments.common.enchantments.weapon.sword.Gigaslash;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSword;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSGigaSlash
implements IMessage {
    public int uuid_length;
    public String uuid;
    public double damageMod;
    private int level;
    private boolean writeNbt;

    public PacketSGigaSlash() {
    }

    public PacketSGigaSlash(String entityUuid, double damageMod, int level, boolean writeNbt) {
        this.uuid_length = entityUuid.length();
        this.uuid = entityUuid;
        this.damageMod = damageMod;
        this.level = level;
        this.writeNbt = writeNbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid_length = buf.readInt();
        this.uuid = buf.readCharSequence(this.uuid_length, Charsets.UTF_8).toString();
        this.damageMod = buf.readDouble();
        this.level = buf.readInt();
        this.writeNbt = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.uuid_length);
        buf.writeCharSequence((CharSequence)this.uuid, Charsets.UTF_8);
        buf.writeDouble(this.damageMod);
        buf.writeInt(this.level);
        buf.writeBoolean(this.writeNbt);
    }

    public static class Handler
    implements IMessageHandler<PacketSGigaSlash, IMessage> {
        public IMessage onMessage(PacketSGigaSlash message, MessageContext ctx) {
            EntityPlayer player = (EntityPlayer)FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(UUID.fromString(message.uuid));
            if (player != null && player.func_184614_ca().func_77973_b() instanceof ItemSword) {
                if (message.writeNbt) {
                    Gigaslash.setNbt(player.func_184614_ca(), (float)message.damageMod);
                } else {
                    Gigaslash.attackEnemies(player, message.level, (float)message.damageMod);
                }
            }
            return null;
        }
    }
}

