/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.network;

import com.favouritedragon.dragonenchantments.common.enchantments.armour.boots.WindWalker;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSWindWalk
implements IMessage {
    public int uuid_length;
    public String uuid;
    public double x;
    public double y;
    public double z;
    int level;

    public PacketSWindWalk() {
    }

    public PacketSWindWalk(String entityuuid, double x, double y, double z, int level) {
        this.uuid_length = entityuuid.length();
        this.uuid = entityuuid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.level = level;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid_length = buf.readInt();
        this.uuid = buf.readCharSequence(this.uuid_length, Charsets.UTF_8).toString();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.level = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.uuid_length);
        buf.writeCharSequence((CharSequence)this.uuid, Charsets.UTF_8);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.level);
    }

    public static class Handler
    implements IMessageHandler<PacketSWindWalk, IMessage> {
        public IMessage onMessage(PacketSWindWalk message, MessageContext ctx) {
            EntityPlayer player = (EntityPlayer)FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(UUID.fromString(message.uuid));
            assert (player != null);
            WindWalker.windWalk(player, message.x, message.y, message.z, message.level);
            return null;
        }
    }
}

