/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.dragonenchantments.common.util;

import akka.japi.Pair;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber(modid="dragon_enchants")
public class DragonUtils {
    private static final DataParameter<Boolean> POWERED = (DataParameter)ReflectionHelper.getPrivateValue(EntityCreeper.class, null, (String)"POWERED", (String)"field_184714_b");

    public static void chargeCreeper(EntityCreeper creeper) {
        creeper.func_184212_Q().func_187227_b(POWERED, (Object)true);
    }

    @SubscribeEvent
    public static void onLightningHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityCreeper && event.getSource() == DamageSource.field_180137_b) {
            DragonUtils.chargeCreeper((EntityCreeper)event.getEntityLiving());
        }
    }

    public static int getHeldLevelForEnchantment(EntityLivingBase entity, Enchantment enchantment) {
        ItemStack stack = null;
        ItemStack mainStack = entity.func_184614_ca();
        ItemStack offStack = entity.func_184592_cb();
        if (mainStack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)mainStack) > 0) {
            stack = mainStack;
        } else if (offStack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)offStack) > 0) {
            stack = offStack;
        }
        return stack != null ? EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) : 0;
    }

    public static Pair<Integer, ItemStack> getHeldLevelForEnchantmentAndHeldItem(EntityLivingBase entity, Enchantment enchantment) {
        ItemStack stack = null;
        ItemStack mainStack = entity.func_184614_ca();
        ItemStack offStack = entity.func_184592_cb();
        if (mainStack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)mainStack) > 0) {
            stack = mainStack;
        } else if (offStack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)offStack) > 0) {
            stack = offStack;
        }
        return new Pair((Object)(stack != null ? EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) : 0), (Object)stack);
    }

    public static int getHeldLevelForEnchantment(EntityLivingBase entity, Enchantment enchantment, LivingHurtEvent event) {
        boolean offLevel;
        ItemStack stack = null;
        ItemStack mainStack = entity.func_184614_ca();
        ItemStack offStack = entity.func_184592_cb();
        boolean mainLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)mainStack) > 0;
        boolean bl = offLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)offStack) > 0;
        if (event.getSource().func_76364_f() instanceof EntityArrow) {
            if (mainStack.func_77948_v() && mainStack.func_77973_b() == Items.field_151031_f && mainLevel) {
                stack = mainStack;
            } else if (offStack.func_77948_v() && offStack.func_77973_b() == Items.field_151031_f && offLevel) {
                stack = offStack;
            }
        } else if (mainStack.func_77948_v() && mainLevel) {
            stack = mainStack;
        } else if (offStack.func_77948_v() && offLevel) {
            stack = offStack;
        }
        return stack != null ? EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) : 0;
    }

    public static int getHeldLevelForEnchantment(EntityLivingBase entity, Enchantment enchantment, LivingAttackEvent event) {
        boolean offLevel;
        ItemStack stack = null;
        ItemStack mainStack = entity.func_184614_ca();
        ItemStack offStack = entity.func_184592_cb();
        boolean mainLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)mainStack) > 0;
        boolean bl = offLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)offStack) > 0;
        if (event.getSource().func_76364_f() instanceof EntityArrow) {
            if (mainStack.func_77948_v() && mainStack.func_77973_b() == Items.field_151031_f && mainLevel) {
                stack = mainStack;
            } else if (offStack.func_77948_v() && offStack.func_77973_b() == Items.field_151031_f && offLevel) {
                stack = offStack;
            }
        } else if (mainStack.func_77948_v() && mainLevel) {
            stack = mainStack;
        } else if (offStack.func_77948_v() && offLevel) {
            stack = offStack;
        }
        return stack != null ? EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) : 0;
    }

    public static boolean teleportRandomly(EntityLivingBase entity, double radiusMult) {
        double d0 = entity.field_70165_t + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * radiusMult;
        double d1 = entity.field_70163_u + ((double)entity.field_70170_p.field_73012_v.nextInt((int)radiusMult) - radiusMult / 2.0);
        double d2 = entity.field_70161_v + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * radiusMult;
        return DragonUtils.teleportTo(entity, d0, d1, d2, SoundEvents.field_187534_aX);
    }

    public static boolean teleportTo(EntityLivingBase entity, double x, double y, double z, SoundEvent sound) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean teleport = DragonUtils.attemptTeleport(entity, event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (teleport) {
            DragonUtils.applyPlayerKnockback((Entity)entity);
            entity.field_70170_p.func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, sound, entity.func_184176_by(), 1.0f, 1.0f);
            entity.func_184185_a(sound, 1.0f, 1.0f);
        }
        return teleport;
    }

    public static boolean attemptTeleport(EntityLivingBase entity, double x, double y, double z) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        World world = entity.field_70170_p;
        BlockPos blockpos = new BlockPos((Entity)entity);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    public static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static void applyPlayerKnockback(Entity target) {
        target.field_70133_I = true;
        if (target instanceof EntityPlayerMP) {
            ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
            ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport(target));
        }
    }

    public static boolean isTimeBetween(World world, long min, long max) {
        long time = world.func_72820_D();
        return min <= time && time <= max;
    }

    public static double getMagnitude(Vec3d vector) {
        return Math.sqrt(vector.field_72450_a * vector.field_72450_a + vector.field_72448_b * vector.field_72448_b + vector.field_72449_c * vector.field_72449_c);
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }
}

