/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.armor;

import com.infamous.dungeons_gear.armor.models.CuriousArmorModel;
import com.infamous.dungeons_gear.armor.models.GuardsArmorModel;
import com.infamous.dungeons_gear.interfaces.IArmor;
import com.infamous.dungeons_gear.items.ArmorList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuardsArmorItem
extends ArmorItem
implements IArmor {
    private final boolean unique;

    public GuardsArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType slotType, Item.Properties properties, boolean unique) {
        super(armorMaterial, slotType, properties);
        this.unique = unique;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this.unique) {
            return "dungeons_gear:textures/models/armor/curious_armor.png";
        }
        return "dungeons_gear:textures/models/armor/guards_armor.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        if (stack.func_77973_b() == ArmorList.GUARDS_ARMOR || stack.func_77973_b() == ArmorList.GUARDS_ARMOR_HELMET) {
            return (A)((Object)new GuardsArmorModel(1.0f, this.field_77881_a, entityLiving));
        }
        if (stack.func_77973_b() == ArmorList.CURIOUS_ARMOR || stack.func_77973_b() == ArmorList.CURIOUS_ARMOR_HELMET) {
            return (A)((Object)new CuriousArmorModel(1.0f, this.field_77881_a, entityLiving));
        }
        return null;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.unique) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "No one knows where this strange armor came from but it seems familiar to you."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Cheap armor made in bulk, the Guard's Armor is a common sight in the villages of the Overworld."));
        }
    }

    @Override
    public double getChanceToTeleportAwayWhenHit() {
        if (this.unique) {
            return 2.5;
        }
        return 0.0;
    }

    @Override
    public double getArtifactCooldown() {
        return 12.5;
    }

    @Override
    public int getArrowsPerBundle() {
        return 4;
    }
}

