/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.armor;

import com.infamous.dungeons_gear.armor.models.SoulRobeModel;
import com.infamous.dungeons_gear.interfaces.IArmor;
import com.infamous.dungeons_gear.items.ArmorList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulRobeItem
extends ArmorItem
implements IArmor {
    private final boolean unique;

    public SoulRobeItem(IArmorMaterial armorMaterial, EquipmentSlotType slotType, Item.Properties properties, boolean unique) {
        super(armorMaterial, slotType, properties);
        this.unique = unique;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this.unique) {
            return "dungeons_gear:textures/models/armor/souldancer_robe.png";
        }
        return "dungeons_gear:textures/models/armor/soul_robe.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        if (stack.func_77973_b() == ArmorList.SOUL_ROBE || stack.func_77973_b() == ArmorList.SOUL_ROBE_HOOD) {
            return (A)((Object)new SoulRobeModel(1.0f, this.field_77881_a, entityLiving));
        }
        if (stack.func_77973_b() == ArmorList.SOULDANCER_ROBE || stack.func_77973_b() == ArmorList.SOULDANCER_ROBE_HOOD) {
            return (A)((Object)new SoulRobeModel(1.0f, this.field_77881_a, entityLiving));
        }
        return null;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.unique) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "The Souldancer Robe comes alive in the light, as if the souls within are dancing for all eternity."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "In a particular light, the souls woven into the cloth of the Soul Robe shimmer with power."));
        }
    }

    @Override
    public double getChanceToNegateHits() {
        if (this.unique) {
            return 15.0;
        }
        return 0.0;
    }

    @Override
    public double getSoulsGathered() {
        return 50.0;
    }

    @Override
    public double getMagicDamage() {
        return 25.0;
    }
}

