/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_gear.armor.models.SpelunkerArmorModel;
import com.infamous.dungeons_gear.interfaces.IArmor;
import com.infamous.dungeons_gear.items.ArmorList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpelunkerArmorItem
extends ArmorItem
implements IArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final boolean unique;
    private final int damageReduceAmount;
    private final float toughness;
    private final Multimap<String, AttributeModifier> attributeModifiers;

    public SpelunkerArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType slotType, Item.Properties properties, boolean unique) {
        super(armorMaterial, slotType, properties);
        this.unique = unique;
        this.damageReduceAmount = armorMaterial.func_200902_b(this.field_77881_a);
        this.toughness = armorMaterial.func_200901_e();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[this.field_77881_a.func_188454_b()];
        builder.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.damageReduceAmount, AttributeModifier.Operation.ADDITION));
        builder.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        builder.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor attack damage boost", 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.attributeModifiers = builder.build();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this.unique) {
            return "dungeons_gear:textures/models/armor/cave_crawler.png";
        }
        return "dungeons_gear:textures/models/armor/spelunker_armor.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        if (stack.func_77973_b() == ArmorList.SPELUNKER_ARMOR || stack.func_77973_b() == ArmorList.SPELUNKER_ARMOR_HELMET) {
            return (A)((Object)new SpelunkerArmorModel(1.0f, this.field_77881_a, entityLiving, false));
        }
        if (stack.func_77973_b() == ArmorList.CAVE_CRAWLER || stack.func_77973_b() == ArmorList.CAVE_CRAWLER_HELMET) {
            return (A)((Object)new SpelunkerArmorModel(1.0f, this.field_77881_a, entityLiving, true));
        }
        return null;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == this.field_77881_a ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.unique) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "The Cave Crawler armor has been passed down through generations of brave spelunkers and miners."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "The Spelunker Armor is worn by those who brave the darkest depths of the Overworld."));
        }
        list.add(new TranslationTextComponent("attribute.name.givesYouAPetBat", new Object[0]).func_211708_a(TextFormatting.GREEN));
    }

    @Override
    public double getMagicDamage() {
        if (this.unique) {
            return 25.0;
        }
        return 0.0;
    }

    @Override
    public boolean doGivesYouAPetBat() {
        return true;
    }

    @Override
    public double getRangedDamage() {
        return 10.0;
    }
}

