/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.artifacts;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.armor.SoulRobeItem;
import com.infamous.dungeons_gear.capabilities.combo.ComboProvider;
import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.capabilities.summoning.SummonableProvider;
import com.infamous.dungeons_gear.capabilities.summoning.SummonerProvider;
import com.infamous.dungeons_gear.damagesources.SummonedFallingBlockDamageSource;
import com.infamous.dungeons_gear.effects.CustomEffects;
import com.infamous.dungeons_gear.enchantments.lists.ArmorEnchantmentList;
import com.infamous.dungeons_gear.goals.BatFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BatMeleeAttackGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.GolemOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.GolemOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.goals.IronGolemFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.LlamaFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.LlamaOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.LlamaOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.interfaces.IArmor;
import com.infamous.dungeons_gear.items.ArmorList;
import com.infamous.dungeons_gear.items.ArtifactList;
import com.infamous.dungeons_gear.utilties.AbilityUtils;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class ArtifactEvents {
    @SubscribeEvent
    public static void reAddSummonableGoals(EntityJoinWorldEvent event) {
        BatEntity batEntity;
        IronGolemEntity ironGolemEntity;
        WolfEntity wolfEntity;
        LlamaEntity llamaEntity;
        ISummonable summonableCap;
        if (event.getEntity() instanceof LlamaEntity && (summonableCap = (ISummonable)(llamaEntity = (LlamaEntity)event.getEntity()).getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new)).getSummoner() != null) {
            llamaEntity.field_70715_bh.func_75776_a(1, (Goal)new LlamaOwnerHurtByTargetGoal(llamaEntity));
            llamaEntity.field_70715_bh.func_75776_a(2, (Goal)new LlamaOwnerHurtTargetGoal(llamaEntity));
            llamaEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)llamaEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
            llamaEntity.field_70714_bg.func_75776_a(2, (Goal)new LlamaFollowOwnerGoal(llamaEntity, 2.1, 10.0f, 2.0f, false));
        }
        if (event.getEntity() instanceof WolfEntity && (summonableCap = (ISummonable)(wolfEntity = (WolfEntity)event.getEntity()).getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new)).getSummoner() != null) {
            wolfEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)wolfEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        }
        if (event.getEntity() instanceof IronGolemEntity && (summonableCap = (ISummonable)(ironGolemEntity = (IronGolemEntity)event.getEntity()).getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new)).getSummoner() != null) {
            ironGolemEntity.field_70714_bg.func_75776_a(2, (Goal)new IronGolemFollowOwnerGoal(ironGolemEntity, 2.1, 10.0f, 2.0f, false));
            ironGolemEntity.field_70715_bh.func_75776_a(1, (Goal)new GolemOwnerHurtByTargetGoal(ironGolemEntity));
            ironGolemEntity.field_70715_bh.func_75776_a(2, (Goal)new GolemOwnerHurtTargetGoal(ironGolemEntity));
        }
        if (event.getEntity() instanceof BatEntity && (summonableCap = (ISummonable)(batEntity = (BatEntity)event.getEntity()).getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new)).getSummoner() != null) {
            batEntity.field_70714_bg.func_75776_a(1, (Goal)new BatFollowOwnerGoal(batEntity, 2.1, 10.0f, 2.0f, false));
            batEntity.field_70714_bg.func_75776_a(2, (Goal)new BatMeleeAttackGoal(batEntity, 1.0, true));
            batEntity.field_70715_bh.func_75776_a(1, (Goal)new BatOwnerHurtByTargetGoal(batEntity));
            batEntity.field_70715_bh.func_75776_a(2, (Goal)new BatOwnerHurtTargetGoal(batEntity));
            batEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)batEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        }
    }

    @SubscribeEvent
    public static void onSummonedMobAttemptsToAttack(LivingSetAttackTargetEvent event) {
        LivingEntity summonableMob;
        ISummonable attackerSummonableCap;
        if ((event.getEntityLiving() instanceof IronGolemEntity || event.getEntityLiving() instanceof WolfEntity || event.getEntityLiving() instanceof LlamaEntity) && (attackerSummonableCap = (ISummonable)(summonableMob = event.getEntityLiving()).getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new)).getSummoner() != null) {
            UUID targetsOwner;
            LivingEntity summonableTarget;
            ISummonable targetSummonableCap;
            UUID attackersOwner = attackerSummonableCap.getSummoner();
            if ((event.getTarget() instanceof IronGolemEntity || event.getTarget() instanceof WolfEntity || event.getTarget() instanceof LlamaEntity) && (targetSummonableCap = (ISummonable)(summonableTarget = event.getTarget()).getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new)).getSummoner() != null && (targetsOwner = targetSummonableCap.getSummoner()).equals(attackersOwner)) {
                if (summonableMob instanceof IronGolemEntity) {
                    IronGolemEntity ironGolemEntity = (IronGolemEntity)summonableMob;
                    ironGolemEntity.func_70624_b(null);
                    ironGolemEntity.func_70604_c(null);
                }
                if (summonableMob instanceof WolfEntity) {
                    WolfEntity wolfEntity = (WolfEntity)summonableMob;
                    wolfEntity.func_70624_b(null);
                    wolfEntity.func_70604_c(null);
                }
                if (summonableMob instanceof LlamaEntity) {
                    LlamaEntity llamaEntity = (LlamaEntity)summonableMob;
                    llamaEntity.func_70624_b(null);
                    llamaEntity.func_70604_c(null);
                }
                if (summonableMob instanceof BatEntity) {
                    BatEntity batEntity = (BatEntity)summonableMob;
                    batEntity.func_70624_b(null);
                    batEntity.func_70604_c(null);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onShielding(ProjectileImpactEvent event) {
        Effect shielding;
        LivingEntity livingEntity;
        EntityRayTraceResult entityRayTraceResult;
        Entity entity;
        if (event.getRayTraceResult() instanceof EntityRayTraceResult && (entity = (entityRayTraceResult = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).func_70660_b(shielding = CustomEffects.SHIELDING) != null && event.isCancelable()) {
            event.setCanceled(true);
            if (event.getEntity() instanceof AbstractArrowEntity) {
                AbstractArrowEntity arrowEntity = (AbstractArrowEntity)event.getEntity();
                AbilityUtils.ricochetArrowLikeShield(arrowEntity, livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onSouLProtection(LivingDeathEvent event) {
        if (event.getEntityLiving().func_70660_b(CustomEffects.SOUL_PROTECTION) != null) {
            event.setCanceled(true);
            event.getEntityLiving().func_70606_j(1.0f);
            event.getEntityLiving().func_195061_cb();
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76426_n, 900, 1));
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
        }
    }

    @SubscribeEvent
    public static void onArrowJoinWorld(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrowEntity;
        Entity shooter;
        if (event.getEntity() instanceof AbstractArrowEntity && (shooter = (arrowEntity = (AbstractArrowEntity)event.getEntity()).func_212360_k()) instanceof PlayerEntity) {
            int count;
            PlayerEntity playerEntity = (PlayerEntity)shooter;
            ICombo comboCap = (ICombo)playerEntity.getCapability(ComboProvider.COMBO_CAPABILITY).orElseThrow(IllegalStateException::new);
            if (comboCap.getFlamingArrowsCount() > 0) {
                count = comboCap.getFlamingArrowsCount();
                arrowEntity.func_70015_d(100);
                comboCap.setFlamingArrowsCount(--count);
            }
            if (comboCap.getTormentArrowCount() > 0) {
                arrowEntity.func_184211_a("TormentArrow");
                count = comboCap.getTormentArrowCount();
                arrowEntity.func_189654_d(true);
                arrowEntity.func_213317_d(arrowEntity.func_213322_ci().func_186678_a(0.5));
                comboCap.setTormentArrowCount(--count);
            }
        }
    }

    @SubscribeEvent
    public static void onTormentArrowImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrowEntity = event.getArrow();
        Entity shooter = arrowEntity.func_212360_k();
        if (!(shooter instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)shooter;
        if (arrowEntity.func_184216_O().contains("TormentArrow")) {
            if (arrowEntity.field_70173_aa > 1200) {
                arrowEntity.func_70106_y();
                event.setCanceled(true);
            }
            if (event.getRayTraceResult() instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)event.getRayTraceResult();
                Entity targetEntity = entityRayTraceResult.func_216348_a();
                if (!(targetEntity instanceof LivingEntity)) {
                    event.setCanceled(true);
                }
                int currentKnockbackStrength = EnchantUtils.enchantmentTagToLevel(arrowEntity, Enchantments.field_185310_v);
                arrowEntity.func_70240_a(currentKnockbackStrength + 1);
            }
            if (event.getRayTraceResult() instanceof BlockRayTraceResult) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onIceBlockFalling(LivingDamageEvent event) {
        if (event.getSource() instanceof SummonedFallingBlockDamageSource && event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            DungeonsGear.PROXY.spawnParticles((Entity)event.getEntityLiving(), ParticleTypes.field_197593_D);
            EffectInstance stun = new EffectInstance(CustomEffects.STUNNED, 100);
            EffectInstance nausea = new EffectInstance(Effects.field_76431_k, 100);
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 100, 4);
            event.getEntityLiving().func_195064_c(stun);
            event.getEntityLiving().func_195064_c(nausea);
            event.getEntityLiving().func_195064_c(slowness);
            ItemStack chestplate = attacker.func_184582_a(EquipmentSlotType.CHEST);
            boolean magicBoostingChestplateFlag = chestplate.func_77973_b() == ArmorList.SPLENDID_ROBE || chestplate.func_77973_b() instanceof SoulRobeItem || chestplate.func_77973_b() == ArmorList.CAVE_CRAWLER;
            float originalDamage = event.getAmount();
            if (magicBoostingChestplateFlag) {
                event.setAmount(originalDamage + originalDamage * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void checkSummonedMobIsDead(TickEvent.PlayerTickEvent event) {
        UUID summonedBat;
        UUID summonedLlama;
        UUID summonedWolf;
        UUID summonedGolem;
        Entity entity;
        PlayerEntity summoner = event.player;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!summoner.func_70089_S()) {
            return;
        }
        ISummoner summonerCap = (ISummoner)summoner.getCapability(SummonerProvider.SUMMONER_CAPABILITY).orElseThrow(IllegalStateException::new);
        if (summonerCap.getSummonedGolem() != null && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedGolem = summonerCap.getSummonedGolem())) instanceof IronGolemEntity)) {
            summonerCap.setSummonedGolem(null);
            ArtifactEvents.setArtifactCooldown(summoner, ArtifactList.GOLEM_KIT, 600);
        }
        if (summonerCap.getSummonedWolf() != null && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedWolf = summonerCap.getSummonedWolf())) instanceof WolfEntity)) {
            summonerCap.setSummonedWolf(null);
            ArtifactEvents.setArtifactCooldown(summoner, ArtifactList.TASTY_BONE, 600);
        }
        if (summonerCap.getSummonedLlama() != null && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedLlama = summonerCap.getSummonedLlama())) instanceof LlamaEntity)) {
            summonerCap.setSummonedLlama(null);
            ArtifactEvents.setArtifactCooldown(summoner, ArtifactList.WONDERFUL_WHEAT, 600);
        }
        if (summonerCap.getSummonedBat() != null && !((entity = ((ServerWorld)event.player.field_70170_p).func_217461_a(summonedBat = summonerCap.getSummonedBat())) instanceof BatEntity)) {
            summonerCap.setSummonedBat(null);
        }
    }

    @SubscribeEvent
    public static void onSummonableDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof IronGolemEntity || event.getEntityLiving() instanceof WolfEntity || event.getEntityLiving() instanceof LlamaEntity || event.getEntityLiving() instanceof BatEntity) {
            PlayerEntity summoner;
            LivingEntity livingEntity = event.getEntityLiving();
            World world = livingEntity.func_130014_f_();
            ISummonable summonableCap = (ISummonable)livingEntity.getCapability(SummonableProvider.SUMMONABLE_CAPABILITY).orElseThrow(IllegalStateException::new);
            if (summonableCap.getSummoner() != null && (summoner = world.func_217371_b(summonableCap.getSummoner())) != null) {
                ISummoner summonerCap = (ISummoner)summoner.getCapability(SummonerProvider.SUMMONER_CAPABILITY).orElseThrow(IllegalStateException::new);
                UUID summonableUUID = livingEntity.func_110124_au();
                if (summonerCap.getSummonedGolem() == summonableUUID) {
                    summonerCap.setSummonedGolem(null);
                    ArtifactEvents.setArtifactCooldown(summoner, ArtifactList.GOLEM_KIT, 600);
                }
                if (summonerCap.getSummonedWolf() == summonableUUID) {
                    summonerCap.setSummonedWolf(null);
                    ArtifactEvents.setArtifactCooldown(summoner, ArtifactList.TASTY_BONE, 600);
                }
                if (summonerCap.getSummonedLlama() == summonableUUID) {
                    summonerCap.setSummonedLlama(null);
                    ArtifactEvents.setArtifactCooldown(summoner, ArtifactList.WONDERFUL_WHEAT, 600);
                }
                if (summonerCap.getSummonedBat() == summonableUUID) {
                    summonerCap.setSummonedBat(null);
                }
            }
        }
    }

    public static void setArtifactCooldown(PlayerEntity playerIn, Item item, int cooldownInTicks) {
        ItemStack helmet = playerIn.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chestplate = playerIn.func_184582_a(EquipmentSlotType.CHEST);
        float armorCooldownModifier = helmet.func_77973_b() instanceof IArmor ? (float)((IArmor)helmet.func_77973_b()).getArtifactCooldown() : 0.0f;
        float armorCooldownModifier2 = chestplate.func_77973_b() instanceof IArmor ? (float)((IArmor)chestplate.func_77973_b()).getArtifactCooldown() : 0.0f;
        float totalArmorCooldownModifier = 1.0f - armorCooldownModifier * 0.01f - armorCooldownModifier2 * 0.01f;
        float cooldownEnchantmentReduction = 0.0f;
        if (EnchantUtils.hasEnchantment((LivingEntity)playerIn, ArmorEnchantmentList.COOLDOWN)) {
            int cooldownEnchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.COOLDOWN, (LivingEntity)playerIn);
            if (cooldownEnchantmentLevel == 1) {
                cooldownEnchantmentReduction = (int)(0.1f * (float)cooldownInTicks);
            }
            if (cooldownEnchantmentLevel == 2) {
                cooldownEnchantmentReduction = (int)(0.19f * (float)cooldownInTicks);
            }
            if (cooldownEnchantmentLevel == 3) {
                cooldownEnchantmentReduction = (int)(0.27f * (float)cooldownInTicks);
            }
        }
        playerIn.func_184811_cZ().func_185145_a(item, Math.max(0, (int)((float)cooldownInTicks * totalArmorCooldownModifier - cooldownEnchantmentReduction)));
    }
}

