/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.artifacts.corruptedbeacon;

import com.google.common.collect.Lists;
import com.infamous.dungeons_gear.entities.ModEntityTypes;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractBeamEntity
extends Entity {
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(AbstractArrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PIERCE_LEVEL = EntityDataManager.func_187226_a(AbstractArrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    public PickupStatus pickupStatus;
    public int beamShake;
    private int ticksInGround;
    private double damage;
    private int knockbackStrength;
    private SoundEvent hitSound;
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;
    private UUID shooterUUID;
    private int shooterEntityID;
    private boolean field_234611_d_;

    protected AbstractBeamEntity(EntityType<? extends AbstractBeamEntity> entityType, World world) {
        super(entityType, world);
        this.func_189654_d(true);
        this.pickupStatus = PickupStatus.DISALLOWED;
        this.damage = 1.0;
        this.hitSound = this.getHitEntitySound();
    }

    protected AbstractBeamEntity(EntityType<? extends AbstractBeamEntity> entityType, double x, double y, double z, World world) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
    }

    protected AbstractBeamEntity(EntityType<? extends AbstractBeamEntity> entityType, LivingEntity shooter, World world) {
        this(entityType, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), world);
        this.setShooter((Entity)shooter);
        if (shooter instanceof PlayerEntity) {
            this.pickupStatus = PickupStatus.ALLOWED;
        }
    }

    protected AbstractBeamEntity(World world) {
        super((EntityType)ModEntityTypes.BEAM.get(), world);
    }

    public void setHitSound(SoundEvent soundEvent) {
        this.hitSound = soundEvent;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double v) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return v < (d0 = d0 * 64.0 * AbstractBeamEntity.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(PIERCE_LEVEL, (Object)0);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d lvt_9_1_ = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(lvt_9_1_);
        float lvt_10_1_ = MathHelper.func_76133_a((double)AbstractBeamEntity.func_213296_b((Vec3d)lvt_9_1_));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)lvt_9_1_.field_72450_a, (double)lvt_9_1_.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)lvt_9_1_.field_72448_b, (double)lvt_10_1_) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(p_180426_7_, p_180426_8_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float lvt_7_1_ = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)lvt_7_1_) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
        this.ticksInGround = 0;
    }

    public void func_70071_h_() {
        Vec3d vector3d3;
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.field_234611_d_) {
            this.field_234611_d_ = this.func_234615_h_();
        }
        super.func_70071_h_();
        boolean isNoClip = this.getNoClip();
        Vec3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)AbstractBeamEntity.func_213296_b((Vec3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_180425_c())).isAir((IBlockReader)this.field_70170_p, blockpos) || isNoClip || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            vector3d3 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d3)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.beamShake > 0) {
            --this.beamShake;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround && !isNoClip) {
            if (this.inBlockState != blockstate && this.isInGroundButNotColliding()) {
                this.resetTicksInGround();
            } else if (!this.field_70170_p.field_72995_K) {
                this.updateTicksInGround();
            }
            ++this.timeInGround;
        } else {
            this.timeInGround = 0;
            Vec3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.getShooter();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !isNoClip && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onImpact((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d3 * (double)i / 4.0, this.func_226278_cu_() + d4 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)AbstractBeamEntity.func_213296_b((Vec3d)vector3d));
            this.field_70177_z = isNoClip ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70125_A = AbstractBeamEntity.func_234614_e_(this.field_70127_C, this.field_70125_A);
            this.field_70177_z = AbstractBeamEntity.func_234614_e_(this.field_70126_B, this.field_70177_z);
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.func_70090_H()) {
                // empty if block
            }
            this.func_213317_d(vector3d.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !isNoClip) {
                Vec3d vector3d4 = this.func_213322_ci();
                this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    private boolean isInGroundButNotColliding() {
        return this.inGround && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    private void resetTicksInGround() {
        this.inGround = false;
        Vec3d vector3d = this.func_213322_ci();
        this.func_213317_d(vector3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    public void func_213315_a(MoverType moverType, Vec3d vector3d) {
        super.func_213315_a(moverType, vector3d);
        if (moverType != MoverType.SELF && this.isInGroundButNotColliding()) {
            this.resetTicksInGround();
        }
    }

    protected void updateTicksInGround() {
        ++this.ticksInGround;
        if (this.ticksInGround >= 20) {
            this.func_70106_y();
        }
    }

    private void func_213870_w() {
        if (this.hitEntities != null) {
            this.hitEntities.clear();
        }
        if (this.piercedEntities != null) {
            this.piercedEntities.clear();
        }
    }

    protected void onEntityHit(EntityRayTraceResult entityRayTraceResult) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = entityRayTraceResult.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * this.damage), (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercedEntities.add(entity.func_145782_y());
        }
        if (this.getIsCritical()) {
            long j = this.field_70146_Z.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.getShooter()) == null) {
            damagesource = DamageSource.func_76354_b((Entity)this, (Entity)this);
        } else {
            damagesource = DamageSource.func_76354_b((Entity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (entity instanceof LivingEntity) {
                Vec3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.field_70170_p.field_72995_K || this.getPierceLevel() <= 0) {
                    // empty if block
                }
                if (this.knockbackStrength > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.beamHit(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
                if (!entity.func_70089_S() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingentity);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entity1;
                    if (this.hitEntities != null && this.getShotFromCrossbow()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, this.hitEntities, this.hitEntities.size());
                    } else if (!entity.func_70089_S() && this.getShotFromCrossbow()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, Arrays.asList(entity), 0);
                    }
                }
            } else {
                this.func_70106_y();
            }
            this.func_184185_a(this.hitSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.func_70106_y();
            }
        } else {
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.pickupStatus == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.getArrowStack(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected void hitGround(BlockRayTraceResult p_230299_1_) {
        this.inBlockState = this.field_70170_p.func_180495_p(p_230299_1_.func_216350_a());
        BlockState lvt_3_1_ = this.field_70170_p.func_180495_p(p_230299_1_.func_216350_a());
        Vec3d vector3d = p_230299_1_.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vec3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(this.getHitGroundSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.beamShake = 7;
        this.setIsCritical(false);
        this.setPierceLevel((byte)0);
        this.setHitSound(SoundEvents.field_191244_bn);
        this.setShotFromCrossbow(false);
        this.func_213870_w();
    }

    protected SoundEvent getHitEntitySound() {
        return SoundEvents.field_191244_bn;
    }

    protected final SoundEvent getHitGroundSound() {
        return this.hitSound;
    }

    protected void beamHit(LivingEntity livingEntity) {
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vec3d vector3d, Vec3d vector3d1) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)vector3d, (Vec3d)vector3d1, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::func_230298_a_);
    }

    protected boolean func_230298_a_(Entity entity) {
        return this.canCollideWith(entity) && (this.piercedEntities == null || !this.piercedEntities.contains(entity.func_145782_y()));
    }

    protected boolean canCollideWith(Entity entity) {
        if (!entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L()) {
            Entity shooter = this.getShooter();
            return shooter == null || this.field_234611_d_ || !shooter.func_184223_x(entity);
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        if (this.shooterUUID != null) {
            compoundNBT.func_186854_a("Owner", this.shooterUUID);
        }
        if (this.field_234611_d_) {
            compoundNBT.func_74757_a("LeftOwner", true);
        }
        compoundNBT.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compoundNBT.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compoundNBT.func_74774_a("shake", (byte)this.beamShake);
        compoundNBT.func_74757_a("inGround", this.inGround);
        compoundNBT.func_74774_a("pickup", (byte)this.pickupStatus.ordinal());
        compoundNBT.func_74780_a("damage", this.damage);
        compoundNBT.func_74757_a("crit", this.getIsCritical());
        compoundNBT.func_74774_a("PierceLevel", this.getPierceLevel());
        compoundNBT.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c((Object)this.hitSound).toString());
        compoundNBT.func_74757_a("ShotFromCrossbow", this.getShotFromCrossbow());
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_186855_b("Owner")) {
            this.shooterUUID = compoundNBT.func_186857_a("Owner");
        }
        this.field_234611_d_ = compoundNBT.func_74767_n("LeftOwner");
        this.ticksInGround = compoundNBT.func_74765_d("life");
        if (compoundNBT.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compoundNBT.func_74775_l("inBlockState"));
        }
        this.beamShake = compoundNBT.func_74771_c("shake") & 0xFF;
        this.inGround = compoundNBT.func_74767_n("inGround");
        if (compoundNBT.func_150297_b("damage", 99)) {
            this.damage = compoundNBT.func_74769_h("damage");
        }
        if (compoundNBT.func_150297_b("pickup", 99)) {
            this.pickupStatus = PickupStatus.getByOrdinal(compoundNBT.func_74771_c("pickup"));
        } else if (compoundNBT.func_150297_b("player", 99)) {
            this.pickupStatus = compoundNBT.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.setIsCritical(compoundNBT.func_74767_n("crit"));
        this.setPierceLevel(compoundNBT.func_74771_c("PierceLevel"));
        if (compoundNBT.func_150297_b("SoundEvent", 8)) {
            this.hitSound = Registry.field_212633_v.func_218349_b(new ResourceLocation(compoundNBT.func_74779_i("SoundEvent"))).orElse(this.getHitEntitySound());
        }
        this.setShotFromCrossbow(compoundNBT.func_74767_n("ShotFromCrossbow"));
    }

    public void setShooter(@Nullable Entity entity) {
        if (entity != null) {
            this.shooterUUID = entity.func_110124_au();
            this.shooterEntityID = entity.func_145782_y();
        }
        if (entity instanceof PlayerEntity) {
            this.pickupStatus = ((PlayerEntity)entity).field_71075_bZ.field_75098_d ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && (this.inGround || this.getNoClip()) && this.beamShake <= 0) {
            boolean flag;
            boolean bl = flag = this.pickupStatus == PickupStatus.ALLOWED || this.pickupStatus == PickupStatus.CREATIVE_ONLY && playerEntity.field_71075_bZ.field_75098_d || this.getNoClip() && this.getShooter().func_110124_au() == playerEntity.func_110124_au();
            if (this.pickupStatus == PickupStatus.ALLOWED) {
                flag = false;
            }
            if (flag) {
                this.func_70106_y();
            }
        }
        if (this.field_70173_aa > 0) {
            this.func_70106_y();
        }
    }

    protected abstract ItemStack getArrowStack();

    protected boolean func_225502_at_() {
        return false;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose pose, EntitySize entitySize) {
        return 0.13f;
    }

    public void setIsCritical(boolean isCritical) {
        this.setArrowFlag(1, isCritical);
    }

    public void setPierceLevel(byte pierceLevel) {
        this.field_70180_af.func_187227_b(PIERCE_LEVEL, (Object)pierceLevel);
    }

    private void setArrowFlag(int i, boolean b) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (b) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | i)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & ~i)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public boolean getShotFromCrossbow() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return (Byte)this.field_70180_af.func_187225_a(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity livingEntity, float v) {
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (LivingEntity)livingEntity);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)livingEntity);
        this.setDamage((double)(v * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.setDamage(this.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.setKnockbackStrength(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)livingEntity) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    public void setNoClip(boolean noClip) {
        this.field_70145_X = noClip;
        this.setArrowFlag(2, noClip);
    }

    public boolean getNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return ((Byte)this.field_70180_af.func_187225_a(CRITICAL) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.setArrowFlag(4, shotFromCrossbow);
    }

    public IPacket<?> func_213297_N() {
        Entity entity = this.getShooter();
        return new SSpawnObjectPacket((Entity)this, entity == null ? 0 : entity.func_145782_y());
    }

    @Nullable
    public Entity getShooter() {
        if (this.shooterUUID != null && this.field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(this.shooterUUID);
        }
        return this.shooterEntityID != 0 ? this.field_70170_p.func_73045_a(this.shooterEntityID) : null;
    }

    private boolean func_234615_h_() {
        Entity shooter = this.getShooter();
        if (shooter != null) {
            for (Entity entity2 : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> !entity.func_175149_v() && entity.func_70067_L())) {
                if (entity2.func_184208_bv() != shooter.func_184208_bv()) continue;
                return false;
            }
        }
        return true;
    }

    public void setArrowMotion(Entity entity, float rotationPitch, float yaw, float p_234612_4_, float p_234612_5_, float p_234612_6_) {
        float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitch * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)((rotationPitch + p_234612_4_) * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitch * ((float)Math.PI / 180)));
        this.shoot(x, y, z, p_234612_5_, p_234612_6_);
        Vec3d entityMotion = entity.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(entityMotion.field_72450_a, entity.field_70122_E ? 0.0 : entityMotion.field_72448_b, entityMotion.field_72449_c));
    }

    protected void onImpact(RayTraceResult rayTraceResult) {
        RayTraceResult.Type traceResultType = rayTraceResult.func_216346_c();
        if (traceResultType == RayTraceResult.Type.ENTITY) {
            this.onEntityHit((EntityRayTraceResult)rayTraceResult);
        } else if (traceResultType == RayTraceResult.Type.BLOCK) {
            this.func_70106_y();
        }
    }

    protected void func_234617_x_() {
        Vec3d lvt_1_1_ = this.func_213322_ci();
        float lvt_2_1_ = MathHelper.func_76133_a((double)AbstractBeamEntity.func_213296_b((Vec3d)lvt_1_1_));
        this.field_70125_A = AbstractBeamEntity.func_234614_e_(this.field_70127_C, (float)(MathHelper.func_181159_b((double)lvt_1_1_.field_72448_b, (double)lvt_2_1_) * 57.2957763671875));
        this.field_70177_z = AbstractBeamEntity.func_234614_e_(this.field_70126_B, (float)(MathHelper.func_181159_b((double)lvt_1_1_.field_72450_a, (double)lvt_1_1_.field_72449_c) * 57.2957763671875));
    }

    protected static float func_234614_e_(float v, float v1) {
        while (v1 - v < -180.0f) {
            v -= 360.0f;
        }
        while (v1 - v >= 180.0f) {
            v += 360.0f;
        }
        return MathHelper.func_219799_g((float)0.2f, (float)v, (float)v1);
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus getByOrdinal(int i) {
            if (i < 0 || i > PickupStatus.values().length) {
                i = 0;
            }
            return PickupStatus.values()[i];
        }
    }
}

