/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.capabilities;

import com.infamous.dungeons_gear.capabilities.combo.ComboProvider;
import com.infamous.dungeons_gear.capabilities.summoning.SummonableProvider;
import com.infamous.dungeons_gear.capabilities.summoning.SummonerProvider;
import com.infamous.dungeons_gear.capabilities.weapon.WeaponProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class CapabilityHandler {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (CapabilityHandler.isSummonableEntity((Entity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_gear", "summonable"), (ICapabilityProvider)new SummonableProvider());
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("dungeons_gear", "combo"), (ICapabilityProvider)new ComboProvider());
            event.addCapability(new ResourceLocation("dungeons_gear", "summoner"), (ICapabilityProvider)new SummonerProvider());
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        event.addCapability(new ResourceLocation("dungeons_gear", "weapon"), (ICapabilityProvider)new WeaponProvider());
    }

    private static boolean isSummonableEntity(Entity entity) {
        return entity instanceof IronGolemEntity || entity instanceof WolfEntity || entity instanceof LlamaEntity || entity instanceof BatEntity;
    }
}

