/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.combat;

import com.infamous.dungeons_gear.combat.NetworkHandler;
import com.infamous.dungeons_gear.combat.PacketLongReachAttack;
import com.infamous.dungeons_gear.combat.PacketOffhandAttack;
import com.infamous.dungeons_gear.interfaces.IExtendedAttackReach;
import com.infamous.dungeons_gear.interfaces.IOffhandAttack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CombatEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onMouseEvent(InputEvent.MouseInputEvent ev) {
        KeyBinding keyAttack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
        if (ev.getButton() == keyAttack.getKey().func_197937_c() && ev.getAction() == 1) {
            CombatEventHandler.checkForReachAttack();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onKeyEvent(InputEvent.KeyInputEvent ev) {
        KeyBinding keyAttack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
        if (ev.getKey() == keyAttack.getKey().func_197937_c() && ev.getAction() == 1) {
            CombatEventHandler.checkForReachAttack();
        }
    }

    public static void checkForOffhandAttack() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71462_r == null && !Minecraft.func_71410_x().func_147113_T() && player != null && !player.func_184585_cz()) {
            ItemStack offhand = player.func_184592_cb();
            ItemStack mainhand = player.func_184614_ca();
            if (offhand.func_77973_b() instanceof IOffhandAttack) {
                EntityRayTraceResult entityRayTrace;
                Entity entityHit;
                RayTraceResult rayTrace;
                IOffhandAttack offhandWeapon = (IOffhandAttack)offhand.func_77973_b();
                float reach = offhandWeapon.getOffhandAttackReach();
                if (player.func_184812_l_()) {
                    reach = (float)((double)reach + 2.0);
                }
                if ((rayTrace = CombatEventHandler.getEntityMouseOverExtended(reach)) instanceof EntityRayTraceResult && (entityHit = (entityRayTrace = (EntityRayTraceResult)rayTrace).func_216348_a()) != null && entityHit != player && entityHit != player.func_184187_bx()) {
                    NetworkHandler.sendPacketToServer(new PacketOffhandAttack(entityHit.func_145782_y()));
                }
            }
        }
    }

    private static void checkForReachAttack() {
        EntityRayTraceResult entityRayTrace;
        Entity entityHit;
        IExtendedAttackReach longReachWeapon;
        float reach;
        RayTraceResult rayTrace;
        ItemStack weapon;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71462_r == null && !Minecraft.func_71410_x().func_147113_T() && player != null && !player.func_184585_cz() && (weapon = player.func_184614_ca()).func_77973_b() instanceof IExtendedAttackReach && (rayTrace = CombatEventHandler.getEntityMouseOverExtended(reach = (longReachWeapon = (IExtendedAttackReach)weapon.func_77973_b()).getAttackReach())) instanceof EntityRayTraceResult && (entityHit = (entityRayTrace = (EntityRayTraceResult)rayTrace).func_216348_a()) != null && entityHit.field_70172_ad == 0 && entityHit != player && entityHit != player.func_184187_bx()) {
            NetworkHandler.sendPacketToServer(new PacketLongReachAttack(entityHit.func_145782_y()));
        }
    }

    private static RayTraceResult getEntityMouseOverExtended(float reach) {
        BlockRayTraceResult result = null;
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.field_175622_Z;
        if (viewEntity != null && mc.field_71441_e != null) {
            double reachDistance = reach;
            RayTraceResult rayTrace = viewEntity.func_213324_a(reachDistance, 0.0f, false);
            Vec3d eyePos = viewEntity.func_174824_e(0.0f);
            boolean hasExtendedReach = false;
            double attackReach = reachDistance;
            if (mc.field_71442_b.func_78749_i() && reachDistance < 6.0) {
                reachDistance = attackReach = 6.0;
            } else if (reachDistance > (double)reach) {
                hasExtendedReach = true;
            }
            attackReach = rayTrace.func_216347_e().func_72436_e(eyePos);
            Vec3d lookVec = viewEntity.func_70676_i(1.0f);
            Vec3d attackVec = eyePos.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
            AxisAlignedBB axisAlignedBB = viewEntity.func_174813_aQ().func_216361_a(lookVec.func_186678_a(reachDistance)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityRayTrace = ProjectileHelper.func_221273_a((Entity)viewEntity, (Vec3d)eyePos, (Vec3d)attackVec, (AxisAlignedBB)axisAlignedBB, entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)attackReach);
            if (entityRayTrace != null) {
                Vec3d hitVec = entityRayTrace.func_216347_e();
                double squareDistanceTo = eyePos.func_72436_e(hitVec);
                if (hasExtendedReach && squareDistanceTo > (double)(reach * reach)) {
                    result = BlockRayTraceResult.func_216352_a((Vec3d)hitVec, (Direction)Direction.func_210769_a((double)lookVec.field_72450_a, (double)lookVec.field_72448_b, (double)lookVec.field_72449_c), (BlockPos)new BlockPos(hitVec));
                } else if (squareDistanceTo < attackReach) {
                    result = entityRayTrace;
                }
            } else {
                result = BlockRayTraceResult.func_216352_a((Vec3d)attackVec, (Direction)Direction.func_210769_a((double)lookVec.field_72450_a, (double)lookVec.field_72448_b, (double)lookVec.field_72449_c), (BlockPos)new BlockPos(attackVec));
            }
        }
        return result;
    }
}

