/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.armor;

import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.ArmorEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.HealthAbilityEnchantment;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class CowardiceEnchantment
extends HealthAbilityEnchantment {
    public CowardiceEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.ARMOR, new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof HealthAbilityEnchantment);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (player.func_70089_S()) {
            float maxHealth = player.func_110138_aP();
            float currentHealth = player.func_110143_aJ();
            if (currentHealth == maxHealth && EnchantUtils.hasEnchantment((LivingEntity)player, ArmorEnchantmentList.COWARDICE)) {
                int cowardiceLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.COWARDICE, (LivingEntity)player);
                EffectInstance strengthBoost = new EffectInstance(Effects.field_76420_g, 0, cowardiceLevel + 1);
                player.func_195064_c(strengthBoost);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        PlayerEntity playerEntity;
        AbstractArrowEntity arrowEntity;
        Entity shooterEntity;
        if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76364_f() instanceof AbstractArrowEntity && (shooterEntity = (arrowEntity = (AbstractArrowEntity)event.getSource().func_76364_f()).func_212360_k()) instanceof PlayerEntity && (playerEntity = (PlayerEntity)arrowEntity.func_212360_k()) != null && playerEntity.func_110143_aJ() == playerEntity.func_110138_aP() && EnchantUtils.hasEnchantment((LivingEntity)playerEntity, ArmorEnchantmentList.COWARDICE)) {
            int cowardiceLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.COWARDICE, (LivingEntity)playerEntity);
            float originalDamage = event.getAmount();
            event.setAmount(originalDamage + originalDamage * 0.1f + originalDamage * 0.1f * (float)cowardiceLevel);
        }
    }
}

