/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.enchantments.armor;

import com.infamous.dungeons_gear.capabilities.combo.ComboProvider;
import com.infamous.dungeons_gear.capabilities.combo.ICombo;
import com.infamous.dungeons_gear.enchantments.ModEnchantmentTypes;
import com.infamous.dungeons_gear.enchantments.lists.ArmorEnchantmentList;
import com.infamous.dungeons_gear.enchantments.types.DropsEnchantment;
import com.infamous.dungeons_gear.utilties.EnchantUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class RecyclerEnchantment
extends DropsEnchantment {
    public RecyclerEnchantment() {
        super(Enchantment.Rarity.RARE, ModEnchantmentTypes.ARMOR, new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET});
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof DropsEnchantment);
    }

    @SubscribeEvent
    public static void onPlayerDamaged(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (player.func_70089_S() && event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            ICombo comboCap = (ICombo)player.getCapability(ComboProvider.COMBO_CAPABILITY).orElseThrow(IllegalStateException::new);
            if (EnchantUtils.hasEnchantment((LivingEntity)player, ArmorEnchantmentList.RECYCLER)) {
                int arrowsInCounter = comboCap.getArrowsInCounter();
                comboCap.setArrowsInCounter(++arrowsInCounter);
                int recyclerLevel = EnchantmentHelper.func_185284_a((Enchantment)ArmorEnchantmentList.RECYCLER, (LivingEntity)player);
                if (comboCap.getArrowsInCounter() >= 40 - 10 * recyclerLevel) {
                    ItemEntity arrowDrop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_151032_g, 10));
                    player.field_70170_p.func_217376_c((Entity)arrowDrop);
                    comboCap.setArrowsInCounter(0);
                }
            }
        }
    }
}

